<?php
session_start();
require_once 'functions.php';
sanitizeArray($_POST);
require 'commonConv.php';

//############## Inserimento nel vettore (riga per riga)
$codice=$_POST['codice'];
$_SESSION['codice']=trim($codice);

$riga = array_map('trim', explode(PHP_EOL, $codice));
$riga = array_values(array_filter($riga));

for ($key=0; $key<count($riga); ++$key)
    $riga[$key]=$riga[$key].PHP_EOL;
$k=count($riga);

//LIMIT INSTR AMOUNT
if($k>1000)
{
    $k=1000;
    $riga = array_slice($riga, $k);
}

//############## Decodifica dell'istruzioni e rilocazione delle label

$ERR='';
$indice=0;
$indice2=0;

while($indice<$k)
{
    $a=(strpos($riga[$indice],':',1) ? strpos($riga[$indice],':',1)+1 : 0); //a!=0 -> label
    if ($a==0)
    {
        // Controllo sulla riga vuota o commento
        if (ord($riga[$indice])!=13 && ord($riga[$indice])!=35)
        {
            $a=decodeIstr($riga[$indice]); // Decodifica della istruzione

            if ($a!='ERR')
            {
                $riga[$indice2]=$a; // Salva nel vettore
            }
            else
            {
                $ERR='ERRORE: Istruzione riga '.($indice+1); // Caso dell'errore
                break;

            }
            $indice2=$indice2+1;
        }
    }
    else
    {
        //####### Caso della Label
        $a=substr($riga[$indice],0,$a-1);
        if(!isset($dimTabRil)) $dimTabRil=0;
        $tabRil[$dimTabRil]=$indice2.'|'.$a; // Inserimento della label nella tab. di riloc.
        $dimTabRil=$dimTabRil+1;
    }
    $indice=$indice+1;
}
//var_dump($tabRil,$dimTabRil);

//######## Sost. delle label con indirizzi corispondenti
$indice=0;
while($indice<$indice2)
{
    $a=(strpos($riga[$indice],':',1) ? strpos($riga[$indice],':',1)+1 : 0);
    if ($a!=0)
    {
        $b=substr($riga[$indice],$a);
        $c2=substr($riga[$indice],0,$a-1);
        $b=trim($b);
        $b=cLabel($b,$tabRil,$dimTabRil);

        if ($b=='ERR')
        {
            if ($ERR=='')
                $ERR='ERRORE: Label non esistente: '.explode(':',$riga[$indice])[1];
            break;
        }

        $b=intval($b);
        if (strlen($c2)>6)
        {
            $b=IntToBin($b,16,1);
        }
        else
        {
            $b=IntToBin($b,26,1);
        }

        $riga[$indice]=$c2.$b;
    }

    $indice=$indice+1;
}

require 'init.php';
?>
<html>
<head>
    <title>WebMIPS - MIPS CPU PIPELINED DATAPATH SIMULATION On Line</title>
    <meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1'>
    <link href='styles.css' rel='stylesheet' type='text/css'>
</head>
<body leftmargin='0' topmargin='0' marginwidth='0' marginheight='0' bgcolor='#666666'>
<?php
//######## In caso dell'errore stampa il messaggio
if ($ERR!='')
{

    print '<div align=center><br><font size=2 face=arial color=red><b>';
    print $ERR;
    print '</b></font></div>';
    exit();

    ?>
    <br>
    <div align='center'>
        <form action='schema.php' method='post' target='Body' ID='Form1'>
            <input type='submit' value='Esegui Programma' name='esegui' class='form' ID='Submit1'>
        </form>
    </div>
    <?php
//######## Altrimenti, stampa la lista
}
else
{
    $riga[$indice2]='00000000000000000000000000000000';
    $riga[$indice2+1]='00000000000000000000000000000000';
    $riga[$indice2+2]='00000000000000000000000000000000';
    $riga[$indice2+3]='00000000000000000000000000000000';
    $riga[$indice2+4]='00000000000000000000000000000000';
    $_SESSION['MemIstr']=$riga;
    $_SESSION['MemIstrDim']=$indice2;
}


$_SESSION['destra']='';
header('Location: destra.php');
?>

