#include <stdio.h>
#include "miracl.h"

void dh (char* param_file)
{
    big a,b,p,q,pa,pb,key;
    miracl* mip=mirsys(5000,0);
    FILE* fp;
    a=mirvar(0);
    b=mirvar(0);
    q=mirvar(0);
    key=mirvar(0);
    pa=mirvar(0);
    pb=mirvar(0);
    p=mirvar(0);
    mip->IOBASE=16;
      
    /* printf("Diffie-Hellman Key exchange \n"); */
    
    fp=fopen(param_file, "r");
    /* reads prime suitable for dh from a file */
    cinnum(p,fp);
    cotnum(p,stdout);
    fclose(fp);
    printf("\nAlice's offline calculation...\n");        
    bigdig(160,2,a); /*generates a base 2 random big number of 160 digits (bits) */
    powltr(3,a,p,pa); /*pa=(3^a)mod p */
    /* 3 generates the sub-group of prime order (p-1)/2 */
    
    printf("\nBob's offline calculation...\n");        
    bigdig(160,2,b);
    powltr(3,b,p,pb);  /*pb=(3^b)mod p*/ 
    printf("\nAlice calculates Key=\n"); 
    powmod(pb,a,p,key); /*key=(pb^a)mod p = (3^ab)mod p*/ 
    cotnum(key,stdout);
    
    printf("\nwriting key in file dh.key ...\n");
    fp=fopen("dh.key", "w");
    cotnum (key,fp);
    fclose(fp);
	
    printf("\nBob calculates Key=\n");
    powmod(pa,b,p,key);  /*key=(pa^b)mod p = (3^ab)mod p */
    cotnum(key,stdout);
    
    printf("\nAlice's and Bob's key should be the same!\n");
}

int main (int argc, char** argv)
{
  char* parameters=argv[1];
  if (argc!=2) {
    printf("Number of arguments incorrect!\n");
    return 1;
  }
  dh(parameters);
  return 0;
}

