#include <stdio.h>
#include "miracl.h"
#include <stdlib.h>
#include <string.h>

static long seed=6457356;

void dssgen (char* param_file)
{
/* generates one set of public and private keys in files 
 *   public.dss and private.dss respectively */
   
    FILE *fp;
    big p,q,g,x,y;
    miracl *mip=mirsys(1000,0);
    p=mirvar(0);
    q=mirvar(0);
    g=mirvar(0);
    x=mirvar(0);
    y=mirvar(0);
    
    /* get common data p,q,g */
    fp=fopen(param_file,"r");
    if (fp==NULL)
    {
        printf("\nparameter file does not exist\n");
        return;
    }

    mip->IOBASE=16;
    cinnum(p,fp);
    cinnum(q,fp);
    cinnum(g,fp);
    fclose(fp);
    
    irand(seed); /* initialize random number generator */
    bigrand(q,x); /* generate private key */
    powmod(g,x,p,y); /* generate public key */
   
    fp=fopen("private.dss","w");
    cotnum(x,fp);
    fclose(fp);
    printf("\nprivate key is:  ");
    cotnum(x,stdout);
    printf("\nand can be seen in private.dss file also\n");
       
    fp=fopen("public.dss","w");
    cotnum(y,fp);
    fclose(fp);
    printf("\npublic key is:  ");
    cotnum(y,stdout);
    printf("\nand can be seen in public.dss file also\n");
    return;
}

void strip(char *name)
{
    /* strip off filename extension */
    int i;
    for (i=0;name[i]!='\0';i++)
    {
        if (name[i]!='.') continue;
        name[i]='\0';
        break;
    }
}

void hashing(FILE *fp,big hash)
{ 
    /* compute hash function */
    char h[20];
    int ch;
    sha sh;
    shs_init(&sh);
    while ((ch=fgetc(fp))!=EOF) shs_process(&sh,ch);
    shs_hash(&sh,h);
    bytes_to_big(20,h,hash);
}

void dssign(char* param_file, char* file_to_sign)
{
    FILE *fp;
    char ofname[50];
    big p,q,g,x,r,s,k,hash;
    miracl* mip=mirsys(1000,0);
    p=mirvar(0);
    q=mirvar(0);
    g=mirvar(0);
    x=mirvar(0);
    r=mirvar(0);
    s=mirvar(0);
    k=mirvar(0);
    hash=mirvar(0);

    mip->IOBASE=16;
    fp=fopen(param_file,"r");
    if (fp==NULL)
    {
        printf("\nparameter file does not exist\n");
        return;
    }
    cinnum(p,fp);
    cinnum(q,fp);
    cinnum(g,fp);
    fclose(fp);

    irand(seed);  /* initialize random number generator */
    bigrand(q,k); /* calculate r */
    powmod(g,k,p,r);   
    divide(r,q,q);


    /* get private key of signer */
    fp=fopen("private.dss","r");
    if (fp==NULL)
    {
        printf("\nprivate-key file does not exist\n");
        return;
    }
    cinnum(x,fp);
    fclose(fp);
    
    printf("\nsigning file %s ...\n",file_to_sign);
    
    /* calculate message digest */
    
    strcpy(ofname,file_to_sign);
    strip(ofname);
    strcat(ofname,".dss");
    if ((fp=fopen(file_to_sign,"rb"))==NULL)
    {
        printf("Unable to open file %s\n",file_to_sign);
        return;
    }
    hashing(fp,hash);
    fclose(fp);

    /* calculate s */
    xgcd(k,q,k,k,k);
    mad(x,r,hash,q,q,s);
    mad(s,k,k,q,q,s);
    fp=fopen(ofname,"w");
    cotnum(r,fp);
    cotnum(s,fp);
    fclose(fp);
    printf("\nsignature is in the file %s\n",ofname);
    return;
}

void dssver(char* param_file, char* file_to_verify)

    /* verifies a the signature given to a file_to_verify in
     <file>.dss generated by function dssign */
{
    FILE *fp;
    char ofname[50];
    big p,q,g,y,v,u1,u2,r,s,hash;
    int bits;
    miracl *mip=mirsys(1000,0);

    fp=fopen(param_file,"r");
    if (fp==NULL)
    {
        printf("parameter file does not exist\n");
        return;
    }

    fscanf(fp,"%d\n",&bits);
    p=mirvar(0);
    q=mirvar(0);
    g=mirvar(0);
    y=mirvar(0);
    v=mirvar(0);
    u1=mirvar(0);
    u2=mirvar(0);
    s=mirvar(0);
    r=mirvar(0);
    hash=mirvar(0);

    mip->IOBASE=16;
    cinnum(p,fp);
    cinnum(q,fp);
    cinnum(g,fp);
    fclose(fp);

/* get public key of signer */
    fp=fopen("public.dss","r");
    if (fp==NULL)
    {
        printf("public-key file does not exist\n");
        return;
    }
    cinnum(y,fp);
    fclose(fp);

    strcpy(ofname,file_to_verify);
    strip(ofname);
    strcat(ofname,".dss");
    if ((fp=fopen(file_to_verify,"rb"))==NULL)
    { /* no message */
        printf("Unable to open file %s\n", file_to_verify);
        return;
    }

    hashing(fp,hash);
    fclose(fp);
    fp=fopen(ofname,"r");
    if (fp==NULL)
    { /* no signature */
        printf("signature file %s does not exist\n",ofname);
        return;
    }
    printf("\nverifying signature of the file %s ...\n",ofname);
    
    cinnum(r,fp);
    cinnum(s,fp);
    fclose(fp);
    if (compare(r,q)>=0 || compare(s,q)>=0)
    {
        printf("\nsignature is NOT verified\n");
        return;
    }
    xgcd(s,q,s,s,s);
    mad(hash,s,s,q,q,u1);
    mad(r,s,s,q,q,u2);
    powmod2(g,u1,y,u2,p,v);
    divide(v,q,q);
    if (compare(v,r)==0) printf("\nsignature is verified\n");
    else                 printf("\nsignature is NOT verified\n");
    return;
}


int main (int argc, char** argv) {
  
  char* param_file=argv[1];
  char* file2=argv[2];
  if (argc!=3) {
    printf("Number of arguments incorrect!\n");
    return 1;
  }
 
  dssgen(param_file);
  dssign(param_file, file2);
  dssver(param_file, file2);
  return 0;
}