#include <stdio.h>
#include "miracl.h"

/* Diffie-Hellman key exchange over GF(2m) pseudorandom elliptic curves
*  curve is y^2 + xy = x^3 + x^2 + b, where b and irreducible polynomial parameters are given in the parameter_file */

void ecdhb(char* parameter_file)
{
    FILE* fp;
    char line[100];
    int i,ia,ib,m[4];
    epoint *g,*ea,*eb;
    int c,d,e,f;
    big a,b,x,y,key,p,pa,pb,n[4];
    miracl *mip=mirsys(100,0);
    a=mirvar(1);
    b=mirvar(0);
    x=mirvar(0);
    y=mirvar(0);
    key=mirvar(0);
    p=mirvar(0);
    pa=mirvar(0);
    pb=mirvar(0);
    for(i=0;i<4;i++) n[i]=mirvar(0);
    if((fp=fopen(parameter_file,"r"))==NULL)
    {
      printf("unable to open parameter file!\n");
      return;
    }
    mip->IOBASE=10;
    for (i=0;i<4;i++)
    {
    cinnum(n[i],fp);
    m[i]=size(n[i]);
    }
    mip->IOBASE=16;
    cinnum(b,fp);     
    ecurve2_init(m[0],m[1],m[2],m[3],a,b,FALSE,MR_PROJECTIVE);
    g=epoint2_init();
    cinnum(x,fp);
    cinnum(y,fp);
    fclose(fp);
    epoint2_set(x,y,0,g);
    ea=epoint2_init();
    eb=epoint2_init();
    epoint2_copy(g,ea);
    epoint2_copy(g,eb);

    printf("\nGF(2^m) elliptic curve Diffie-Hellman key exchange\n");
    
    printf("\nAlice's offline calculation\n");        
    bigdig(160,2,a);
    ecurve2_mult(a,ea,ea);
    epoint2_get(ea,pa,pa);
   
    printf("\nBob's offline calculation\n");        
    bigdig(160,2,b);
    ecurve2_mult(b,eb,eb);
    epoint_get(eb,pb,pb);
    
    printf("\nAlice calculates Key=\n");
    ecurve2_mult(a,eb,eb);
    epoint2_get(eb,key,key);
    cotnum(key,stdout);

    printf("\nBob calculates Key=\n");
    ecurve2_mult(b,ea,ea);
    epoint2_get(ea,key,key);
    cotnum(key,stdout);
    
    printf("\nputting key in ecdhb.key file ...\n");
    fp=fopen("ecdhb.key","w");
    cotnum(key,fp);
    fclose(fp);

    printf("\nAlice and Bob's keys should be the same!\n");

    epoint2_free(g);
    epoint2_free(ea);
    epoint2_free(eb);
    
}

int main(int argc, char** argv) {
 char* file=argv[1];
 if (argc!=2) {
   printf ("Number of arguments incorrect!\n");
   return 1;
 }
 ecdhb(file);
 return 0;
 }

