#include <stdio.h>
#include "miracl.h"

/* Diffie-Hellman key exchange over GF(p) elliptic curves
*  curve is y^2=x^3+ax+b mod p, where a=-3, b and p are given in the parameter_file */

void ecdhp(char* parameter_file)
{
    FILE* fp;
    int ia,ib;
    epoint *g,*ea,*eb;
    big a,b,x,y,key,p,pa,pb;
    miracl *mip=mirsys(100,0);
    a=mirvar(0);
    b=mirvar(0);
    x=mirvar(0);
    y=mirvar(0);
    key=mirvar(0);
    p=mirvar(0);
    pa=mirvar(0);
    pb=mirvar(0);
    convert(-3,a);
    if((fp=fopen(parameter_file,"r"))==NULL)
    {
      printf("unable to open parameter file!\n");
      return;
    }
    mip->IOBASE=10;
    cinnum(p,fp);
    mip->IOBASE=16;
    cinnum(b,fp);      
    ecurve_init(a,b,p,MR_PROJECTIVE);
    g=epoint_init();
    cinnum(x,fp);
    cinnum(y,fp);
    fclose(fp);
    epoint_set(x,y,0,g);
    ea=epoint_init();
    eb=epoint_init();
    epoint_copy(g,ea);
    epoint_copy(g,eb);

    
    printf("\nGF(p) elliptic curve Diffie-Hellman key-exchange\n");
    printf("\nAlice's offline calculation\n");        
    bigdig(160,2,a);
    ecurve_mult(a,ea,ea);
    ia=epoint_get(ea,pa,pa); /* <ia,pa> is compressed form of public key */

    printf("\nBob's offline calculation\n");        
    bigdig(160,2,b);
    ecurve_mult(b,eb,eb);
    ib=epoint_get(eb,pb,pb); /* <ib,pb> is compressed form of public key */
    
    printf("\nAlice calculates Key=\n");
    epoint_set(pb,pb,ib,eb); /* decompress eb */
    ecurve_mult(a,eb,eb);
    epoint_get(eb,key,key);
    cotnum(key,stdout);
    
    printf("\nPutting key in file ecdhp.key ...\n");
    fp=fopen("ecdhp.key","w");
    cotnum(key,fp);
    fclose(fp);
    
    printf("\nBob calculates Key=\n");
    epoint_set(pa,pa,ia,ea); /* decompress ea */
    ecurve_mult(b,ea,ea);
    epoint_get(ea,key,key);
    cotnum(key,stdout);

    printf("\nAlice and Bob's keys should be the same!\n");

    epoint_free(g);
    epoint_free(ea);
    epoint_free(eb);
    
}

int main(int argc, char** argv) {
  char* file=argv[1];
  if (argc!=2) {
    printf("Number of arguments incorrect!\n");
    return 1;
  }
  ecdhp(file);
  return 0;
  }

