#include <stdio.h>
#include "miracl.h"


void ecelgb (char *parameter_file)
{
    /* GF(2^m) elliptic curve ElGamal key generation 
    * puts private and public keys in files ecelgprivate.key and ecelgpublic.key, respectively */
   
    FILE* fp;
    int i,ia,m[4];
    epoint *base_point,*public_key, *private_key, *aux1,*aux2;
    big p,a,b,x,y,z,r,n[4];
    miracl *mip=mirsys(150,0);
    x=mirvar(0);
    y=mirvar(0);
    p=mirvar(0);
    a=mirvar(1);
    b=mirvar(0);
    r=mirvar(0);
    z=mirvar(0);
    for(i=0;i<4;i++) n[i]=mirvar(0);
    base_point=epoint2_init();
    public_key=epoint2_init();
    private_key=epoint2_init();
    aux1=epoint2_init();
    aux2=epoint2_init();
    
    if((fp=fopen(parameter_file,"r"))==NULL)
    {
      printf("unable to open parameter file!\n");
      return;
    }
    mip->IOBASE=10;
    for (i=0;i<4;i++)
    {
    cinnum(n[i],fp);
    m[i]=size(n[i]);
    }
    mip->IOBASE=16;
    cinnum(b,fp);     
    ecurve2_init(m[0],m[1],m[2],m[3],a,b,TRUE,MR_AFFINE);
    cinnum(x,fp);
    cinnum(y,fp);
    fclose(fp);
    printf("\nbase point to be encrypted is:\n");
    cotnum(x,stdout);
    cotnum(y,stdout);
    
    epoint2_set(x,y,0,base_point); 
    bigdig(160,2,a);
    
    fp=fopen("ecelgprivate.key","w");
    cotnum(a,fp);
    fclose(fp);
    printf("\nprivate key is:   ");
    cotnum(a,stdout);
    printf("\nand can be seen also in ecelgprivate.key file\n");
    
    ecurve2_mult(a,base_point,public_key);
    epoint2_get(public_key,z,z);
    fp=fopen("ecelgpublic.key","w");
    cotnum(z,fp);
    fclose(fp);
    printf("\npublic key is:  ");
    cotnum(z,stdout);
    printf("\nand can be seen also in the ecelgpublic.key file\n");
    
    printf("\nencrypting base point...\n");
    bigdig(160,2,r);
    ecurve2_mult(r,base_point,aux1);
    ecurve2_mult(r,public_key,aux2);
    
    printf("\ndecrypting base point..\n");
    
    ecurve2_add(base_point,aux2); 
    ecurve2_mult(a,aux1,aux1);
    ecurve2_sub(aux1,aux2);
    epoint2_get(aux2,x,y);
    printf("\ndecrypted point is:\n");
    cotnum(x,stdout);
    cotnum(y,stdout);
    
    epoint2_free(base_point);
    epoint2_free(public_key);
    epoint2_free(private_key);
    epoint2_free(aux1);
    epoint2_free(aux2);
   }
   
   int main (int argc, char** argv) {
    char* file=argv[1];
    if (argc!=2) {
      printf ("Number of arguments incorrect!\n");
      return 1;
    }
    ecelgb(file);
    return 0;
    }
