#include <stdio.h>
#include "miracl.h"


void ecelgp (char *parameter_file)
{
    /* Elliptic curve ElGamal key generation */
    /* puts private and public keys in files ecelgprivate.key and ecelgpublic.key, respectively */
   
    FILE* fp;
    int i,ia;
    epoint *base_point,*public_key, *private_key, *aux1,*aux2;
    big p,a,b,x,y,z,r;
    miracl *mip=mirsys(150,0);
    x=mirvar(0);
    y=mirvar(0);
    p=mirvar(0);
    a=mirvar(0);
    b=mirvar(0);
    r=mirvar(0);
    z=mirvar(0);
    convert(-3,a);
    base_point=epoint_init();
    public_key=epoint_init();
    private_key=epoint_init();
    aux1=epoint_init();
    aux2=epoint_init();
    
    printf("\ninitializing curve parameters...\n");
    
    if((fp=fopen(parameter_file,"r"))==NULL)
    {
      printf ("unable to open parameter file\n");
      return;
    }
    mip->IOBASE=10;
    cinnum(p,fp);
    mip->IOBASE=16;
    cinnum(b,fp);
    ecurve_init(a,b,p,MR_AFFINE);
    cinnum(x,fp);
    cinnum(y,fp);
    fclose(fp);
    printf("\nbase point to be encrypted is:\n");
    cotnum(x,stdout);
    cotnum(y,stdout);
    
    epoint_set(x,y,0,base_point); 
    bigdig(160,2,a);
    fp=fopen("ecelgprivate.key","w");
    cotnum(a,fp);
    fclose(fp);
    printf("\nprivate key is:   ");
    cotnum(a,stdout);
    printf("\nand can be seen also in ecelgprivate.key file\n");
    
    ecurve_mult(a,base_point,public_key);
    epoint_get(public_key,z,z);
    fp=fopen("ecelgpublic.key","w");
    cotnum(z,fp);
    fclose(fp);
    printf("\npublic key is:  ");
    cotnum(z,stdout);
    printf("\nand can be seen also in the ecelgpublic.key file\n");
    
    printf("\nencrypting base point...\n");
    bigdig(160,2,r);
    ecurve_mult(r,base_point,aux1);
    ecurve_mult(r,public_key,aux2);
    
    printf("\ndecrypting base point..\n");
    
    ecurve_add(base_point,aux2); 
    ecurve_mult(a,aux1,aux1);
    ecurve_sub(aux1,aux2);
    epoint_get(aux2,x,y);
    printf("\ndecrypted point is:\n");
    cotnum(x,stdout);
    cotnum(y,stdout);
    
    epoint_free(base_point);
    epoint_free(public_key);
    epoint_free(private_key);
    epoint_free(aux1);
    epoint_free(aux2);
   }
   
   int main(int argc, char** argv) {
    char* file=argv[1];
    if (argc!=2) {
      printf ("Number of arguments incorrect!\n");
      return 1;
    }
    ecelgp(file);
    return 0;
    }
   
