#include <stdio.h>
#include "miracl.h"

static miracl* mip;

static big p;

void elgkeygen (char* param_file)
{
    /* ElGamal key generation with field generator 2 */
    /* puts private and public keys and puts in files elgprivate.key and elgpublic.key, respectively */
   
    FILE* fp;
    big x,y;
    mip=mirsys(100,0);
    x=mirvar(0);
    y=mirvar(0);
    p=mirvar(0);
    
    mip->IOBASE=16;
    
    fp=fopen(param_file, "r");
    cinnum(p,fp);
    fclose(fp);
    bigdig(160,2,x); 
    powltr(2,x,p,y);     /*y=2^x mod p */
    fp=fopen("elgprivate.key","w");
    
    printf("private key is:  ");
    cotnum (x,stdout);
    cotnum(x,fp);
    fclose(fp);
    printf("\nand can be seen also in the elgprivate.key file\n");
    
    fp=fopen("elgpublic.key","w");
    printf("\npublic key is:  ");
    cotnum(y,stdout);
    cotnum(y,fp);
    fclose(fp);
    printf("\nand can be seen also in the elgpublic.key file\n");
    return;
 }
 

void strip(char *name)
{ /* strip off filename extension */
    int i;
    for (i=0;name[i]!='\0';i++)
    {
        if (name[i]!='.') continue;
        name[i]='\0';
        break;
    }
}


void elgencrypt(char* file_to_encrypt)
{   
    char ifname[50];
    FILE* ifile;
    FILE* ofile;
    big p1,m,k,t,a,b,x,y;
    char line[150];
    p1=mirvar(0);
    m=mirvar(0);
    k=mirvar(0);
    t=mirvar(0);
    a=mirvar(0);
    b=mirvar(0);
    x=mirvar(0);
    y=mirvar(0);
    mip->IOBASE=16;
    decr(p,1,p1);
    if ((ifile=fopen("elgpublic.key","r"))==NULL)
    {
      printf ("unable to open public key file\n");
      return;
    }
    cinnum(y,ifile);
    fclose(ifile);
    do
    {
      bigdig(160,2,k);
    } while (egcd(k,p1,t)!=1);
    
    if((ifile=fopen(file_to_encrypt,"r"))==NULL)
    {
      printf ("unable to open file %s\n", file_to_encrypt);
      return;
    }
    
    strcpy(ifname,file_to_encrypt);
    strip(ifname);
    strcat(ifname,".elg");
    if ((ifile=fopen(file_to_encrypt,"rb"))==NULL)
    {
        printf("Unable to open file %s\n",file_to_encrypt);
        return;
    }
    
    printf("\nencrypting file %s\n",file_to_encrypt);
    printf("\nthis will take a while ... please wait\n");
    
    ofile=fopen(ifname,"w");
    powltr(2,k,p,a);
    mip->IOBASE=16; 
    cotnum(a,ofile); 
    while ((fgets(line,150,ifile))!=NULL) 
      { 
      	mip->IOBASE=256;
      	cinstr(m,line);  
        mip->IOBASE=16;
        powmod(y,k,p,b);
        mad(b,m,m,p,p,b);
        cotnum(b,ofile); 
       }
    fclose(ifile);
    fclose(ofile);
    printf("\nencrypted file is %s\n",ifname);
  }
 
void elgdecrypt (char* original_file, char* decoded_file)
{
    char ifname[50];
    FILE* ifile;
    FILE* ofile;
    big p1,x,t,m,a,b;
    p1=mirvar(0);
    t=mirvar(0);
    m=mirvar(0);
    a=mirvar(0);
    b=mirvar(0);
    x=mirvar(0);
    mip->IOBASE=16;       
    decr(p,1,p1);
    
    if ((ifile=fopen("elgprivate.key","r"))==NULL)
    {
      printf ("unable to open private key file\n");
      return;
    }
    cinnum(x,ifile);
    fclose(ifile);
    subtract(p1,x,t);
    
    strcpy(ifname,original_file);
    strip(ifname);
    strcat(ifname,".elg");
    if ((ifile=fopen(ifname,"rb"))==NULL)
    {
        printf("Unable to open encrypted file %s\n",ifname);
        return;
    }
    
    cinnum(a,ifile);
    
    printf("\ndecoding file %s ...\n",ifname);
    
    ofile=fopen(decoded_file,"w");
        do
        {
          mip->IOBASE=16;
          cinnum(b,ifile);
          powmod(a,t,p,m);
          mad(m,b,b,p,p,m);   
          mip->IOBASE=256;
          cotnum(m,ofile);
          cotnum(m,stdout); 
        }
        while (size(b)>0);
        
      fclose(ifile);
      fclose(ofile);
      printf("\ndecoded file is %s\n",decoded_file);
    
   }
   
int main (int argc, char** argv) {
  char* file1=argv[1];
  char* file2=argv[2];
  char* file3=argv[3];
  
  if (argc!=4) {
    printf ("Number of arguments incorrect!\n");
    return 1;
  }
  
  elgkeygen(file1);
  elgencrypt(file2);
  elgdecrypt(file2, file3);
  return 0;
  }
