#include <stdio.h>
#include "miracl.h"
#include <string.h>

static miracl* mip;

void keygen (char* param_file)
/*  calculate public and private keys for rsa encryption */
{   
    int i;
    big p,q,n,e,p1,q1,phi,d,t;
    FILE* infile;
    FILE *outfile;
    mip=mirsys(5000,0);
    p=mirvar(0);
    q=mirvar(0);
    n=mirvar(0);
    e=mirvar(0);
    p1=mirvar(0);
    q1=mirvar(0);
    phi=mirvar(0);
    d=mirvar(0);
    t=mirvar(0);
    set_io_buffer_size(4072);
    mip->IOBASE=16;
    
    if((infile=fopen(param_file, "r"))==NULL)
    {
      printf("unable to open private key file!\n");
      return;
    }
    cinnum(e,infile);
    cinnum(p,infile);
    cinnum(q,infile);
    fclose(infile);
   
    multiply(p,q,n);      /* n=p.q */
    
    decr(p,1,p1);
    decr(q,1,q1);
    multiply(p1,q1,phi);  /* phi =(p-1)*(q-1) */
    
    xgcd(e,phi,d,d,t); 
    
    /* write private key to file */
    outfile=fopen("rsaprivate.key","w");
    cotnum(e,outfile);
    cotnum(d,outfile);
    cotnum(p,outfile);
    cotnum(q,outfile);
    /* p and q are for chinese remainder */
    fclose(outfile);
    
    /* write public key to file */
    outfile=fopen("rsapublic.key","w");
    cotnum(e,outfile);
    cotnum(n,outfile);
    fclose(outfile); 
    return;
}


void strip(char *name)
{ /* strip off filename extension */
    int i;
    for (i=0;name[i]!='\0';i++)
    {
        if (name[i]!='.') continue;
        name[i]='\0';
        break;
    }
}

void RSAencrypt (char* input_file) {
    long x;
    char line[130];
    char ofname[50];
    big e,m,c,n;
    FILE* ifile;
    FILE* ofile;
    mip=mirsys(5000,0);
    set_io_buffer_size(4072);
    e=mirvar(0);
    m=mirvar(0);
    c=mirvar(0);
    n=mirvar(0);
    mip->IOBASE=16;
   
    if ((ifile=fopen("rsapublic.key","r"))==NULL)
    {
        printf("Unable to open public key file\n");
        return;
    }
    
    cinnum(e,ifile);
    cinnum(n,ifile);
    fclose(ifile);
    strcpy(ofname,input_file);
    strip(ofname);
    strcat(ofname, ".rsa");
    if ((ifile=fopen(input_file,"rb"))==NULL)
    {
        printf("Unable to open file %s\n", input_file);
        return;
    }
    printf("encrypting file %s\n", input_file);
    ofile=fopen(ofname,"w");
    
    while ((fgets(line,130,ifile))!=NULL) 
      { 
      	mip->IOBASE=256;
      	cinstr(m,line);
        mip->IOBASE=16;
        powmod(m,e,n,c);
        cotnum(c,ofile); 
       } 
    printf("\nencrypted file is %s\n", ofname);
    fclose(ifile);
    fclose(ofile);
    
  }

void RSAdecrypt (char* original_file, char* decoded_file) {
    char* text;
    big n,p,q,e,p1,q1,phi,d,primes[2],pm[2],dp,dq,m,c;
    int i;
    big_chinese ch;
    char ifname[50];
    FILE* ifile;
    FILE* ofile;
    mip=mirsys(300,0);
    set_io_buffer_size(4072);
    n=mirvar(0);
    p=mirvar(0);
    q=mirvar(0);
    e=mirvar(0);
    p1=mirvar(0);
    q1=mirvar(0);
    phi=mirvar(0);
    d=mirvar(0);
    dp=mirvar(0);
    dq=mirvar(0);
    m=mirvar(0);
    c=mirvar(0);
    for (i=0;i<2;i++) 
    {
      primes[i]=mirvar(0);
      pm[i]=mirvar(0);
    }  
    
    if ((ifile=fopen("rsaprivate.key","r"))==NULL)
    {
        printf("Unable to open private key file \n");
        return;
    }
    mip->IOBASE=16;
    cinnum(e,ifile);
    cinnum(d,ifile);
    cinnum(p,ifile);
    cinnum(q,ifile);
    fclose(ifile);
    primes[0]=p;
    primes[1]=q;
    crt_init(&ch,2,primes);
    copy(d,dp);
    copy(d,dq);
    decr(p,1,p1);
    decr(q,1,q1);
    divide(dp,p1,p1);
    divide(dq,q1,q1);
  
    strcpy(ifname,original_file);
    strip(ifname);
    strcat(ifname,".rsa");
    if ((ifile=fopen(ifname,"r"))==NULL)
      {
          printf("unable to open encoded file %s\n",ifname);
          return;
      }
    
    printf("Decrypting file %s ...\n", ifname);
    
    ofile=fopen(decoded_file,"w");
        
        do
        {
        mip->IOBASE=16;
        cinnum(c,ifile);
        powmod(c,dp,p,pm[0]);
        powmod(c,dq,q,pm[1]);
        crt(&ch,pm,m);
        mip->IOBASE=256;
        cotnum(m,ofile);
        cotnum(m,stdout);
        }
        while (size(c)>0);
        crt_end(&ch);
        printf("\ndecrypted file is %s\n",decoded_file);
        fclose(ifile);
        fclose(ofile);
}


int main (int argc, char **argv) {
  char* file1=argv[1];
  char* file2=argv[2];
  char* file3=argv[3];
  if (argc!=4) {
    printf ("Number of arguments incorrect!\n");
    return 1;
  }
  keygen(file1);
  RSAencrypt(file2);
  RSAdecrypt(file2,file3);
  return 0;
}