
//TestBench
`timescale 1ns/1ps 
module cla4_testbench;
   reg reset_; 
   initial begin reset_=0;  
      #2 reset_=1;  
      #600;
      $stop; 
   end 
   reg clock; 
   initial clock<=0; 
   always #5 clock<=(!clock); 
   reg[3:0] a, b; 
   reg cin; 
   wire cout;
   wire [3:0] s;
   initial begin cin <=0;
      @(posedge clock); a<=7; b<=7; @(posedge clock); a<=7; b<=9;
      @(posedge clock); a<=9; b<=2; @(posedge clock); a<=7; b<=3; 
      $finish;      
   end
   cla_adder_4bit CLA4(a,b,cin,s,cout); 
endmodule





//Carry Look Ahead Carry Counter a 4 bit

module cla_full_adder(a,b,c, g,p,s);
   input a,b,c;
   output g,p,s;
   assign g = a & b;
   assign p = a ^ b;
   assign s = a ^ (b ^ c); 
endmodule


module cla_adder_4bit(a,b,cin,s,cout);
   input [3:0]a,b;
   input cin;
   output [3:0] s;
   output cout;
   wire[4:0]c;
   wire[3:0]g,p;
   assign c[0] = cin;
   assign cout = c[4];
   
   cla_full_adder add0(a[0],b[0],c[0], g[0],p[0],s[0]);

   assign c[1] = g[0] | (p[0]&c[0]);

   cla_full_adder add1(a[1],b[1],c[1], g[1],p[1],s[1]);

   assign c[2] = g[1] | (p[1]&g[0]) | (p[1] & p[0] & c[0]);

   cla_full_adder add2(a[2],b[2],c[2], g[2],p[2],s[2]);

   assign c[3] = g[2] | (p[2]&g[1]) | (p[2] & p[1] & g[0]) | (p[2] & p[1] & p[0] & c[0]);

   cla_full_adder add3(a[3],b[3],c[3], g[3],p[3],s[3]);

   assign c[4] = g[3] | (p[3]&g[2]) | (p[3] & p[2] & g[1]) | (p[3] & p[2] & p[1] & g[0]) | (p[3] & p[2] & p[1] & p[0] & c[0]);

endmodule




