


//Flip-Flop T sensibile al fronte di discesa

module FFTn(q,t,clock,reset_);
   input clock,reset_,t;
   output q;
   reg STAR;

   parameter S0=0, S1=1;
   assign q=(STAR==S0)?0:1;
   always@(reset_==0) #1 STAR <=S0;
   always@(negedge clock) if (reset_==1) #3
      casex(STAR)
         S0:STAR <=(t==0)?S0:S1;
         S1:STAR <=(t==1)?S0:S1;
      endcase
endmodule



//RippleCounter

module RippleCounter (Q,T,clock,reset_);
   input clock, reset_,T;
   wire q0,q1,q2,q3;
   reg[3:0] Q1;
   output[3:0] Q; assign Q=Q1;
   FFTn rc0(q0,T,clock,reset_);
   FFTn rc1(q1,T,q0,reset_);
   FFTn rc2(q2,T,q1,reset_);
   FFTn rc3(q3,T,q2,reset_);

   //bufferizziamo in un altro registro per non avere risultati spuri

   always@(negedge clock) begin 
      Q1[0]<=q0; 
      Q1[1]<=q1; 
      Q1[2]<=q2; 
      Q1[3]<=q3; 
   end
endmodule


//testbench
`timescale 1ns/1ps
module TopLevel;
   reg clock; reg reset_;
   wire[3:0] Q;
   always #10 clock<=(!clock);
   initial begin
      $display ("time, \t clock, \t reset_, \t QQQQ");
      $monitor ("%g,   \t %b,    \t %b,   \t %b",$time,clock,reset_,Q);
      reset_=1'b1; clock=0;
      #5   reset_=1'b0;
      #20  reset_=1'b1;
      #600 $finish;
    end

    reg T; initial begin T=1; end
    RippleCounter ripc(Q,T,clock,reset_);
    //debug
    wire q0=ripc.q0, q1=ripc.q1, q2=ripc.q2, q3=ripc.q3;
    wire[3:0] q={ripc.q3,ripc.q2,ripc.q1,ripc.q0};
endmodule

