`timescale 1ns/1ps
module aludec_testbench;
   reg reset_; initial begin reset_=0; #22 reset_=1; #300; $stop; end
   reg clock;  initial clock=0; always #5 clock<=(!clock);
   wire[5:0] funct; reg[1:0] aluop;
   wire[2:0] alucontrol; reg[31:0] IR;
   initial begin 
      wait(reset_==1); aluop<=0; IR<=32'bx;
      @(posedge clock); IR<=32'h20020005; aluop<=2'b00;
      @(posedge clock); IR<=32'h2003000c; aluop<=2'b00; $display("aluop=%b funct=%b alucontrol=%b",aluop,funct,alucontrol);
      @(posedge clock); IR<=32'h2067fff7; aluop<=2'b00; $display("aluop=%b funct=%b alucontrol=%b",aluop,funct,alucontrol);
      @(posedge clock); IR<=32'h00e22025; aluop<=2'b10; $display("aluop=%b funct=%b alucontrol=%b",aluop,funct,alucontrol);
      @(posedge clock); IR<=32'h00642824; aluop<=2'b10; $display("aluop=%b funct=%b alucontrol=%b",aluop,funct,alucontrol);
      @(posedge clock); IR<=32'h00a42820; aluop<=2'b10; $display("aluop=%b funct=%b alucontrol=%b",aluop,funct,alucontrol);
      @(posedge clock); IR<=32'h10a70007; aluop<=2'b01; $display("aluop=%b funct=%b alucontrol=%b",aluop,funct,alucontrol);
      @(posedge clock); IR<=32'h0064202a; aluop<=2'b10; $display("aluop=%b funct=%b alucontrol=%b",aluop,funct,alucontrol);
      @(posedge clock); IR<=32'h10800001; aluop<=2'b01; $display("aluop=%b funct=%b alucontrol=%b",aluop,funct,alucontrol);
      @(posedge clock); IR<=32'h20050000; aluop<=2'b00; $display("aluop=%b funct=%b alucontrol=%b",aluop,funct,alucontrol);
      @(posedge clock); IR<=32'h00e2202a; aluop<=2'b10; $display("aluop=%b funct=%b alucontrol=%b",aluop,funct,alucontrol);
      @(posedge clock); IR<=32'h00853820; aluop<=2'b10; $display("aluop=%b funct=%b alucontrol=%b",aluop,funct,alucontrol);
      @(posedge clock); IR<=32'h00e23822; aluop<=2'b10; $display("aluop=%b funct=%b alucontrol=%b",aluop,funct,alucontrol);
      @(posedge clock); IR<=32'hac670044; aluop<=2'b00; $display("aluop=%b funct=%b alucontrol=%b",aluop,funct,alucontrol);
      @(posedge clock); IR<=32'h8c020050; aluop<=2'b00; $display("aluop=%b funct=%b alucontrol=%b",aluop,funct,alucontrol);
      #10 $display("aluop=%b funct=%b alucontrol=%b",aluop,funct,alucontrol); $finish;
   end
   assign funct = IR[5:0];
   aludec ALUdec(funct,aluop,alucontrol);
endmodule

module aludec(funct, aluop, alucontrol);
   input [5:0] funct; input [1:0] aluop; 
   output [2:0] alucontrol;
   reg [2:0] alucontrol;
   always @(aluop or funct)
   casex(aluop)
      2'b00: alucontrol <= 3'b010; // add (for lw/sw/addi)
      2'b01: alucontrol <= 3'b110; // sub (for beq)
      default: casex(funct) // R-type instructions
         6'b100000: alucontrol <= 3'b010; // add
         6'b100010: alucontrol <= 3'b110; // sub
         6'b100100: alucontrol <= 3'b000; // and
         6'b100101: alucontrol <= 3'b001; // or
         6'b101010: alucontrol <= 3'b111; // slt
         default: alucontrol <= 3'bxxx; // ???
      endcase
   endcase
endmodule

