`timescale 1ns / 1ps
module maindec_testbench;
   reg reset_; initial begin reset_=0; #22 reset_=1; #600; $stop; end
   reg clock;  initial clock<=0;   always #5 clock<=(!clock);
   reg[31:0] IR; wire[5:0] opcode;
   wire memtoreg,memwrite,branch,alusrc,regdst,regwrite;
   wire[1:0] aluop;
   wire[5:0] c; //control word
   assign c = {memtoreg,memwrite,branch,alusrc,regdst,regwrite};
   initial begin 
      @(posedge clock); IR<=32'h20020005;
      @(posedge clock); IR<=32'h2003000c; $display("c=%b",c);
      @(posedge clock); IR<=32'h2067fff7; $display("c=%b",c);
      @(posedge clock); IR<=32'h00e22025; $display("c=%b",c);
      @(posedge clock); IR<=32'h00642824; $display("c=%b",c);
      @(posedge clock); IR<=32'h00a42820; $display("c=%b",c);
      @(posedge clock); IR<=32'h10a70007; $display("c=%b",c);
      @(posedge clock); IR<=32'h0064202a; $display("c=%b",c);
      @(posedge clock); IR<=32'h10800001; $display("c=%b",c);
      @(posedge clock); IR<=32'h20050000; $display("c=%b",c);
      @(posedge clock); IR<=32'h00e2202a; $display("c=%b",c);
      @(posedge clock); IR<=32'h00853820; $display("c=%b",c);
      @(posedge clock); IR<=32'h00e23822; $display("c=%b",c);
      @(posedge clock); IR<=32'hac670044; $display("c=%b",c);
      @(posedge clock); IR<=32'h8c020050; $display("c=%b",c);
      #10 $display("c=%b",c); $finish;
   end
   assign opcode = IR[31:26];
   maindec MYMD(opcode,  memtoreg,memwrite,branch,alusrc,regdst,regwrite,aluop);
endmodule

module maindec(opcode,  memtoreg,memwrite,branch,
               alusrc,regdst,regwrite,aluop);
   input [5:0] opcode;
   output memtoreg,memwrite,branch,alusrc,regdst, regwrite;
   output [1:0] aluop;
   reg [7:0] controls;
   assign {regwrite,regdst,alusrc,branch,
           memwrite,memtoreg,aluop} = controls;
   always @(opcode)
   casex(opcode)
      6'b000000: controls <= 8'b11000010; // RTYPE
      6'b100011: controls <= 8'b10100100; // LW
      6'b101011: controls <= 8'b00101000; // SW
      6'b000100: controls <= 8'b00010001; // BEQ
      6'b001000: controls <= 8'b10100000; // ADDI
      default:   controls <= 8'bxxxxxxxx; // illegal op
   endcase
endmodule

