`timescale 1ns/1ps
module mux2_testbench;
 reg reset_; initial begin reset_=0; #22 reset_=1; #300; $stop; end
 reg clock;  initial clock=0; always #5 clock<=(!clock);
 reg[5:0] X[1:0];
 reg[31:0] A, B;
 wire[31:0] OUT=MYMUX2_32.y;
 reg S;
 wire[5:0] Z=MYMUX2_6.y;
 initial begin 
 wait(reset_==1);X[0]=0; X[1]=0;
 @(posedge clock); X[0]<=2;  X[1]=3;  A=0; B=32'hFFFFFFFF; S<=0; @(posedge clock); S<=1;
 @(posedge clock); X[0]<=63; X[1]=0;  A=0; B=32'h12345678; S<=0; @(posedge clock); S<=1;
 @(posedge clock); X[0]<=42; X[1]=21; A=32'h9ABCDEF0; B=0; S<=0; @(posedge clock); S<=1;
 #180 $finish;
 end
 mux2 #(6) MYMUX2_6(X[0], X[1], S, Z);
 mux2 MYMUX2_32(A, B, S, OUT);
endmodule

module mux2 (d0, d1, s, y);
  parameter WIDTH = 32;
  input [WIDTH-1:0] d0, d1;
  input s;
  output [WIDTH-1:0] y;
  
  assign y = s ? d1 : d0;
endmodule
