/*
 * Decompiled with CFR 0.152.
 */
package jsoftfloat.internal;

public class BigInteger
implements Comparable<BigInteger> {
    public static final BigInteger ZERO = new BigInteger(0L);
    public static final BigInteger ONE = new BigInteger(1L);
    private final long l;
    private final java.math.BigInteger bi;

    private BigInteger(long l) {
        this.l = l;
        this.bi = null;
    }

    private BigInteger(java.math.BigInteger bi) {
        this.l = 0L;
        this.bi = bi;
    }

    public static BigInteger valueOf(long i) {
        return new BigInteger(i);
    }

    private BigInteger big() {
        return new BigInteger(java.math.BigInteger.valueOf(this.l));
    }

    private BigInteger shorten() {
        if (this.bitLength() < 64) {
            return new BigInteger(this.bi.longValueExact());
        }
        return this;
    }

    public int bitLength() {
        if (this.bi != null) {
            return this.bi.bitLength();
        }
        return 64 - Long.numberOfLeadingZeros(Math.abs(this.l));
    }

    public BigInteger shiftLeft(int i) {
        if (this.bi != null) {
            return new BigInteger(this.bi.shiftLeft(i));
        }
        if (this.bitLength() + i > 63) {
            return this.big().shiftLeft(i);
        }
        return new BigInteger(this.l << i);
    }

    public BigInteger shiftRight(int i) {
        if (this.bi != null) {
            return new BigInteger(this.bi.shiftRight(i)).shorten();
        }
        return new BigInteger(this.l >> i);
    }

    public BigInteger multiply(BigInteger other) {
        if (this.bi != null) {
            if (other.bi != null) {
                return new BigInteger(this.bi.multiply(other.bi));
            }
            return new BigInteger(this.bi.multiply(java.math.BigInteger.valueOf(other.l)));
        }
        if (this.bitLength() + other.bitLength() > 63) {
            return this.big().multiply(other);
        }
        assert (other.bi == null);
        return new BigInteger(this.l * other.l);
    }

    public BigInteger add(BigInteger other) {
        if (this.bi != null) {
            if (other.bi != null) {
                return new BigInteger(this.bi.add(other.bi));
            }
            return new BigInteger(this.bi.add(java.math.BigInteger.valueOf(other.l)));
        }
        if (this.bitLength() > 62 || other.bitLength() > 62) {
            return this.big().add(other);
        }
        assert (other.bi == null);
        return new BigInteger(this.l + other.l);
    }

    public BigInteger subtract(BigInteger other) {
        if (this.bi != null) {
            if (other.bi != null) {
                return new BigInteger(this.bi.subtract(other.bi));
            }
            return new BigInteger(this.bi.subtract(java.math.BigInteger.valueOf(other.l)));
        }
        if (this.bitLength() > 62 || other.bitLength() > 62) {
            return this.big().subtract(other);
        }
        assert (other.bi == null);
        return new BigInteger(this.l - other.l);
    }

    public BigInteger negate() {
        if (this.bi != null) {
            return new BigInteger(this.bi.negate());
        }
        return new BigInteger(-this.l);
    }

    public int intValueExact() {
        if (this.bi != null) {
            return this.bi.intValueExact();
        }
        return (int)this.l;
    }

    public boolean testBit(int i) {
        if (this.bi != null) {
            return this.bi.testBit(i);
        }
        return (this.l >> i & 1L) == 1L;
    }

    public int getLowestSetBit() {
        if (this.bi != null) {
            return this.bi.getLowestSetBit();
        }
        if (this.l == 0L) {
            return -1;
        }
        return Long.numberOfTrailingZeros(this.l);
    }

    public BigInteger abs() {
        if (this.bi != null) {
            return new BigInteger(this.bi.abs());
        }
        return new BigInteger(Math.abs(this.l));
    }

    @Override
    public int compareTo(BigInteger other) {
        if (this.bi != null) {
            if (other.bi != null) {
                return this.bi.compareTo(other.bi);
            }
            return this.bi.compareTo(java.math.BigInteger.valueOf(other.l));
        }
        if (other.bi != null) {
            return -other.compareTo(this);
        }
        return Long.signum(this.l - other.l);
    }

    public boolean equals(Object x) {
        if (x == this) {
            return true;
        }
        if (!(x instanceof BigInteger)) {
            return false;
        }
        BigInteger xInt = (BigInteger)x;
        if (this.bi != null) {
            return this.bi.equals(xInt.bi);
        }
        if (xInt.bi != null) {
            return false;
        }
        return xInt.l == this.l;
    }
}

