/*
 * Decompiled with CFR 0.152.
 */
package jsoftfloat.operations;

import jsoftfloat.Environment;
import jsoftfloat.Flags;
import jsoftfloat.RoundingMode;
import jsoftfloat.internal.ExactFloat;
import jsoftfloat.types.Floating;

public class Arithmetic {
    public static <T extends Floating<T>> T add(T t, T t2, Environment environment) {
        if (t.isNaN()) {
            return t;
        }
        if (t2.isNaN()) {
            return t2;
        }
        if (t.isInfinite()) {
            if (t2.isInfinite() && t2.isSignMinus() != t.isSignMinus()) {
                environment.flags.add(Flags.invalid);
                return t.NaN();
            }
            return t;
        }
        if (t2.isInfinite()) {
            return t2;
        }
        if (t.isZero()) {
            if (t2.isZero()) {
                if (t.isSignMinus() == t2.isSignMinus()) {
                    return t;
                }
                return environment.mode == RoundingMode.min ? t.NegativeZero() : t.Zero();
            }
            return t2;
        }
        if (t2.isZero()) {
            return t;
        }
        ExactFloat exactFloat = t.toExactFloat().add(t2.toExactFloat());
        if (exactFloat.isZero()) {
            return environment.mode == RoundingMode.min ? t.NegativeZero() : t.Zero();
        }
        return t.fromExactFloat(exactFloat, environment);
    }

    public static <T extends Floating<T>> T subtraction(T t, T t2, Environment environment) {
        if (t.isNaN()) {
            return t;
        }
        if (t2.isNaN()) {
            return t2;
        }
        return Arithmetic.add(t, t2.negate(), environment);
    }

    public static <T extends Floating<T>> T multiplication(T t, T t2, Environment environment) {
        if (t.isNaN()) {
            return t;
        }
        if (t2.isNaN()) {
            return t2;
        }
        if (t.isZero() && t2.isInfinite() || t2.isZero() && t.isInfinite()) {
            environment.flags.add(Flags.invalid);
            return t.NaN();
        }
        if (t.isInfinite() || t2.isInfinite()) {
            return t.isSignMinus() == t2.isSignMinus() ? t.Infinity() : t.NegativeInfinity();
        }
        if (t.isZero() || t2.isZero()) {
            return t.isSignMinus() == t2.isSignMinus() ? t.Zero() : t.NegativeZero();
        }
        return t.fromExactFloat(t.toExactFloat().multiply(t2.toExactFloat()), environment);
    }

    public static <T extends Floating<T>> T squareRoot(T t, Environment environment) {
        if (t.isNaN()) {
            return t;
        }
        if (t.isZero()) {
            return t;
        }
        if (t.isSignMinus()) {
            environment.flags.add(Flags.invalid);
            return t.NaN();
        }
        if (t.isInfinite()) {
            return t;
        }
        return t.fromExactFloat(t.toExactFloat().squareRoot(t.maxPrecision()), environment);
    }

    public static <T extends Floating<T>> T fusedMultiplyAdd(T t, T t2, T t3, Environment environment) {
        if (t.isNaN()) {
            return t;
        }
        if (t2.isNaN()) {
            return t2;
        }
        if (t3.isNaN()) {
            return t3;
        }
        if (t.isZero() && t2.isInfinite() || t2.isZero() && t.isInfinite()) {
            environment.flags.add(Flags.invalid);
            return t.NaN();
        }
        if (t.isInfinite() || t2.isInfinite()) {
            return Arithmetic.add(t.isSignMinus() == t2.isSignMinus() ? t.Infinity() : t.NegativeInfinity(), t3, environment);
        }
        if (t.isZero() || t2.isZero()) {
            return Arithmetic.add(t.isSignMinus() == t2.isSignMinus() ? t.Zero() : t.NegativeZero(), t3, environment);
        }
        ExactFloat exactFloat = t.toExactFloat().multiply(t2.toExactFloat());
        if (exactFloat.isZero() || t3.isZero()) {
            return Arithmetic.add(exactFloat.sign == t2.isSignMinus() ? t.Zero() : t.NegativeZero(), t3, environment);
        }
        return t.fromExactFloat(exactFloat.add(t3.toExactFloat()), environment);
    }

    public static <T extends Floating<T>> T division(T t, T t2, Environment environment) {
        if (t.isNaN()) {
            return t;
        }
        if (t2.isNaN()) {
            return t2;
        }
        if (t.isZero() && t2.isZero() || t.isInfinite() && t2.isInfinite()) {
            environment.flags.add(Flags.invalid);
            return t.NaN();
        }
        if (t.isInfinite()) {
            return t.isSignMinus() == t2.isSignMinus() ? t.Infinity() : t.NegativeInfinity();
        }
        if (t2.isInfinite() || t.isZero()) {
            return t.isSignMinus() == t2.isSignMinus() ? t.Zero() : t.NegativeZero();
        }
        if (t2.isZero()) {
            environment.flags.add(Flags.divByZero);
            return t.isSignMinus() == t2.isSignMinus() ? t.Infinity() : t.NegativeInfinity();
        }
        assert (t.isFinite() && t2.isFinite()) : "Both should definitely be finite by this point";
        return t.fromExactFloat(t.toExactFloat().divide(t2.toExactFloat(), t.maxPrecision()), environment);
    }
}

