/*
 * Decompiled with CFR 0.152.
 */
package jsoftfloat.operations;

import java.math.BigInteger;
import jsoftfloat.Environment;
import jsoftfloat.Flags;
import jsoftfloat.RoundingMode;
import jsoftfloat.internal.ExactFloat;
import jsoftfloat.types.Float32;

public class ArithmeticF32 {
    public static Float32 add(Float32 a, Float32 b, Environment env) {
        long significand;
        int exponent;
        int temp2;
        long temp;
        if (a.isNaN()) {
            return a;
        }
        if (b.isNaN()) {
            return b;
        }
        if (a.isInfinite()) {
            if (b.isInfinite() && b.isSignMinus() != a.isSignMinus()) {
                env.flags.add(Flags.invalid);
                return a.NaN();
            }
            return a;
        }
        if (b.isInfinite()) {
            return b;
        }
        if (a.isZero()) {
            if (b.isZero()) {
                if (a.isSignMinus() == b.isSignMinus()) {
                    return a;
                }
                return env.mode == RoundingMode.min ? a.NegativeZero() : a.Zero();
            }
            return b;
        }
        if (b.isZero()) {
            return a;
        }
        if (a.negate().bits == b.bits) {
            return env.mode == RoundingMode.min ? a.NegativeZero() : a.Zero();
        }
        int aexp = a.exponent() - (a.isNormal() ? 23 : 22);
        int bexp = b.exponent() - (b.isNormal() ? 23 : 22);
        long asig = (a.bits & 0x7FFFFF) + (a.isSubnormal() ? 0 : 0x800000);
        long bsig = (b.bits & 0x7FFFFF) + (b.isSubnormal() ? 0 : 0x800000);
        int expoDiff = aexp - bexp;
        boolean sign = b.isSignMinus();
        if (a.isSignMinus() != b.isSignMinus()) {
            if (expoDiff > 0 || expoDiff == 0 && asig > bsig) {
                sign = a.isSignMinus();
                bsig *= -1L;
            } else {
                temp = -asig;
                asig = bsig;
                bsig = temp;
                temp2 = aexp;
                aexp = bexp;
                bexp = temp2;
            }
        } else if (expoDiff <= 0 && (expoDiff != 0 || asig <= bsig)) {
            temp = asig;
            asig = bsig;
            bsig = temp;
            temp2 = aexp;
            aexp = bexp;
            bexp = temp2;
        }
        expoDiff = Math.abs(expoDiff);
        if (expoDiff > 30) {
            exponent = aexp - 25;
            significand = (asig << 25) + (long)(a.isSignMinus() != b.isSignMinus() ? -1 : 1);
        } else {
            significand = (asig << expoDiff) + bsig;
            exponent = bexp;
        }
        return Float32.fromExact(new ExactFloat(sign, exponent, BigInteger.valueOf(significand)), env);
    }

    public static Float32 multiplication(Float32 a, Float32 b, Environment env) {
        if (a.isNaN()) {
            return a;
        }
        if (b.isNaN()) {
            return b;
        }
        if (a.isZero() && b.isInfinite() || b.isZero() && a.isInfinite()) {
            env.flags.add(Flags.invalid);
            return a.NaN();
        }
        if (a.isInfinite() || b.isInfinite()) {
            return a.isSignMinus() == b.isSignMinus() ? a.Infinity() : a.NegativeInfinity();
        }
        if (a.isZero() || b.isZero()) {
            return a.isSignMinus() == b.isSignMinus() ? a.Zero() : a.NegativeZero();
        }
        boolean sign = a.isSignMinus() != b.isSignMinus();
        int exponent = a.exponent() + b.exponent() - (a.isNormal() ? 23 : 22) - (b.isNormal() ? 23 : 22);
        long asig = (a.bits & 0x7FFFFF) + (a.isSubnormal() ? 0 : 0x800000);
        long bsig = (b.bits & 0x7FFFFF) + (b.isSubnormal() ? 0 : 0x800000);
        long significand = asig * bsig;
        int trail = Long.numberOfTrailingZeros(significand);
        int normalizedExponent = (exponent += trail) + (64 - Long.numberOfLeadingZeros(significand >>= trail));
        if (normalizedExponent <= -150) {
            env.flags.add(Flags.underflow);
            env.flags.add(Flags.inexact);
            return sign ? Float32.NegativeZero : Float32.Zero;
        }
        if (normalizedExponent <= -126) {
            if (exponent > -150) {
                assert (64 - Long.numberOfLeadingZeros(significand) <= 23) : "Its actually normal";
                return new Float32(sign, -127, (int)significand << 149 + exponent);
            }
            env.flags.add(Flags.inexact);
            int bitsToRound = -149 - exponent;
            long mainBits = significand >> bitsToRound << bitsToRound;
            long roundedBits = significand - mainBits;
            Float32 towardsZero = new Float32(sign, -127, (int)(significand >> bitsToRound));
            int upBits = (int)(significand >> bitsToRound) + 1;
            Float32 awayZero = (upBits & 1) == 1 || 32 - Integer.numberOfLeadingZeros(upBits) <= 24 ? new Float32(sign, -127, upBits) : new Float32(sign, -126, upBits & 0x7FFFFF);
            switch (env.mode) {
                case zero: {
                    return towardsZero;
                }
                case max: 
                case min: {
                    if (sign != (env.mode == RoundingMode.max)) {
                        return awayZero;
                    }
                    return towardsZero;
                }
            }
            if (roundedBits == (long)(1 << bitsToRound - 1)) {
                if (env.mode == RoundingMode.away || (awayZero.bits & 1) == 0) {
                    return awayZero;
                }
                return towardsZero;
            }
            if (roundedBits > 1L << bitsToRound - 1) {
                return awayZero;
            }
            return towardsZero;
        }
        if (normalizedExponent > 128) {
            env.flags.add(Flags.overflow);
            env.flags.add(Flags.inexact);
            switch (env.mode) {
                case zero: {
                    return new Float32(sign, 127, -1);
                }
                case max: 
                case min: {
                    if (sign != (env.mode == RoundingMode.max)) {
                        return sign ? Float32.NegativeInfinity : Float32.Infinity;
                    }
                    return new Float32(sign, 127, -1);
                }
                case away: 
                case even: {
                    return sign ? Float32.NegativeInfinity : Float32.Infinity;
                }
            }
            assert (false) : "Not reachable";
            return sign ? Float32.NegativeInfinity : Float32.Infinity;
        }
        if (64 - Long.numberOfLeadingZeros(significand) <= 24) {
            assert (exponent + (64 - Long.numberOfLeadingZeros(significand)) - 1 > -127) : "Its actually subnormal";
            return new Float32(sign, exponent + (64 - Long.numberOfLeadingZeros(significand)) - 1, (int)(significand << 24 - (64 - Long.numberOfLeadingZeros(significand))) & 0x7FFFFF);
        }
        env.flags.add(Flags.inexact);
        int bitsToRound = 64 - Long.numberOfLeadingZeros(significand) - 24;
        long mainBits = significand >> bitsToRound << bitsToRound;
        long roundedBits = significand - mainBits;
        int upBits = (int)(significand >> bitsToRound) + 1;
        Float32 towardsZero = new Float32(sign, exponent + 23 + bitsToRound, (int)(significand >> bitsToRound) & 0x7FFFFF);
        Float32 awayZero = (upBits & 1) == 1 || 32 - Integer.numberOfLeadingZeros(upBits) <= 24 ? new Float32(sign, exponent + 23 + bitsToRound, upBits & 0x7FFFFF) : new Float32(sign, exponent + 24 + bitsToRound, upBits >> 1 & 0x7FFFFF);
        switch (env.mode) {
            case zero: {
                return towardsZero;
            }
            case max: 
            case min: {
                if (sign != (env.mode == RoundingMode.max)) {
                    return awayZero;
                }
                return towardsZero;
            }
        }
        if (roundedBits == (long)(1 << bitsToRound - 1)) {
            if (env.mode == RoundingMode.away || (awayZero.bits & 1) == 0) {
                return awayZero;
            }
            return towardsZero;
        }
        if (roundedBits > 1L << bitsToRound - 1) {
            return awayZero;
        }
        return towardsZero;
    }
}

