/*
 * Decompiled with CFR 0.152.
 */
package rars;

import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Observable;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import rars.Globals;
import rars.util.Binary;
import rars.util.EditorFont;
import rars.venus.editors.jeditsyntax.SyntaxStyle;
import rars.venus.editors.jeditsyntax.SyntaxUtilities;

public class Settings
extends Observable {
    private static String settingsFile = "Settings";
    public static final int EXCEPTION_HANDLER = 0;
    public static final int TEXT_COLUMN_ORDER = 1;
    public static final int LABEL_SORT_STATE = 2;
    public static final int MEMORY_CONFIGURATION = 3;
    public static final int CARET_BLINK_RATE = 4;
    public static final int EDITOR_TAB_SIZE = 5;
    public static final int EDITOR_POPUP_PREFIX_LENGTH = 6;
    private static final String[] stringSettingsKeys = new String[]{"ExceptionHandler", "TextColumnOrder", "LabelSortState", "MemoryConfiguration", "CaretBlinkRate", "EditorTabSize", "EditorPopupPrefixLength"};
    private static String[] defaultStringSettingsValues = new String[]{"", "0 1 2 3 4", "0", "", "500", "8", "2"};
    public static final int EDITOR_FONT = 0;
    public static final int EVEN_ROW_FONT = 1;
    public static final int ODD_ROW_FONT = 2;
    public static final int TEXTSEGMENT_HIGHLIGHT_FONT = 3;
    public static final int TEXTSEGMENT_DELAYSLOT_HIGHLIGHT_FONT = 4;
    public static final int DATASEGMENT_HIGHLIGHT_FONT = 5;
    public static final int REGISTER_HIGHLIGHT_FONT = 6;
    private static final String[] fontFamilySettingsKeys = new String[]{"EditorFontFamily", "EvenRowFontFamily", "OddRowFontFamily", " TextSegmentHighlightFontFamily", "TextSegmentDelayslotHighightFontFamily", "DataSegmentHighlightFontFamily", "RegisterHighlightFontFamily"};
    private static final String[] fontStyleSettingsKeys = new String[]{"EditorFontStyle", "EvenRowFontStyle", "OddRowFontStyle", " TextSegmentHighlightFontStyle", "TextSegmentDelayslotHighightFontStyle", "DataSegmentHighlightFontStyle", "RegisterHighlightFontStyle"};
    private static final String[] fontSizeSettingsKeys = new String[]{"EditorFontSize", "EvenRowFontSize", "OddRowFontSize", " TextSegmentHighlightFontSize", "TextSegmentDelayslotHighightFontSize", "DataSegmentHighlightFontSize", "RegisterHighlightFontSize"};
    private static final String[] defaultFontFamilySettingsValues = new String[]{"Monospaced", "Monospaced", "Monospaced", "Monospaced", "Monospaced", "Monospaced", "Monospaced"};
    private static final String[] defaultFontStyleSettingsValues = new String[]{"Plain", "Plain", "Plain", "Plain", "Plain", "Plain", "Plain"};
    private static final String[] defaultFontSizeSettingsValues = new String[]{"12", "12", "12", "12", "12", "12", "12"};
    public static final int EVEN_ROW_BACKGROUND = 0;
    public static final int EVEN_ROW_FOREGROUND = 1;
    public static final int ODD_ROW_BACKGROUND = 2;
    public static final int ODD_ROW_FOREGROUND = 3;
    public static final int TEXTSEGMENT_HIGHLIGHT_BACKGROUND = 4;
    public static final int TEXTSEGMENT_HIGHLIGHT_FOREGROUND = 5;
    public static final int TEXTSEGMENT_DELAYSLOT_HIGHLIGHT_BACKGROUND = 6;
    public static final int TEXTSEGMENT_DELAYSLOT_HIGHLIGHT_FOREGROUND = 7;
    public static final int DATASEGMENT_HIGHLIGHT_BACKGROUND = 8;
    public static final int DATASEGMENT_HIGHLIGHT_FOREGROUND = 9;
    public static final int REGISTER_HIGHLIGHT_BACKGROUND = 10;
    public static final int REGISTER_HIGHLIGHT_FOREGROUND = 11;
    private static final String[] colorSettingsKeys = new String[]{"EvenRowBackground", "EvenRowForeground", "OddRowBackground", "OddRowForeground", "TextSegmentHighlightBackground", "TextSegmentHighlightForeground", "TextSegmentDelaySlotHighlightBackground", "TextSegmentDelaySlotHighlightForeground", "DataSegmentHighlightBackground", "DataSegmentHighlightForeground", "RegisterHighlightBackground", "RegisterHighlightForeground"};
    private static String[] defaultColorSettingsValues = new String[]{"0x00e0e0e0", "0", "0x00ffffff", "0", "0x00ffff99", "0", "0x0033ff00", "0", "0x0099ccff", "0", "0x0099cc55", "0"};
    private HashMap<Bool, Boolean> booleanSettingsValues = new HashMap();
    private String[] stringSettingsValues = new String[stringSettingsKeys.length];
    private String[] fontFamilySettingsValues = new String[fontFamilySettingsKeys.length];
    private String[] fontStyleSettingsValues = new String[fontStyleSettingsKeys.length];
    private String[] fontSizeSettingsValues = new String[fontSizeSettingsKeys.length];
    private String[] colorSettingsValues = new String[colorSettingsKeys.length];
    private Preferences preferences = Preferences.userNodeForPackage(this.getClass());
    private String[] syntaxStyleColorSettingsValues;
    private boolean[] syntaxStyleBoldSettingsValues;
    private boolean[] syntaxStyleItalicSettingsValues;
    private static final String SYNTAX_STYLE_COLOR_PREFIX = "SyntaxStyleColor_";
    private static final String SYNTAX_STYLE_BOLD_PREFIX = "SyntaxStyleBold_";
    private static final String SYNTAX_STYLE_ITALIC_PREFIX = "SyntaxStyleItalic_";
    private static String[] syntaxStyleColorSettingsKeys;
    private static String[] syntaxStyleBoldSettingsKeys;
    private static String[] syntaxStyleItalicSettingsKeys;
    private static String[] defaultSyntaxStyleColorSettingsValues;
    private static boolean[] defaultSyntaxStyleBoldSettingsValues;
    private static boolean[] defaultSyntaxStyleItalicSettingsValues;

    public Settings() {
        this(true);
    }

    public Settings(boolean bl) {
        this.initialize();
    }

    public boolean getBackSteppingEnabled() {
        return Globals.program != null && Globals.program.getBackStepper() != null && Globals.program.getBackStepper().enabled();
    }

    public void reset(boolean bl) {
        this.initialize();
    }

    public void setEditorSyntaxStyleByPosition(int n, SyntaxStyle syntaxStyle) {
        this.syntaxStyleColorSettingsValues[n] = syntaxStyle.getColorAsHexString();
        this.syntaxStyleItalicSettingsValues[n] = syntaxStyle.isItalic();
        this.syntaxStyleBoldSettingsValues[n] = syntaxStyle.isBold();
        this.saveEditorSyntaxStyle(n);
    }

    public SyntaxStyle getEditorSyntaxStyleByPosition(int n) {
        return new SyntaxStyle(this.getColorValueByPosition(n, this.syntaxStyleColorSettingsValues), this.syntaxStyleItalicSettingsValues[n], this.syntaxStyleBoldSettingsValues[n]);
    }

    public SyntaxStyle getDefaultEditorSyntaxStyleByPosition(int n) {
        return new SyntaxStyle(this.getColorValueByPosition(n, defaultSyntaxStyleColorSettingsValues), defaultSyntaxStyleItalicSettingsValues[n], defaultSyntaxStyleBoldSettingsValues[n]);
    }

    private void saveEditorSyntaxStyle(int n) {
        try {
            this.preferences.put(syntaxStyleColorSettingsKeys[n], this.syntaxStyleColorSettingsValues[n]);
            this.preferences.putBoolean(syntaxStyleBoldSettingsKeys[n], this.syntaxStyleBoldSettingsValues[n]);
            this.preferences.putBoolean(syntaxStyleItalicSettingsKeys[n], this.syntaxStyleItalicSettingsValues[n]);
            this.preferences.flush();
        }
        catch (SecurityException securityException) {
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    private void initializeEditorSyntaxStyles() {
        SyntaxStyle[] syntaxStyleArray = SyntaxUtilities.getDefaultSyntaxStyles();
        int n = syntaxStyleArray.length;
        syntaxStyleColorSettingsKeys = new String[n];
        syntaxStyleBoldSettingsKeys = new String[n];
        syntaxStyleItalicSettingsKeys = new String[n];
        defaultSyntaxStyleColorSettingsValues = new String[n];
        defaultSyntaxStyleBoldSettingsValues = new boolean[n];
        defaultSyntaxStyleItalicSettingsValues = new boolean[n];
        this.syntaxStyleColorSettingsValues = new String[n];
        this.syntaxStyleBoldSettingsValues = new boolean[n];
        this.syntaxStyleItalicSettingsValues = new boolean[n];
        for (int i = 0; i < n; ++i) {
            Settings.syntaxStyleColorSettingsKeys[i] = SYNTAX_STYLE_COLOR_PREFIX + i;
            Settings.syntaxStyleBoldSettingsKeys[i] = SYNTAX_STYLE_BOLD_PREFIX + i;
            Settings.syntaxStyleItalicSettingsKeys[i] = SYNTAX_STYLE_ITALIC_PREFIX + i;
            this.syntaxStyleColorSettingsValues[i] = Settings.defaultSyntaxStyleColorSettingsValues[i] = syntaxStyleArray[i].getColorAsHexString();
            this.syntaxStyleBoldSettingsValues[i] = Settings.defaultSyntaxStyleBoldSettingsValues[i] = syntaxStyleArray[i].isBold();
            this.syntaxStyleItalicSettingsValues[i] = Settings.defaultSyntaxStyleItalicSettingsValues[i] = syntaxStyleArray[i].isItalic();
        }
    }

    private void getEditorSyntaxStyleSettingsFromPreferences() {
        for (int i = 0; i < syntaxStyleColorSettingsKeys.length; ++i) {
            this.syntaxStyleColorSettingsValues[i] = this.preferences.get(syntaxStyleColorSettingsKeys[i], this.syntaxStyleColorSettingsValues[i]);
            this.syntaxStyleBoldSettingsValues[i] = this.preferences.getBoolean(syntaxStyleBoldSettingsKeys[i], this.syntaxStyleBoldSettingsValues[i]);
            this.syntaxStyleItalicSettingsValues[i] = this.preferences.getBoolean(syntaxStyleItalicSettingsKeys[i], this.syntaxStyleItalicSettingsValues[i]);
        }
    }

    public boolean getBooleanSetting(Bool bool) {
        if (this.booleanSettingsValues.containsKey((Object)bool)) {
            return this.booleanSettingsValues.get((Object)bool);
        }
        throw new IllegalArgumentException("Invalid boolean setting ID");
    }

    public String getExceptionHandler() {
        return this.stringSettingsValues[0];
    }

    public String getMemoryConfiguration() {
        return this.stringSettingsValues[3];
    }

    public Font getEditorFont() {
        return this.getFontByPosition(0);
    }

    public Font getFontByPosition(int n) {
        if (n >= 0 && n < this.fontFamilySettingsValues.length) {
            return EditorFont.createFontFromStringValues(this.fontFamilySettingsValues[n], this.fontStyleSettingsValues[n], this.fontSizeSettingsValues[n]);
        }
        return null;
    }

    public Font getDefaultFontByPosition(int n) {
        if (n >= 0 && n < defaultFontFamilySettingsValues.length) {
            return EditorFont.createFontFromStringValues(defaultFontFamilySettingsValues[n], defaultFontStyleSettingsValues[n], defaultFontSizeSettingsValues[n]);
        }
        return null;
    }

    public int[] getTextColumnOrder() {
        return this.getTextSegmentColumnOrder(this.stringSettingsValues[1]);
    }

    public int getCaretBlinkRate() {
        int n;
        try {
            n = Integer.parseInt(this.stringSettingsValues[4]);
        }
        catch (NumberFormatException numberFormatException) {
            n = Integer.parseInt(defaultStringSettingsValues[4]);
        }
        return n;
    }

    public int getEditorTabSize() {
        int n = 8;
        try {
            n = Integer.parseInt(this.stringSettingsValues[5]);
        }
        catch (NumberFormatException numberFormatException) {
            n = this.getDefaultEditorTabSize();
        }
        return n;
    }

    public int getEditorPopupPrefixLength() {
        int n = 2;
        try {
            n = Integer.parseInt(this.stringSettingsValues[6]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public int getDefaultEditorTabSize() {
        return Integer.parseInt(defaultStringSettingsValues[5]);
    }

    public String getLabelSortState() {
        return this.stringSettingsValues[2];
    }

    public Color getColorSettingByKey(String string) {
        return this.getColorValueByKey(string, this.colorSettingsValues);
    }

    public Color getDefaultColorSettingByKey(String string) {
        return this.getColorValueByKey(string, defaultColorSettingsValues);
    }

    public Color getColorSettingByPosition(int n) {
        return this.getColorValueByPosition(n, this.colorSettingsValues);
    }

    public Color getDefaultColorSettingByPosition(int n) {
        return this.getColorValueByPosition(n, defaultColorSettingsValues);
    }

    public void setBooleanSetting(Bool bool, boolean bl) {
        if (!this.booleanSettingsValues.containsKey((Object)bool)) {
            throw new IllegalArgumentException("Invalid boolean setting ID");
        }
        this.internalSetBooleanSetting(bool, bl);
    }

    public void setBooleanSettingNonPersistent(Bool bool, boolean bl) {
        if (!this.booleanSettingsValues.containsKey((Object)bool)) {
            throw new IllegalArgumentException("Invalid boolean setting ID");
        }
        this.booleanSettingsValues.put(bool, bl);
    }

    public void setExceptionHandler(String string) {
        this.setStringSetting(0, string);
    }

    public void setMemoryConfiguration(String string) {
        this.setStringSetting(3, string);
    }

    public void setCaretBlinkRate(int n) {
        this.setStringSetting(4, "" + n);
    }

    public void setEditorTabSize(int n) {
        this.setStringSetting(5, "" + n);
    }

    public void setEditorPopupPrefixLength(int n) {
        this.setStringSetting(6, "" + n);
    }

    public void setEditorFont(Font font) {
        this.setFontByPosition(0, font);
    }

    public void setFontByPosition(int n, Font font) {
        if (n >= 0 && n < this.fontFamilySettingsValues.length) {
            this.fontFamilySettingsValues[n] = font.getFamily();
            this.fontStyleSettingsValues[n] = EditorFont.styleIntToStyleString(font.getStyle());
            this.fontSizeSettingsValues[n] = EditorFont.sizeIntToSizeString(font.getSize());
            this.saveFontSetting(n, fontFamilySettingsKeys, this.fontFamilySettingsValues);
            this.saveFontSetting(n, fontStyleSettingsKeys, this.fontStyleSettingsValues);
            this.saveFontSetting(n, fontSizeSettingsKeys, this.fontSizeSettingsValues);
        }
        if (n == 0) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void setTextColumnOrder(int[] nArray) {
        String string = "";
        for (int n : nArray) {
            string = string + Integer.toString(n) + " ";
        }
        this.setStringSetting(1, string);
    }

    public void setLabelSortState(String string) {
        this.setStringSetting(2, string);
    }

    public void setColorSettingByKey(String string, Color color) {
        for (int i = 0; i < colorSettingsKeys.length; ++i) {
            if (!string.equals(colorSettingsKeys[i])) continue;
            this.setColorSettingByPosition(i, color);
            return;
        }
    }

    public void setColorSettingByPosition(int n, Color color) {
        if (n >= 0 && n < colorSettingsKeys.length) {
            this.setColorSetting(n, color);
        }
    }

    private void initialize() {
        this.applyDefaultSettings();
        if (!this.readSettingsFromPropertiesFile(settingsFile)) {
            System.out.println("RARS System error: unable to read Settings.properties defaults. Using built-in defaults.");
        }
        this.getSettingsFromPreferences();
    }

    private void applyDefaultSettings() {
        int n;
        for (Bool bool : Bool.values()) {
            this.booleanSettingsValues.put(bool, bool.getDefault());
        }
        for (n = 0; n < this.stringSettingsValues.length; ++n) {
            this.stringSettingsValues[n] = defaultStringSettingsValues[n];
        }
        for (n = 0; n < this.fontFamilySettingsValues.length; ++n) {
            this.fontFamilySettingsValues[n] = defaultFontFamilySettingsValues[n];
            this.fontStyleSettingsValues[n] = defaultFontStyleSettingsValues[n];
            this.fontSizeSettingsValues[n] = defaultFontSizeSettingsValues[n];
        }
        for (n = 0; n < this.colorSettingsValues.length; ++n) {
            this.colorSettingsValues[n] = defaultColorSettingsValues[n];
        }
        this.initializeEditorSyntaxStyles();
    }

    private void internalSetBooleanSetting(Bool bool, boolean bl) {
        if (bl != this.booleanSettingsValues.get((Object)bool)) {
            this.booleanSettingsValues.put(bool, bl);
            this.saveBooleanSetting(bool.getName(), bl);
            this.setChanged();
            this.notifyObservers();
        }
    }

    private void setStringSetting(int n, String string) {
        this.stringSettingsValues[n] = string;
        this.saveStringSetting(n);
    }

    private void setColorSetting(int n, Color color) {
        this.colorSettingsValues[n] = Binary.intToHexString(color.getRed() << 16 | color.getGreen() << 8 | color.getBlue());
        this.saveColorSetting(n);
    }

    private Color getColorValueByKey(String string, String[] stringArray) {
        Object var3_3 = null;
        for (int i = 0; i < colorSettingsKeys.length; ++i) {
            if (!string.equals(colorSettingsKeys[i])) continue;
            return this.getColorValueByPosition(i, stringArray);
        }
        return null;
    }

    private Color getColorValueByPosition(int n, String[] stringArray) {
        Color color = null;
        if (n >= 0 && n < colorSettingsKeys.length) {
            try {
                color = Color.decode(stringArray[n]);
            }
            catch (NumberFormatException numberFormatException) {
                color = null;
            }
        }
        return color;
    }

    private boolean readSettingsFromPropertiesFile(String string) {
        try {
            int n;
            String string2;
            for (Bool bool : Bool.values()) {
                string2 = Globals.getPropertyEntry(string, bool.getName());
                if (string2 == null) continue;
                boolean bl = Boolean.valueOf(string2);
                bool.setDefault(bl);
                this.booleanSettingsValues.put(bool, bl);
            }
            for (n = 0; n < stringSettingsKeys.length; ++n) {
                string2 = Globals.getPropertyEntry(string, stringSettingsKeys[n]);
                if (string2 == null) continue;
                this.stringSettingsValues[n] = Settings.defaultStringSettingsValues[n] = string2;
            }
            for (n = 0; n < this.fontFamilySettingsValues.length; ++n) {
                string2 = Globals.getPropertyEntry(string, fontFamilySettingsKeys[n]);
                if (string2 != null) {
                    this.fontFamilySettingsValues[n] = Settings.defaultFontFamilySettingsValues[n] = string2;
                }
                if ((string2 = Globals.getPropertyEntry(string, fontStyleSettingsKeys[n])) != null) {
                    this.fontStyleSettingsValues[n] = Settings.defaultFontStyleSettingsValues[n] = string2;
                }
                if ((string2 = Globals.getPropertyEntry(string, fontSizeSettingsKeys[n])) == null) continue;
                this.fontSizeSettingsValues[n] = Settings.defaultFontSizeSettingsValues[n] = string2;
            }
            for (n = 0; n < colorSettingsKeys.length; ++n) {
                string2 = Globals.getPropertyEntry(string, colorSettingsKeys[n]);
                if (string2 == null) continue;
                this.colorSettingsValues[n] = Settings.defaultColorSettingsValues[n] = string2;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void getSettingsFromPreferences() {
        int n;
        for (Bool bool : this.booleanSettingsValues.keySet()) {
            this.booleanSettingsValues.put(bool, this.preferences.getBoolean(bool.getName(), this.booleanSettingsValues.get((Object)bool)));
        }
        for (n = 0; n < stringSettingsKeys.length; ++n) {
            this.stringSettingsValues[n] = this.preferences.get(stringSettingsKeys[n], this.stringSettingsValues[n]);
        }
        for (n = 0; n < fontFamilySettingsKeys.length; ++n) {
            this.fontFamilySettingsValues[n] = this.preferences.get(fontFamilySettingsKeys[n], this.fontFamilySettingsValues[n]);
            this.fontStyleSettingsValues[n] = this.preferences.get(fontStyleSettingsKeys[n], this.fontStyleSettingsValues[n]);
            this.fontSizeSettingsValues[n] = this.preferences.get(fontSizeSettingsKeys[n], this.fontSizeSettingsValues[n]);
        }
        for (n = 0; n < colorSettingsKeys.length; ++n) {
            this.colorSettingsValues[n] = this.preferences.get(colorSettingsKeys[n], this.colorSettingsValues[n]);
        }
        this.getEditorSyntaxStyleSettingsFromPreferences();
    }

    private void saveBooleanSetting(String string, boolean bl) {
        try {
            this.preferences.putBoolean(string, bl);
            this.preferences.flush();
        }
        catch (SecurityException securityException) {
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    private void saveStringSetting(int n) {
        try {
            this.preferences.put(stringSettingsKeys[n], this.stringSettingsValues[n]);
            this.preferences.flush();
        }
        catch (SecurityException securityException) {
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    private void saveFontSetting(int n, String[] stringArray, String[] stringArray2) {
        try {
            this.preferences.put(stringArray[n], stringArray2[n]);
            this.preferences.flush();
        }
        catch (SecurityException securityException) {
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    private void saveColorSetting(int n) {
        try {
            this.preferences.put(colorSettingsKeys[n], this.colorSettingsValues[n]);
            this.preferences.flush();
        }
        catch (SecurityException securityException) {
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    private int[] getTextSegmentColumnOrder(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int[] nArray = new int[stringTokenizer.countTokens()];
        int n = 0;
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            int n2;
            try {
                n2 = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (Exception exception) {
                bl = false;
                break;
            }
            nArray[n++] = n2;
        }
        if (!bl && !string.equals(defaultStringSettingsValues[1])) {
            return this.getTextSegmentColumnOrder(defaultStringSettingsValues[1]);
        }
        return nArray;
    }

    public static enum Bool {
        EXTENDED_ASSEMBLER_ENABLED("ExtendedAssembler", true),
        ASSEMBLE_ON_OPEN("AssembleOnOpen", false),
        ASSEMBLE_OPEN("AssembleOpen", false),
        ASSEMBLE_ALL("AssembleAll", false),
        LABEL_WINDOW_VISIBILITY("LabelWindowVisibility", false),
        DISPLAY_ADDRESSES_IN_HEX("DisplayAddressesInHex", true),
        DISPLAY_VALUES_IN_HEX("DisplayValuesInHex", true),
        EXCEPTION_HANDLER_ENABLED("LoadExceptionHandler", false),
        EDITOR_LINE_NUMBERS_DISPLAYED("EditorLineNumbersDisplayed", true),
        WARNINGS_ARE_ERRORS("WarningsAreErrors", false),
        PROGRAM_ARGUMENTS("ProgramArguments", false),
        DATA_SEGMENT_HIGHLIGHTING("DataSegmentHighlighting", true),
        REGISTERS_HIGHLIGHTING("RegistersHighlighting", true),
        START_AT_MAIN("StartAtMain", false),
        EDITOR_CURRENT_LINE_HIGHLIGHTING("EditorCurrentLineHighlighting", true),
        POPUP_INSTRUCTION_GUIDANCE("PopupInstructionGuidance", true),
        POPUP_SYSCALL_INPUT("PopupSyscallInput", false),
        GENERIC_TEXT_EDITOR("GenericTextEditor", false),
        AUTO_INDENT("AutoIndent", true),
        SELF_MODIFYING_CODE_ENABLED("SelfModifyingCode", false);

        private String name;
        private boolean value;

        private Bool(String string2, boolean bl) {
            this.name = string2;
            this.value = bl;
        }

        boolean getDefault() {
            return this.value;
        }

        void setDefault(boolean bl) {
            this.value = bl;
        }

        String getName() {
            return this.name;
        }
    }
}

