/*
 * Decompiled with CFR 0.152.
 */
package rars;

import rars.ErrorMessage;
import rars.ProgramStatement;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.RegisterFile;
import rars.util.Binary;

public class SimulationException
extends Exception {
    public static final int SOFTWARE_INTERRUPT = Integer.MIN_VALUE;
    public static final int TIMER_INTERRUPT = -2147483644;
    public static final int EXTERNAL_INTERRUPT = -2147483640;
    public static final int INSTRUCTION_ADDR_MISALIGNED = 0;
    public static final int INSTRUCTION_ACCESS_FAULT = 1;
    public static final int ILLEGAL_INSTRUCTION = 2;
    public static final int LOAD_ADDRESS_MISALIGNED = 4;
    public static final int LOAD_ACCESS_FAULT = 5;
    public static final int STORE_ADDRESS_MISALIGNED = 6;
    public static final int STORE_ACCESS_FAULT = 7;
    public static final int ENVIRONMENT_CALL = 8;
    private int cause = -1;
    private int value = 0;
    private ErrorMessage message = null;

    public SimulationException() {
    }

    public SimulationException(ProgramStatement programStatement, String string, int n) {
        this(programStatement, string);
        this.cause = n;
    }

    public SimulationException(ProgramStatement programStatement, String string) {
        this.message = new ErrorMessage(programStatement, "Runtime exception at " + Binary.intToHexString(RegisterFile.getProgramCounter() - 4) + ": " + string);
    }

    public SimulationException(ProgramStatement programStatement, AddressErrorException addressErrorException) {
        this(programStatement, addressErrorException.getMessage());
        this.cause = addressErrorException.getType();
        this.value = addressErrorException.getAddress();
    }

    public SimulationException(String string) {
        this.message = new ErrorMessage(null, 0, 0, string);
    }

    public SimulationException(String string, int n) {
        this.message = new ErrorMessage(null, 0, 0, string);
        this.cause = n;
    }

    public ErrorMessage error() {
        return this.message;
    }

    public int cause() {
        return this.cause;
    }

    public int value() {
        return this.value;
    }
}

