/*
 * Decompiled with CFR 0.152.
 */
package rars.api;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import rars.AssemblyException;
import rars.ErrorList;
import rars.Globals;
import rars.RISCVprogram;
import rars.Settings;
import rars.SimulationException;
import rars.api.Options;
import rars.riscv.hardware.ControlAndStatusRegisterFile;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.hardware.InterruptController;
import rars.riscv.hardware.Memory;
import rars.riscv.hardware.Register;
import rars.riscv.hardware.RegisterFile;
import rars.simulator.ProgramArgumentList;
import rars.simulator.Simulator;
import rars.util.SystemIO;

public class Program {
    private Options set;
    private RISCVprogram code;
    private SystemIO.Data fds;
    private ByteArrayOutputStream stdout;
    private ByteArrayOutputStream stderr;
    private Memory assembled;
    private Memory simulation;
    private int startPC;
    private int exitCode;

    public Program() {
        this(new Options());
    }

    public Program(Options options) {
        Globals.initialize(false);
        this.set = options;
        this.code = new RISCVprogram();
        this.assembled = new Memory();
        this.simulation = new Memory();
    }

    public ErrorList assemble(ArrayList<String> arrayList, String string) throws AssemblyException {
        ArrayList<RISCVprogram> arrayList2 = this.code.prepareFilesForAssembly(arrayList, string, null);
        return this.assemble(arrayList2);
    }

    public ErrorList assemble(String string) throws AssemblyException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        ArrayList<RISCVprogram> arrayList2 = this.code.prepareFilesForAssembly(arrayList, string, null);
        return this.assemble(arrayList2);
    }

    public ErrorList assembleString(String string) throws AssemblyException {
        ArrayList<RISCVprogram> arrayList = new ArrayList<RISCVprogram>();
        this.code.fromString(string);
        this.code.tokenize();
        arrayList.add(this.code);
        return this.assemble(arrayList);
    }

    private ErrorList assemble(ArrayList<RISCVprogram> arrayList) throws AssemblyException {
        Memory memory = Memory.swapInstance(this.assembled);
        ErrorList errorList = null;
        AssemblyException assemblyException = null;
        try {
            errorList = this.code.assemble(arrayList, this.set.pseudo, this.set.warningsAreErrors);
        }
        catch (AssemblyException assemblyException2) {
            assemblyException = assemblyException2;
        }
        Memory.swapInstance(memory);
        if (assemblyException != null) {
            throw assemblyException;
        }
        RegisterFile.initializeProgramCounter(this.set.startAtMain);
        this.startPC = RegisterFile.getProgramCounter();
        return errorList;
    }

    public void setup(ArrayList<String> arrayList, String string) {
        RegisterFile.resetRegisters();
        FloatingPointRegisterFile.resetRegisters();
        ControlAndStatusRegisterFile.resetRegisters();
        InterruptController.reset();
        RegisterFile.initializeProgramCounter(this.startPC);
        Globals.exitCode = 0;
        this.simulation.copyFrom(this.assembled);
        Memory memory = Memory.swapInstance(this.simulation);
        new ProgramArgumentList(arrayList).storeProgramArguments();
        Memory.swapInstance(memory);
        this.fds = new SystemIO.Data(true);
        if (string != null) {
            this.fds.streams[0] = new ByteArrayInputStream(string.getBytes());
            this.stdout = new ByteArrayOutputStream();
            this.fds.streams[1] = this.stdout;
            this.stderr = new ByteArrayOutputStream();
            this.fds.streams[2] = this.stderr;
        }
    }

    public Simulator.Reason simulate() throws SimulationException {
        Simulator.Reason reason = null;
        SimulationException simulationException = null;
        boolean bl = Globals.getSettings().getBooleanSetting(Settings.Bool.SELF_MODIFYING_CODE_ENABLED);
        Globals.getSettings().setBooleanSettingNonPersistent(Settings.Bool.SELF_MODIFYING_CODE_ENABLED, this.set.selfModifyingCode);
        SystemIO.Data data = SystemIO.swapData(this.fds);
        Memory memory = Memory.swapInstance(this.simulation);
        try {
            reason = this.code.simulate(this.set.maxSteps);
        }
        catch (SimulationException simulationException2) {
            simulationException = simulationException2;
        }
        this.exitCode = Globals.exitCode;
        Globals.getSettings().setBooleanSettingNonPersistent(Settings.Bool.SELF_MODIFYING_CODE_ENABLED, bl);
        SystemIO.swapData(data);
        Memory.swapInstance(memory);
        if (simulationException != null) {
            throw simulationException;
        }
        return reason;
    }

    public String getSTDOUT() {
        return this.stdout.toString();
    }

    public String getSTDERR() {
        return this.stderr.toString();
    }

    public int getRegisterValue(String string) {
        Register register = RegisterFile.getRegister(string);
        if (register == null) {
            register = FloatingPointRegisterFile.getRegister(string);
        }
        if (register == null) {
            return ControlAndStatusRegisterFile.getValue(string);
        }
        return (int)register.getValue();
    }

    public void setRegisterValue(String string, int n) {
        Register register = RegisterFile.getRegister(string);
        if (register == null) {
            register = FloatingPointRegisterFile.getRegister(string);
        }
        if (register == null) {
            ControlAndStatusRegisterFile.updateRegister(string, n);
        } else {
            register.setValue(n);
        }
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public Memory getMemory() {
        return this.simulation;
    }
}

