/*
 * Decompiled with CFR 0.152.
 */
package rars.assembler;

import rars.assembler.Directives;

public final class DataTypes {
    public static final int DOUBLE_SIZE = 8;
    public static final int FLOAT_SIZE = 4;
    public static final int WORD_SIZE = 4;
    public static final int HALF_SIZE = 2;
    public static final int BYTE_SIZE = 1;
    public static final int CHAR_SIZE = 1;
    public static final int MAX_WORD_VALUE = Integer.MAX_VALUE;
    public static final int MIN_WORD_VALUE = Integer.MIN_VALUE;
    public static final int MAX_HALF_VALUE = Short.MAX_VALUE;
    public static final int MIN_HALF_VALUE = Short.MIN_VALUE;
    public static final int MAX_IMMEDIATE_VALUE = 2047;
    public static final int MIN_IMMEDIATE_VALUE = -2048;
    public static final int MAX_UPPER_VALUE = 1048575;
    public static final int MIN_UPPER_VALUE = 0;
    public static final int MAX_BYTE_VALUE = 127;
    public static final int MIN_BYTE_VALUE = -128;
    public static final double MAX_FLOAT_VALUE = 3.4028234663852886E38;
    public static final double LOW_FLOAT_VALUE = -3.4028234663852886E38;

    public static int getLengthInBytes(Directives directives) {
        if (directives == Directives.FLOAT) {
            return 4;
        }
        if (directives == Directives.DOUBLE) {
            return 8;
        }
        if (directives == Directives.WORD) {
            return 4;
        }
        if (directives == Directives.HALF) {
            return 2;
        }
        if (directives == Directives.BYTE) {
            return 1;
        }
        return 0;
    }

    public static boolean outOfRange(Directives directives, int n) {
        return directives == Directives.HALF && (n < Short.MIN_VALUE || n > 65535) || directives == Directives.BYTE && (n < -128 || n > 255);
    }

    public static boolean outOfRange(Directives directives, double d) {
        return directives == Directives.FLOAT && (d < -3.4028234663852886E38 || d > 3.4028234663852886E38);
    }
}

