/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.hardware;

import java.util.Observer;
import rars.Globals;
import rars.riscv.hardware.LinkedRegister;
import rars.riscv.hardware.MaskedRegister;
import rars.riscv.hardware.ReadOnlyRegister;
import rars.riscv.hardware.Register;
import rars.riscv.hardware.RegisterBlock;

public class ControlAndStatusRegisterFile {
    public static final int EXTERNAL_INTERRUPT = 256;
    public static final int TIMER_INTERRUPT = 16;
    public static final int SOFTWARE_INTERRUPT = 1;
    public static final int INTERRUPT_ENABLE = 1;
    private static final RegisterBlock instance;

    public static boolean updateRegister(int n, int n2) {
        if (instance.getRegister(n) instanceof ReadOnlyRegister) {
            return true;
        }
        if (Globals.getSettings().getBackSteppingEnabled()) {
            Globals.program.getBackStepper().addControlAndStatusRestore(n, instance.updateRegister(n, (long)n2));
        } else {
            instance.updateRegister(n, (long)n2);
        }
        return false;
    }

    public static void updateRegister(String string, int n) {
        ControlAndStatusRegisterFile.updateRegister(instance.getRegister(string).getNumber(), n);
    }

    public static void updateRegisterBackdoor(int n, int n2) {
        if (Globals.getSettings().getBackSteppingEnabled()) {
            Globals.program.getBackStepper().addControlAndStatusBackdoor(n, instance.getRegister(n).setValueBackdoor(n2));
        } else {
            instance.getRegister(n).setValueBackdoor(n2);
        }
    }

    public static void updateRegisterBackdoor(String string, int n) {
        ControlAndStatusRegisterFile.updateRegisterBackdoor(instance.getRegister(string).getNumber(), n);
    }

    public static boolean orRegister(int n, int n2) {
        return ControlAndStatusRegisterFile.updateRegister(n, (int)instance.getValue(n) | n2);
    }

    public static void orRegister(String string, int n) {
        ControlAndStatusRegisterFile.updateRegister(string, (int)instance.getValue(string) | n);
    }

    public static boolean clearRegister(int n, int n2) {
        return ControlAndStatusRegisterFile.updateRegister(n, (int)instance.getValue(n) & ~n2);
    }

    public static void clearRegister(String string, int n) {
        ControlAndStatusRegisterFile.updateRegister(string, (int)instance.getValue(string) & ~n);
    }

    public static int getValue(int n) {
        return (int)instance.getValue(n);
    }

    public static int getValue(String string) {
        return (int)instance.getValue(string);
    }

    public static int getValueNoNotify(String string) {
        return (int)instance.getRegister(string).getValueNoNotify();
    }

    public static Register[] getRegisters() {
        return instance.getRegisters();
    }

    public static int getRegisterPosition(Register register) {
        Register[] registerArray = instance.getRegisters();
        for (int i = 0; i < registerArray.length; ++i) {
            if (registerArray[i] != register) continue;
            return i;
        }
        return -1;
    }

    public static void resetRegisters() {
        instance.resetRegisters();
    }

    public static void addRegistersObserver(Observer observer) {
        instance.addRegistersObserver(observer);
    }

    public static void deleteRegistersObserver(Observer observer) {
        instance.deleteRegistersObserver(observer);
    }

    static {
        Register[] registerArray = new Register[]{new MaskedRegister("ustatus", 0, 0L, -18L), null, null, new MaskedRegister("fcsr", 3, 0L, -256L), new Register("uie", 4, 0L), new Register("utvec", 5, 0L), new Register("uscratch", 64, 0L), new Register("uepc", 65, 0L), new Register("ucause", 66, 0L), new Register("utval", 67, 0L), new Register("uip", 68, 0L), new ReadOnlyRegister("cycle", 3072, 0), new ReadOnlyRegister("time", 3073, 0), new ReadOnlyRegister("instret", 3074, 0), new ReadOnlyRegister("cycleh", 3200, 0), new ReadOnlyRegister("timeh", 3201, 0), new ReadOnlyRegister("instreth", 3202, 0)};
        registerArray[1] = new LinkedRegister("fflags", 1, registerArray[3], 31L);
        registerArray[2] = new LinkedRegister("frm", 2, registerArray[3], 224L);
        instance = new RegisterBlock('_', registerArray);
    }
}

