/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.hardware;

import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import rars.Globals;
import rars.ProgramStatement;
import rars.Settings;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.MemoryAccessNotice;
import rars.riscv.hardware.MemoryConfigurations;

public class Memory
extends Observable {
    public static int textBaseAddress = MemoryConfigurations.getDefaultTextBaseAddress();
    public static int dataSegmentBaseAddress = MemoryConfigurations.getDefaultDataSegmentBaseAddress();
    public static int externBaseAddress = MemoryConfigurations.getDefaultExternBaseAddress();
    public static int globalPointer = MemoryConfigurations.getDefaultGlobalPointer();
    public static int dataBaseAddress = MemoryConfigurations.getDefaultDataBaseAddress();
    public static int heapBaseAddress = MemoryConfigurations.getDefaultHeapBaseAddress();
    public static int stackPointer = MemoryConfigurations.getDefaultStackPointer();
    public static int stackBaseAddress = MemoryConfigurations.getDefaultStackBaseAddress();
    public static int userHighAddress = MemoryConfigurations.getDefaultUserHighAddress();
    public static int kernelBaseAddress = MemoryConfigurations.getDefaultKernelBaseAddress();
    public static int memoryMapBaseAddress = MemoryConfigurations.getDefaultMemoryMapBaseAddress();
    public static int kernelHighAddress = MemoryConfigurations.getDefaultKernelHighAddress();
    public static final int WORD_LENGTH_BYTES = 4;
    public static final boolean LITTLE_ENDIAN = true;
    private static boolean byteOrder = true;
    public static int heapAddress;
    private Collection<MemoryObservable> observables = this.getNewMemoryObserversCollection();
    private static final int BLOCK_LENGTH_WORDS = 1024;
    private static final int BLOCK_TABLE_LENGTH = 1024;
    private int[][] dataBlockTable;
    private int[][] stackBlockTable;
    private static final int MMIO_TABLE_LENGTH = 16;
    private int[][] memoryMapBlockTable;
    private static final int TEXT_BLOCK_LENGTH_WORDS = 1024;
    private static final int TEXT_BLOCK_TABLE_LENGTH = 1024;
    private ProgramStatement[][] textBlockTable;
    public static int dataSegmentLimitAddress;
    public static int textLimitAddress;
    public static int stackLimitAddress;
    public static int memoryMapLimitAddress;
    private static Memory uniqueMemoryInstance;
    private static final boolean STORE = true;
    private static final boolean FETCH = false;

    public Memory() {
        this.initialize();
    }

    public boolean copyFrom(Memory memory) {
        int n;
        if (this.textBlockTable.length != memory.textBlockTable.length || this.dataBlockTable.length != memory.dataBlockTable.length || this.stackBlockTable.length != memory.stackBlockTable.length || this.memoryMapBlockTable.length != memory.memoryMapBlockTable.length) {
            return false;
        }
        for (n = 0; n < this.textBlockTable.length; ++n) {
            this.textBlockTable[n] = memory.textBlockTable[n] != null ? (ProgramStatement[])memory.textBlockTable[n].clone() : null;
        }
        for (n = 0; n < this.dataBlockTable.length; ++n) {
            this.dataBlockTable[n] = (int[])(memory.dataBlockTable[n] != null ? (int[])memory.dataBlockTable[n].clone() : null);
        }
        for (n = 0; n < this.stackBlockTable.length; ++n) {
            this.stackBlockTable[n] = (int[])(memory.stackBlockTable[n] != null ? (int[])memory.stackBlockTable[n].clone() : null);
        }
        for (n = 0; n < this.memoryMapBlockTable.length; ++n) {
            this.memoryMapBlockTable[n] = (int[])(memory.memoryMapBlockTable[n] != null ? (int[])memory.memoryMapBlockTable[n].clone() : null);
        }
        return true;
    }

    public static Memory swapInstance(Memory memory) {
        Memory memory2 = uniqueMemoryInstance;
        uniqueMemoryInstance = memory;
        Globals.memory = memory;
        return memory2;
    }

    public static Memory getInstance() {
        return uniqueMemoryInstance;
    }

    public void clear() {
        Memory.setConfiguration();
        this.initialize();
    }

    public static void setConfiguration() {
        textBaseAddress = MemoryConfigurations.getCurrentConfiguration().getTextBaseAddress();
        dataSegmentBaseAddress = MemoryConfigurations.getCurrentConfiguration().getDataSegmentBaseAddress();
        externBaseAddress = MemoryConfigurations.getCurrentConfiguration().getExternBaseAddress();
        globalPointer = MemoryConfigurations.getCurrentConfiguration().getGlobalPointer();
        dataBaseAddress = MemoryConfigurations.getCurrentConfiguration().getDataBaseAddress();
        heapBaseAddress = MemoryConfigurations.getCurrentConfiguration().getHeapBaseAddress();
        stackPointer = MemoryConfigurations.getCurrentConfiguration().getStackPointer();
        stackBaseAddress = MemoryConfigurations.getCurrentConfiguration().getStackBaseAddress();
        userHighAddress = MemoryConfigurations.getCurrentConfiguration().getUserHighAddress();
        kernelBaseAddress = MemoryConfigurations.getCurrentConfiguration().getKernelBaseAddress();
        memoryMapBaseAddress = MemoryConfigurations.getCurrentConfiguration().getMemoryMapBaseAddress();
        kernelHighAddress = MemoryConfigurations.getCurrentConfiguration().getKernelHighAddress();
        dataSegmentLimitAddress = Math.min(MemoryConfigurations.getCurrentConfiguration().getDataSegmentLimitAddress(), dataSegmentBaseAddress + 0x400000);
        textLimitAddress = Math.min(MemoryConfigurations.getCurrentConfiguration().getTextLimitAddress(), textBaseAddress + 0x400000);
        stackLimitAddress = Math.max(MemoryConfigurations.getCurrentConfiguration().getStackLimitAddress(), stackBaseAddress - 0x400000);
        memoryMapLimitAddress = Math.min(MemoryConfigurations.getCurrentConfiguration().getMemoryMapLimitAddress(), memoryMapBaseAddress + 65536);
    }

    private void initialize() {
        heapAddress = heapBaseAddress;
        this.textBlockTable = new ProgramStatement[1024][];
        this.dataBlockTable = new int[1024][];
        this.stackBlockTable = new int[1024][];
        this.memoryMapBlockTable = new int[16][];
        System.gc();
    }

    public int allocateBytesFromHeap(int n) throws IllegalArgumentException {
        int n2 = heapAddress;
        if (n < 0) {
            throw new IllegalArgumentException("request (" + n + ") is negative heap amount");
        }
        int n3 = heapAddress + n;
        if (n3 % 4 != 0) {
            n3 += 4 - n3 % 4;
        }
        if (n3 >= dataSegmentLimitAddress) {
            throw new IllegalArgumentException("request (" + n + ") exceeds available heap storage");
        }
        heapAddress = n3;
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int set(int n, int n2, int n3) throws AddressErrorException {
        int n4 = 0;
        if (Globals.debug) {
            System.out.println("memory[" + n + "] set to " + n2 + "(" + n3 + " bytes)");
        }
        if (Memory.inDataSegment(n)) {
            int n5 = n - dataSegmentBaseAddress;
            n4 = this.storeBytesInTable(this.dataBlockTable, n5, n3, n2);
        } else if (n > stackLimitAddress && n <= stackBaseAddress) {
            int n6 = stackBaseAddress - n;
            n4 = this.storeBytesInTable(this.stackBlockTable, n6, n3, n2);
        } else if (Memory.inTextSegment(n)) {
            if (!Globals.getSettings().getBooleanSetting(Settings.Bool.SELF_MODIFYING_CODE_ENABLED)) throw new AddressErrorException("Cannot write directly to text segment!", 7, n);
            ProgramStatement programStatement = this.getStatementNoNotify(n);
            if (programStatement != null) {
                n4 = programStatement.getBinaryStatement();
            }
            this.setStatement(n, new ProgramStatement(n2, n));
        } else {
            if (n < memoryMapBaseAddress || n >= memoryMapLimitAddress) throw new AddressErrorException("address out of range ", 7, n);
            int n7 = n - memoryMapBaseAddress;
            n4 = this.storeBytesInTable(this.memoryMapBlockTable, n7, n3, n2);
        }
        this.notifyAnyObservers(1, n, n3, n2);
        return n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int setRawWord(int n, int n2) throws AddressErrorException {
        int n3 = 0;
        Memory.checkStoreWordAligned(n);
        if (Memory.inDataSegment(n)) {
            int n4 = n - dataSegmentBaseAddress >> 2;
            n3 = this.storeWordInTable(this.dataBlockTable, n4, n2);
        } else if (n > stackLimitAddress && n <= stackBaseAddress) {
            int n5 = stackBaseAddress - n >> 2;
            n3 = this.storeWordInTable(this.stackBlockTable, n5, n2);
        } else if (Memory.inTextSegment(n)) {
            if (!Globals.getSettings().getBooleanSetting(Settings.Bool.SELF_MODIFYING_CODE_ENABLED)) throw new AddressErrorException("Cannot write directly to text segment!", 7, n);
            ProgramStatement programStatement = this.getStatementNoNotify(n);
            if (programStatement != null) {
                n3 = programStatement.getBinaryStatement();
            }
            this.setStatement(n, new ProgramStatement(n2, n));
        } else {
            if (n < memoryMapBaseAddress || n >= memoryMapLimitAddress) throw new AddressErrorException("store address out of range ", 7, n);
            int n6 = n - memoryMapBaseAddress >> 2;
            n3 = this.storeWordInTable(this.memoryMapBlockTable, n6, n2);
        }
        this.notifyAnyObservers(1, n, 4, n2);
        if (!Globals.getSettings().getBackSteppingEnabled()) return n3;
        Globals.program.getBackStepper().addMemoryRestoreRawWord(n, n3);
        return n3;
    }

    public int setWord(int n, int n2) throws AddressErrorException {
        Memory.checkStoreWordAligned(n);
        return Globals.getSettings().getBackSteppingEnabled() ? Globals.program.getBackStepper().addMemoryRestoreWord(n, this.set(n, n2, 4)) : this.set(n, n2, 4);
    }

    public int setHalf(int n, int n2) throws AddressErrorException {
        if (n % 2 != 0) {
            throw new AddressErrorException("store address not aligned on halfword boundary ", 6, n);
        }
        return Globals.getSettings().getBackSteppingEnabled() ? Globals.program.getBackStepper().addMemoryRestoreHalf(n, this.set(n, n2, 2)) : this.set(n, n2, 2);
    }

    public int setByte(int n, int n2) throws AddressErrorException {
        return Globals.getSettings().getBackSteppingEnabled() ? Globals.program.getBackStepper().addMemoryRestoreByte(n, this.set(n, n2, 1)) : this.set(n, n2, 1);
    }

    public long setDoubleWord(int n, long l) throws AddressErrorException {
        int n2 = this.set(n + 4, (int)(l >> 32), 4);
        int n3 = this.set(n, (int)l, 4);
        long l2 = (long)n2 << 32 | (long)n2 & 0xFFFFFFFFL;
        return Globals.getSettings().getBackSteppingEnabled() ? Globals.program.getBackStepper().addMemoryRestoreDoubleWord(n, l2) : l2;
    }

    public double setDouble(int n, double d) throws AddressErrorException {
        long l = Double.doubleToLongBits(d);
        return Double.longBitsToDouble(this.setDoubleWord(n, l));
    }

    public void setStatement(int n, ProgramStatement programStatement) throws AddressErrorException {
        Memory.checkStoreWordAligned(n);
        if (!Memory.inTextSegment(n)) {
            throw new AddressErrorException("Store address to text segment out of range", 7, n);
        }
        if (Globals.debug) {
            System.out.println("memory[" + n + "] set to " + programStatement.getBinaryStatement());
        }
        this.storeProgramStatement(n, programStatement, textBaseAddress, this.textBlockTable);
    }

    public int get(int n, int n2) throws AddressErrorException {
        return this.get(n, n2, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int get(int n, int n2, boolean bl) throws AddressErrorException {
        int n3 = 0;
        if (Memory.inDataSegment(n)) {
            int n4 = n - dataSegmentBaseAddress;
            n3 = this.fetchBytesFromTable(this.dataBlockTable, n4, n2);
        } else if (n > stackLimitAddress && n <= stackBaseAddress) {
            int n5 = stackBaseAddress - n;
            n3 = this.fetchBytesFromTable(this.stackBlockTable, n5, n2);
        } else if (n >= memoryMapBaseAddress && n < memoryMapLimitAddress) {
            int n6 = n - memoryMapBaseAddress;
            n3 = this.fetchBytesFromTable(this.memoryMapBlockTable, n6, n2);
        } else {
            if (!Memory.inTextSegment(n)) throw new AddressErrorException("address out of range ", 5, n);
            if (!Globals.getSettings().getBooleanSetting(Settings.Bool.SELF_MODIFYING_CODE_ENABLED)) throw new AddressErrorException("Cannot read directly from text segment!", 5, n);
            ProgramStatement programStatement = this.getStatementNoNotify(n);
            n3 = programStatement == null ? 0 : programStatement.getBinaryStatement();
        }
        if (!bl) return n3;
        this.notifyAnyObservers(0, n, n2, n3);
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getRawWord(int n) throws AddressErrorException {
        int n2 = 0;
        Memory.checkLoadWordAligned(n);
        if (Memory.inDataSegment(n)) {
            int n3 = n - dataSegmentBaseAddress >> 2;
            n2 = this.fetchWordFromTable(this.dataBlockTable, n3);
        } else if (n > stackLimitAddress && n <= stackBaseAddress) {
            int n4 = stackBaseAddress - n >> 2;
            n2 = this.fetchWordFromTable(this.stackBlockTable, n4);
        } else if (n >= memoryMapBaseAddress && n < memoryMapLimitAddress) {
            int n5 = n - memoryMapBaseAddress >> 2;
            n2 = this.fetchWordFromTable(this.memoryMapBlockTable, n5);
        } else {
            if (!Memory.inTextSegment(n)) throw new AddressErrorException("address out of range ", 5, n);
            if (!Globals.getSettings().getBooleanSetting(Settings.Bool.SELF_MODIFYING_CODE_ENABLED)) throw new AddressErrorException("Cannot read directly from text segment!", 5, n);
            ProgramStatement programStatement = this.getStatementNoNotify(n);
            n2 = programStatement == null ? 0 : programStatement.getBinaryStatement();
        }
        this.notifyAnyObservers(0, n, 4, n2);
        return n2;
    }

    public Integer getRawWordOrNull(int n) throws AddressErrorException {
        Integer n2 = null;
        Memory.checkLoadWordAligned(n);
        if (Memory.inDataSegment(n)) {
            int n3 = n - dataSegmentBaseAddress >> 2;
            n2 = this.fetchWordOrNullFromTable(this.dataBlockTable, n3);
        } else if (n > stackLimitAddress && n <= stackBaseAddress) {
            int n4 = stackBaseAddress - n >> 2;
            n2 = this.fetchWordOrNullFromTable(this.stackBlockTable, n4);
        } else if (Memory.inTextSegment(n)) {
            try {
                n2 = this.getStatementNoNotify(n) == null ? null : Integer.valueOf(this.getStatementNoNotify(n).getBinaryStatement());
            }
            catch (AddressErrorException addressErrorException) {
                n2 = null;
            }
        } else {
            throw new AddressErrorException("address out of range ", 5, n);
        }
        return n2;
    }

    public int getAddressOfFirstNull(int n, int n2) throws AddressErrorException {
        int n3;
        for (n3 = n; n3 < n2 && this.getRawWordOrNull(n3) != null; n3 += 4) {
        }
        return n3;
    }

    public int getWord(int n) throws AddressErrorException {
        Memory.checkLoadWordAligned(n);
        return this.get(n, 4, true);
    }

    public int getWordNoNotify(int n) throws AddressErrorException {
        Memory.checkLoadWordAligned(n);
        return this.get(n, 4, false);
    }

    public int getHalf(int n) throws AddressErrorException {
        if (n % 2 != 0) {
            throw new AddressErrorException("Load address not aligned on halfword boundary ", 4, n);
        }
        return this.get(n, 2);
    }

    public int getByte(int n) throws AddressErrorException {
        return this.get(n, 1);
    }

    public ProgramStatement getStatement(int n) throws AddressErrorException {
        return this.getStatement(n, true);
    }

    public ProgramStatement getStatementNoNotify(int n) throws AddressErrorException {
        return this.getStatement(n, false);
    }

    private ProgramStatement getStatement(int n, boolean bl) throws AddressErrorException {
        Memory.checkLoadWordAligned(n);
        if (!Globals.getSettings().getBooleanSetting(Settings.Bool.SELF_MODIFYING_CODE_ENABLED) && !Memory.inTextSegment(n)) {
            throw new AddressErrorException("fetch address for text segment out of range ", 5, n);
        }
        if (Memory.inTextSegment(n)) {
            return this.readProgramStatement(n, textBaseAddress, this.textBlockTable, bl);
        }
        return new ProgramStatement(this.get(n, 4), n);
    }

    public static boolean wordAligned(int n) {
        return n % 4 == 0;
    }

    private static void checkLoadWordAligned(int n) throws AddressErrorException {
        if (!Memory.wordAligned(n)) {
            throw new AddressErrorException("Load address not aligned to word boundary ", 4, n);
        }
    }

    private static void checkStoreWordAligned(int n) throws AddressErrorException {
        if (!Memory.wordAligned(n)) {
            throw new AddressErrorException("Store address not aligned to word boundary ", 6, n);
        }
    }

    public static boolean doublewordAligned(int n) {
        return n % 8 == 0;
    }

    public static boolean inTextSegment(int n) {
        return n >= textBaseAddress && n < textLimitAddress;
    }

    public static boolean inDataSegment(int n) {
        return n >= dataSegmentBaseAddress && n < dataSegmentLimitAddress;
    }

    public static boolean inMemoryMapSegment(int n) {
        return n >= memoryMapBaseAddress && n < kernelHighAddress;
    }

    @Override
    public void addObserver(Observer observer) {
        try {
            this.addObserver(observer, 0, 0x7FFFFFFC);
            this.addObserver(observer, Integer.MIN_VALUE, -4);
        }
        catch (AddressErrorException addressErrorException) {
            System.out.println("Internal Error in Memory.addObserver: " + addressErrorException);
        }
    }

    public void addObserver(Observer observer, int n) throws AddressErrorException {
        this.addObserver(observer, n, n);
    }

    public void addObserver(Observer observer, int n, int n2) throws AddressErrorException {
        Memory.checkLoadWordAligned(n);
        Memory.checkLoadWordAligned(n2);
        if (n >= 0 && n2 < 0) {
            throw new AddressErrorException("range cannot cross 0x8000000; please split it up", 5, n);
        }
        if (n2 < n) {
            throw new AddressErrorException("end address of range < start address of range ", 5, n);
        }
        this.observables.add(new MemoryObservable(observer, n, n2));
    }

    @Override
    public int countObservers() {
        return this.observables.size();
    }

    @Override
    public void deleteObserver(Observer observer) {
        for (MemoryObservable memoryObservable : this.observables) {
            memoryObservable.deleteObserver(observer);
        }
    }

    @Override
    public void deleteObservers() {
        this.observables = this.getNewMemoryObserversCollection();
    }

    @Override
    public void notifyObservers() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void notifyObservers(Object object) {
        throw new UnsupportedOperationException();
    }

    private Collection<MemoryObservable> getNewMemoryObserversCollection() {
        return new Vector<MemoryObservable>();
    }

    private void notifyAnyObservers(int n, int n2, int n3, int n4) {
        if ((Globals.program != null || Globals.getGui() == null) && this.observables.size() > 0) {
            for (MemoryObservable memoryObservable : this.observables) {
                if (!memoryObservable.match(n2)) continue;
                memoryObservable.notifyObserver(new MemoryAccessNotice(n, n2, n3, n4));
            }
        }
    }

    private int storeBytesInTable(int[][] nArray, int n, int n2, int n3) {
        return this.storeOrFetchBytesInTable(nArray, n, n2, n3, true);
    }

    private int fetchBytesFromTable(int[][] nArray, int n, int n2) {
        return this.storeOrFetchBytesInTable(nArray, n, n2, 0, false);
    }

    private synchronized int storeOrFetchBytesInTable(int[][] nArray, int n, int n2, int n3, boolean bl) {
        int n4;
        int n5 = 0;
        int n6 = 3 - n2;
        if (nArray == this.stackBlockTable && (n4 = n % 4) != 0) {
            n += 4 - n4 << 1;
        }
        for (int i = 3; i > n6; --i) {
            int n7 = n % 4;
            int n8 = n >> 2;
            int n9 = n8 / 1024;
            int n10 = n8 % 1024;
            if (nArray[n9] == null) {
                if (bl) {
                    nArray[n9] = new int[1024];
                } else {
                    return 0;
                }
            }
            if (byteOrder) {
                n7 = 3 - n7;
            }
            if (bl) {
                n5 = this.replaceByte(nArray[n9][n10], n7, n5, i);
                nArray[n9][n10] = this.replaceByte(n3, i, nArray[n9][n10], n7);
            } else {
                n3 = this.replaceByte(nArray[n9][n10], n7, n3, i);
            }
            ++n;
        }
        return bl ? n5 : n3;
    }

    private synchronized int storeWordInTable(int[][] nArray, int n, int n2) {
        int n3 = n / 1024;
        int n4 = n % 1024;
        if (nArray[n3] == null) {
            nArray[n3] = new int[1024];
        }
        int n5 = nArray[n3][n4];
        nArray[n3][n4] = n2;
        return n5;
    }

    private synchronized int fetchWordFromTable(int[][] nArray, int n) {
        int n2 = 0;
        int n3 = n / 1024;
        int n4 = n % 1024;
        n2 = nArray[n3] == null ? 0 : nArray[n3][n4];
        return n2;
    }

    private synchronized Integer fetchWordOrNullFromTable(int[][] nArray, int n) {
        int n2 = 0;
        int n3 = n / 1024;
        int n4 = n % 1024;
        if (nArray[n3] == null) {
            return null;
        }
        n2 = nArray[n3][n4];
        return n2;
    }

    private int replaceByte(int n, int n2, int n3, int n4) {
        return (n >> 24 - (n2 << 3) & 0xFF) << 24 - (n4 << 3) | n3 & ~(255 << 24 - (n4 << 3));
    }

    private void storeProgramStatement(int n, ProgramStatement programStatement, int n2, ProgramStatement[][] programStatementArray) {
        int n3 = n - n2 >> 2;
        int n4 = n3 / 1024;
        int n5 = n3 % 1024;
        if (n4 < 1024) {
            if (programStatementArray[n4] == null) {
                programStatementArray[n4] = new ProgramStatement[1024];
            }
            programStatementArray[n4][n5] = programStatement;
        }
    }

    private ProgramStatement readProgramStatement(int n, int n2, ProgramStatement[][] programStatementArray, boolean bl) {
        int n3 = n - n2 >> 2;
        int n4 = n3 / 1024;
        int n5 = n3 % 1024;
        if (n4 < 1024) {
            if (programStatementArray[n4] == null || programStatementArray[n4][n5] == null) {
                if (bl) {
                    this.notifyAnyObservers(0, n, 4, 0);
                }
                return null;
            }
            if (bl) {
                this.notifyAnyObservers(0, n, 4, programStatementArray[n4][n5].getBinaryStatement());
            }
            return programStatementArray[n4][n5];
        }
        if (bl) {
            this.notifyAnyObservers(0, n, 4, 0);
        }
        return null;
    }

    static {
        dataSegmentLimitAddress = dataSegmentBaseAddress + 0x400000;
        textLimitAddress = textBaseAddress + 0x400000;
        stackLimitAddress = stackBaseAddress - 0x400000;
        memoryMapLimitAddress = memoryMapBaseAddress + 65536;
        uniqueMemoryInstance = new Memory();
    }

    private class MemoryObservable
    extends Observable
    implements Comparable<MemoryObservable> {
        private int lowAddress;
        private int highAddress;

        public MemoryObservable(Observer observer, int n, int n2) {
            this.lowAddress = n;
            this.highAddress = n2;
            this.addObserver(observer);
        }

        public boolean match(int n) {
            return n >= this.lowAddress && n <= this.highAddress - 1 + 4;
        }

        public void notifyObserver(MemoryAccessNotice memoryAccessNotice) {
            this.setChanged();
            this.notifyObservers(memoryAccessNotice);
        }

        @Override
        public int compareTo(MemoryObservable memoryObservable) {
            if (this.lowAddress < memoryObservable.lowAddress || this.lowAddress == memoryObservable.lowAddress && this.highAddress < memoryObservable.highAddress) {
                return -1;
            }
            if (this.lowAddress > memoryObservable.lowAddress || this.lowAddress == memoryObservable.lowAddress && this.highAddress > memoryObservable.highAddress) {
                return -1;
            }
            return 0;
        }
    }
}

