/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import rars.ProgramStatement;
import rars.SimulationException;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.hardware.ControlAndStatusRegisterFile;
import rars.riscv.hardware.RegisterFile;

public class CSRRCI
extends BasicInstruction {
    public CSRRCI() {
        super("csrrci t0, fcsr, 10", "Atomic Read/Clear CSR Immediate: read from the CSR into t0 and clear bits of the CSR according to a constant", BasicInstructionFormat.I_FORMAT, "ssssssssssss ttttt 111 fffff 1110011");
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws SimulationException {
        int[] nArray = programStatement.getOperands();
        try {
            int n = ControlAndStatusRegisterFile.getValue(nArray[1]);
            if (nArray[2] != 0 && ControlAndStatusRegisterFile.clearRegister(nArray[1], nArray[2])) {
                throw new SimulationException(programStatement, "Attempt to write to read-only CSR", 2);
            }
            RegisterFile.updateRegister(nArray[0], n);
        }
        catch (NullPointerException nullPointerException) {
            throw new SimulationException(programStatement, "Attempt to access unavailable CSR", 2);
        }
    }
}

