/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import rars.ProgramStatement;
import rars.SimulationException;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.hardware.ControlAndStatusRegisterFile;
import rars.riscv.hardware.RegisterFile;

public class CSRRWI
extends BasicInstruction {
    public CSRRWI() {
        super("csrrwi t0, fcsr, 10", "Atomic Read/Write CSR Immediate: read from the CSR into t0 and write a constant into the CSR", BasicInstructionFormat.I_FORMAT, "ssssssssssss ttttt 101 fffff 1110011");
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws SimulationException {
        int[] nArray = programStatement.getOperands();
        try {
            int n = ControlAndStatusRegisterFile.getValue(nArray[1]);
            if (ControlAndStatusRegisterFile.updateRegister(nArray[1], nArray[2])) {
                throw new SimulationException(programStatement, "Attempt to write to read-only CSR", 2);
            }
            RegisterFile.updateRegister(nArray[0], n);
        }
        catch (NullPointerException nullPointerException) {
            throw new SimulationException(programStatement, "Attempt to access unavailable CSR", 2);
        }
    }
}

