/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import jsoftfloat.types.Float32;
import jsoftfloat.types.Floating;
import rars.ProgramStatement;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.hardware.RegisterFile;

public class FCLASSS
extends BasicInstruction {
    public FCLASSS() {
        super("fclass.s t1, f1", "Classify a floating point number", BasicInstructionFormat.I_FORMAT, "1110000 00000 sssss 001 fffff 1010011");
    }

    @Override
    public void simulate(ProgramStatement programStatement) {
        int[] nArray = programStatement.getOperands();
        Float32 float32 = new Float32(FloatingPointRegisterFile.getValue(nArray[1]));
        FCLASSS.fclass(float32, nArray[0]);
    }

    public static <T extends Floating<T>> void fclass(T t, int n) {
        if (t.isNaN()) {
            RegisterFile.updateRegister(n, t.isSignalling() ? 256 : 512);
        } else {
            boolean bl = t.isSignMinus();
            if (t.isInfinite()) {
                RegisterFile.updateRegister(n, bl ? 1 : 128);
            } else if (t.isZero()) {
                RegisterFile.updateRegister(n, bl ? 8 : 16);
            } else if (t.isSubnormal()) {
                RegisterFile.updateRegister(n, bl ? 4 : 32);
            } else {
                RegisterFile.updateRegister(n, bl ? 2 : 64);
            }
        }
    }
}

