/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import java.math.BigInteger;
import jsoftfloat.Environment;
import jsoftfloat.operations.Conversions;
import jsoftfloat.types.Float64;
import rars.ProgramStatement;
import rars.SimulationException;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.hardware.RegisterFile;
import rars.riscv.instructions.Floating;

public class FCVTDW
extends BasicInstruction {
    public FCVTDW() {
        super("fcvt.d.w f1, t1, dyn", "Convert double from integer: Assigns the value of t1 to f1", BasicInstructionFormat.I_FORMAT, "1101001 00000 sssss ttt fffff 1010011");
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws SimulationException {
        int[] nArray = programStatement.getOperands();
        Environment environment = new Environment();
        environment.mode = Floating.getRoundingMode(nArray[2], programStatement);
        Float64 float64 = new Float64(0L);
        Float64 float642 = Conversions.convertFromInt(BigInteger.valueOf(RegisterFile.getValue(nArray[1])), environment, float64);
        Floating.setfflags(environment);
        FloatingPointRegisterFile.updateRegisterLong(nArray[0], float642.bits);
    }
}

