/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import jsoftfloat.Environment;
import jsoftfloat.operations.Comparisons;
import jsoftfloat.types.Float64;
import rars.ProgramStatement;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.hardware.RegisterFile;
import rars.riscv.instructions.Double;
import rars.riscv.instructions.Floating;

public class FLED
extends BasicInstruction {
    public FLED() {
        super("fle.d t1, f1, f2", "Floating Less than or Equals (64 bit): if f1 <= f2, set t1 to 1, else set t1 to 0", BasicInstructionFormat.R_FORMAT, "1010001 ttttt sssss 000 fffff 1010011");
    }

    @Override
    public void simulate(ProgramStatement programStatement) {
        int[] nArray = programStatement.getOperands();
        Float64 float64 = Double.getDouble(nArray[1]);
        Float64 float642 = Double.getDouble(nArray[2]);
        Environment environment = new Environment();
        boolean bl = Comparisons.compareSignalingLessThanEqual(float64, float642, environment);
        Floating.setfflags(environment);
        RegisterFile.updateRegister(nArray[0], bl ? 1 : 0);
    }
}

