/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import jsoftfloat.Environment;
import jsoftfloat.operations.Comparisons;
import jsoftfloat.types.Float32;
import rars.ProgramStatement;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.hardware.RegisterFile;
import rars.riscv.instructions.Floating;

public class FLTS
extends BasicInstruction {
    public FLTS() {
        super("flt.s t1, f1, f2", "Floating Less Than: if f1 < f2, set t1 to 1, else set t1 to 0", BasicInstructionFormat.R_FORMAT, "1010000 ttttt sssss 001 fffff 1010011");
    }

    @Override
    public void simulate(ProgramStatement programStatement) {
        int[] nArray = programStatement.getOperands();
        Float32 float32 = Floating.getFloat(nArray[1]);
        Float32 float322 = Floating.getFloat(nArray[2]);
        Environment environment = new Environment();
        boolean bl = Comparisons.compareSignalingLessThan(float32, float322, environment);
        Floating.setfflags(environment);
        RegisterFile.updateRegister(nArray[0], bl ? 1 : 0);
    }
}

