/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import rars.Globals;
import rars.ProgramStatement;
import rars.SimulationException;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.hardware.RegisterFile;

public class FLW
extends BasicInstruction {
    public FLW() {
        super("flw f1, -100(t1)", "Load a float from memory", BasicInstructionFormat.I_FORMAT, "ssssssssssss ttttt 010 fffff 0000111");
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws SimulationException {
        int[] nArray = programStatement.getOperands();
        try {
            FloatingPointRegisterFile.updateRegister(nArray[0], Globals.memory.getWord(RegisterFile.getValue(nArray[2]) + nArray[1]));
        }
        catch (AddressErrorException addressErrorException) {
            throw new SimulationException(programStatement, addressErrorException);
        }
    }
}

