/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import rars.Globals;
import rars.ProgramStatement;
import rars.SimulationException;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.hardware.RegisterFile;

public class FSD
extends BasicInstruction {
    public FSD() {
        super("fsd f1, -100(t1)", "Store a double to memory", BasicInstructionFormat.S_FORMAT, "sssssss fffff ttttt 011 sssss 0100111");
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws SimulationException {
        int[] nArray = programStatement.getOperands();
        try {
            Globals.memory.setDoubleWord(RegisterFile.getValue(nArray[2]) + nArray[1], FloatingPointRegisterFile.getValueLong(nArray[0]));
        }
        catch (AddressErrorException addressErrorException) {
            throw new SimulationException(programStatement, addressErrorException);
        }
    }
}

