/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import rars.Globals;
import rars.ProgramStatement;
import rars.SimulationException;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.hardware.RegisterFile;

public class FSW
extends BasicInstruction {
    public FSW() {
        super("fsw f1, -100(t1)", "Store a float to memory", BasicInstructionFormat.S_FORMAT, "sssssss fffff ttttt 010 sssss 0100111");
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws SimulationException {
        int[] nArray = programStatement.getOperands();
        try {
            Globals.memory.setWord(RegisterFile.getValue(nArray[2]) + nArray[1], (int)FloatingPointRegisterFile.getValueLong(nArray[0]));
        }
        catch (AddressErrorException addressErrorException) {
            throw new SimulationException(programStatement, addressErrorException);
        }
    }
}

