/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv.instructions;

import jsoftfloat.Environment;
import jsoftfloat.Flags;
import jsoftfloat.RoundingMode;
import jsoftfloat.types.Float32;
import rars.ProgramStatement;
import rars.SimulationException;
import rars.riscv.BasicInstruction;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.hardware.ControlAndStatusRegisterFile;
import rars.riscv.hardware.FloatingPointRegisterFile;

public abstract class Floating
extends BasicInstruction {
    protected Floating(String string, String string2, String string3) {
        super(string + " f1, f2, f3, dyn", string2, BasicInstructionFormat.R_FORMAT, string3 + "ttttt sssss qqq fffff 1010011");
    }

    protected Floating(String string, String string2, String string3, String string4) {
        super(string + " f1, f2, f3", string2, BasicInstructionFormat.R_FORMAT, string3 + "ttttt sssss " + string4 + " fffff 1010011");
    }

    @Override
    public void simulate(ProgramStatement programStatement) throws SimulationException {
        int[] nArray = programStatement.getOperands();
        Environment environment = new Environment();
        environment.mode = Floating.getRoundingMode(nArray[3], programStatement);
        Float32 float32 = this.compute(new Float32(FloatingPointRegisterFile.getValue(nArray[1])), new Float32(FloatingPointRegisterFile.getValue(nArray[2])), environment);
        Floating.setfflags(environment);
        FloatingPointRegisterFile.updateRegister(nArray[0], float32.bits);
    }

    public static void setfflags(Environment environment) {
        int n = (environment.flags.contains((Object)Flags.inexact) ? 1 : 0) + (environment.flags.contains((Object)Flags.underflow) ? 2 : 0) + (environment.flags.contains((Object)Flags.overflow) ? 4 : 0) + (environment.flags.contains((Object)Flags.divByZero) ? 8 : 0) + (environment.flags.contains((Object)Flags.invalid) ? 16 : 0);
        if (n != 0) {
            ControlAndStatusRegisterFile.orRegister("fflags", n);
        }
    }

    public static RoundingMode getRoundingMode(int n, ProgramStatement programStatement) throws SimulationException {
        int n2 = n;
        int n3 = ControlAndStatusRegisterFile.getValue("frm");
        if (n2 == 7) {
            n2 = n3;
        }
        switch (n2) {
            case 0: {
                return RoundingMode.even;
            }
            case 1: {
                return RoundingMode.zero;
            }
            case 2: {
                return RoundingMode.min;
            }
            case 3: {
                return RoundingMode.max;
            }
            case 4: {
                return RoundingMode.away;
            }
        }
        throw new SimulationException(programStatement, "Invalid rounding mode. RM = " + n + " and frm = " + n3);
    }

    public abstract Float32 compute(Float32 var1, Float32 var2, Environment var3);

    public static Float32 getFloat(int n) {
        return new Float32(FloatingPointRegisterFile.getValue(n));
    }
}

