/*
 * Decompiled with CFR 0.152.
 */
package rars.simulator;

import rars.Globals;
import rars.ProgramStatement;
import rars.riscv.hardware.ControlAndStatusRegisterFile;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.hardware.RegisterFile;

public class BackStepper {
    private static final int NOT_PC_VALUE = -1;
    private boolean engaged = true;
    private final BackstepStack backSteps = new BackstepStack(Globals.maximumBacksteps);

    public boolean enabled() {
        return this.engaged;
    }

    public void setEnabled(boolean bl) {
        this.engaged = bl;
    }

    public boolean empty() {
        return this.backSteps.empty();
    }

    public void backStep() {
        if (this.engaged && !this.backSteps.empty()) {
            ProgramStatement programStatement = this.backSteps.peek().ps;
            this.engaged = false;
            do {
                BackStep backStep;
                if ((backStep = this.backSteps.pop()).pc != -1) {
                    RegisterFile.setProgramCounter(backStep.pc);
                }
                try {
                    switch (backStep.action) {
                        case MEMORY_RESTORE_RAW_WORD: {
                            Globals.memory.setRawWord(backStep.param1, (int)backStep.param2);
                            break;
                        }
                        case MEMORY_RESTORE_DOUBLE_WORD: {
                            Globals.memory.setDoubleWord(backStep.param1, backStep.param2);
                            break;
                        }
                        case MEMORY_RESTORE_WORD: {
                            Globals.memory.setWord(backStep.param1, (int)backStep.param2);
                            break;
                        }
                        case MEMORY_RESTORE_HALF: {
                            Globals.memory.setHalf(backStep.param1, (int)backStep.param2);
                            break;
                        }
                        case MEMORY_RESTORE_BYTE: {
                            Globals.memory.setByte(backStep.param1, (int)backStep.param2);
                            break;
                        }
                        case REGISTER_RESTORE: {
                            RegisterFile.updateRegister(backStep.param1, (int)backStep.param2);
                            break;
                        }
                        case FLOATING_POINT_REGISTER_RESTORE: {
                            FloatingPointRegisterFile.updateRegisterLong(backStep.param1, backStep.param2);
                            break;
                        }
                        case CONTROL_AND_STATUS_REGISTER_RESTORE: {
                            ControlAndStatusRegisterFile.updateRegister(backStep.param1, (int)backStep.param2);
                            break;
                        }
                        case CONTROL_AND_STATUS_REGISTER_BACKDOOR: {
                            ControlAndStatusRegisterFile.updateRegisterBackdoor(backStep.param1, (int)backStep.param2);
                            break;
                        }
                        case PC_RESTORE: {
                            RegisterFile.setProgramCounter(backStep.param1);
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    System.out.println("Internal RARS error: address exception while back-stepping.");
                    System.exit(0);
                }
            } while (!this.backSteps.empty() && programStatement == this.backSteps.peek().ps);
            this.engaged = true;
        }
    }

    private int pc() {
        return RegisterFile.getProgramCounter() - 4;
    }

    public int addMemoryRestoreRawWord(int n, int n2) {
        this.backSteps.push(Action.MEMORY_RESTORE_RAW_WORD, this.pc(), n, n2);
        return n2;
    }

    public int addMemoryRestoreWord(int n, int n2) {
        this.backSteps.push(Action.MEMORY_RESTORE_WORD, this.pc(), n, n2);
        return n2;
    }

    public long addMemoryRestoreDoubleWord(int n, long l) {
        this.backSteps.push(Action.MEMORY_RESTORE_DOUBLE_WORD, this.pc(), n, l);
        return l;
    }

    public int addMemoryRestoreHalf(int n, int n2) {
        this.backSteps.push(Action.MEMORY_RESTORE_HALF, this.pc(), n, n2);
        return n2;
    }

    public int addMemoryRestoreByte(int n, int n2) {
        this.backSteps.push(Action.MEMORY_RESTORE_BYTE, this.pc(), n, n2);
        return n2;
    }

    public long addRegisterFileRestore(int n, long l) {
        this.backSteps.push(Action.REGISTER_RESTORE, this.pc(), n, l);
        return l;
    }

    public int addPCRestore(int n) {
        this.backSteps.push(Action.PC_RESTORE, n -= 4, n);
        return n;
    }

    public long addControlAndStatusRestore(int n, long l) {
        this.backSteps.push(Action.CONTROL_AND_STATUS_REGISTER_RESTORE, this.pc(), n, l);
        return l;
    }

    public long addControlAndStatusBackdoor(int n, long l) {
        this.backSteps.push(Action.CONTROL_AND_STATUS_REGISTER_BACKDOOR, this.pc(), n, l);
        return l;
    }

    public long addFloatingPointRestore(int n, long l) {
        this.backSteps.push(Action.FLOATING_POINT_REGISTER_RESTORE, this.pc(), n, l);
        return l;
    }

    public void addDoNothing(int n) {
        if (this.backSteps.empty() || this.backSteps.peek().pc != n) {
            this.backSteps.push(Action.DO_NOTHING, n);
        }
    }

    private class BackstepStack {
        private final int capacity;
        private int size;
        private int top;
        private final BackStep[] stack;

        private BackstepStack(int n) {
            this.capacity = n;
            this.size = 0;
            this.top = -1;
            this.stack = new BackStep[n];
            for (int i = 0; i < n; ++i) {
                this.stack[i] = new BackStep();
            }
        }

        private synchronized boolean empty() {
            return this.size == 0;
        }

        private synchronized void push(Action action, int n, int n2, long l) {
            if (this.size == 0) {
                this.top = 0;
                ++this.size;
            } else if (this.size < this.capacity) {
                this.top = (this.top + 1) % this.capacity;
                ++this.size;
            } else {
                this.top = (this.top + 1) % this.capacity;
            }
            this.stack[this.top].assign(action, n, n2, l);
        }

        private synchronized void push(Action action, int n, int n2) {
            this.push(action, n, n2, 0L);
        }

        private synchronized void push(Action action, int n) {
            this.push(action, n, 0, 0L);
        }

        private synchronized BackStep pop() {
            BackStep backStep = this.stack[this.top];
            this.top = this.size == 1 ? -1 : (this.top + this.capacity - 1) % this.capacity;
            --this.size;
            return backStep;
        }

        private synchronized BackStep peek() {
            return this.stack[this.top];
        }
    }

    private class BackStep {
        private Action action;
        private int pc;
        private ProgramStatement ps;
        private int param1;
        private long param2;

        private BackStep() {
        }

        private void assign(Action action, int n, int n2, long l) {
            this.action = action;
            this.pc = n;
            try {
                this.ps = Globals.memory.getStatementNoNotify(n);
            }
            catch (Exception exception) {
                this.ps = null;
                this.pc = -1;
            }
            this.param1 = n2;
            this.param2 = l;
        }
    }

    private static enum Action {
        MEMORY_RESTORE_RAW_WORD,
        MEMORY_RESTORE_DOUBLE_WORD,
        MEMORY_RESTORE_WORD,
        MEMORY_RESTORE_HALF,
        MEMORY_RESTORE_BYTE,
        REGISTER_RESTORE,
        PC_RESTORE,
        CONTROL_AND_STATUS_REGISTER_RESTORE,
        CONTROL_AND_STATUS_REGISTER_BACKDOOR,
        FLOATING_POINT_REGISTER_RESTORE,
        DO_NOTHING;

    }
}

