/*
 * Decompiled with CFR 0.152.
 */
package rars.tools;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Observable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import rars.ProgramStatement;
import rars.riscv.hardware.AccessNotice;
import rars.riscv.hardware.AddressErrorException;
import rars.riscv.hardware.Memory;
import rars.riscv.hardware.MemoryAccessNotice;
import rars.tools.AbstractToolAndApplication;

public class InstructionStatistics
extends AbstractToolAndApplication {
    private static String NAME = "Instruction Statistics";
    private static String VERSION = "Version 1.0 (Ingo Kofler)";
    private static String HEADING = "";
    private static final int MAX_CATEGORY = 5;
    private static final int CATEGORY_ALU = 0;
    private static final int CATEGORY_JUMP = 1;
    private static final int CATEGORY_BRANCH = 2;
    private static final int CATEGORY_MEM = 3;
    private static final int CATEGORY_OTHER = 4;
    private JTextField m_tfTotalCounter;
    private JTextField[] m_tfCounters;
    private JProgressBar[] m_pbCounters;
    private int m_totalCounter = 0;
    private int[] m_counters = new int[5];
    private String[] m_categoryLabels = new String[]{"ALU", "Jump", "Branch", "Memory", "Other"};
    protected int lastAddress = -1;

    public InstructionStatistics(String string, String string2) {
        super(string, string2);
    }

    public InstructionStatistics() {
        super(NAME + ", " + VERSION, HEADING);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected JComponent buildMainDisplayArea() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.m_tfTotalCounter = new JTextField("0", 10);
        this.m_tfTotalCounter.setEditable(false);
        this.m_tfCounters = new JTextField[5];
        this.m_pbCounters = new JProgressBar[5];
        for (int i = 0; i < 5; ++i) {
            this.m_tfCounters[i] = new JTextField("0", 10);
            this.m_tfCounters[i].setEditable(false);
            this.m_pbCounters[i] = new JProgressBar(0);
            this.m_pbCounters[i].setStringPainted(true);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 17, 0);
        jPanel.add((Component)new JLabel("Total: "), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        jPanel.add((Component)this.m_tfTotalCounter, gridBagConstraints);
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        for (int i = 0; i < 5; ++i) {
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 2;
            jPanel.add((Component)new JLabel(this.m_categoryLabels[i] + ":   "), gridBagConstraints);
            gridBagConstraints.gridx = 3;
            jPanel.add((Component)this.m_tfCounters[i], gridBagConstraints);
            gridBagConstraints.gridx = 4;
            jPanel.add((Component)this.m_pbCounters[i], gridBagConstraints);
        }
        return jPanel;
    }

    @Override
    protected void addAsObserver() {
        this.addAsObserver(Memory.textBaseAddress, Memory.textLimitAddress);
    }

    protected int getInstructionCategory(ProgramStatement programStatement) {
        int n = programStatement.getBinaryStatement() >>> 26;
        int n2 = programStatement.getBinaryStatement() & 0x1F;
        if (n == 0) {
            if (n2 == 0) {
                return 0;
            }
            if (2 <= n2 && n2 <= 7) {
                return 0;
            }
            if (n2 == 8 || n2 == 9) {
                return 1;
            }
            if (16 <= n2 && n2 <= 47) {
                return 0;
            }
            return 4;
        }
        if (n == 1) {
            if (0 <= n2 && n2 <= 7) {
                return 2;
            }
            if (16 <= n2 && n2 <= 19) {
                return 2;
            }
            return 4;
        }
        if (n == 2 || n == 3) {
            return 1;
        }
        if (4 <= n && n <= 7) {
            return 2;
        }
        if (8 <= n && n <= 15) {
            return 0;
        }
        if (20 <= n && n <= 23) {
            return 2;
        }
        if (32 <= n && n <= 38) {
            return 3;
        }
        if (40 <= n && n <= 46) {
            return 3;
        }
        return 4;
    }

    @Override
    protected void processRISCVUpdate(Observable observable, AccessNotice accessNotice) {
        if (!accessNotice.accessIsFromRISCV()) {
            return;
        }
        if (accessNotice.getAccessType() == 0 && accessNotice instanceof MemoryAccessNotice) {
            MemoryAccessNotice memoryAccessNotice = (MemoryAccessNotice)accessNotice;
            int n = memoryAccessNotice.getAddress();
            if (n == this.lastAddress) {
                return;
            }
            this.lastAddress = n;
            try {
                ProgramStatement programStatement = Memory.getInstance().getStatementNoNotify(memoryAccessNotice.getAddress());
                if (programStatement != null) {
                    int n2 = this.getInstructionCategory(programStatement);
                    ++this.m_totalCounter;
                    int n3 = n2;
                    this.m_counters[n3] = this.m_counters[n3] + 1;
                    this.updateDisplay();
                }
            }
            catch (AddressErrorException addressErrorException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void initializePreGUI() {
        this.m_totalCounter = 0;
        this.lastAddress = -1;
        for (int i = 0; i < 5; ++i) {
            this.m_counters[i] = 0;
        }
    }

    @Override
    protected void reset() {
        this.m_totalCounter = 0;
        this.lastAddress = -1;
        for (int i = 0; i < 5; ++i) {
            this.m_counters[i] = 0;
        }
        this.updateDisplay();
    }

    @Override
    protected void updateDisplay() {
        this.m_tfTotalCounter.setText(String.valueOf(this.m_totalCounter));
        for (int i = 0; i < 5; ++i) {
            this.m_tfCounters[i].setText(String.valueOf(this.m_counters[i]));
            this.m_pbCounters[i].setMaximum(this.m_totalCounter);
            this.m_pbCounters[i].setValue(this.m_counters[i]);
        }
    }
}

