/*
 * Decompiled with CFR 0.152.
 */
package rars.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Observable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rars.riscv.hardware.AccessNotice;
import rars.riscv.hardware.Memory;
import rars.riscv.hardware.MemoryAccessNotice;
import rars.tools.AbstractToolAndApplication;
import rars.util.Binary;

public class MemoryReferenceVisualization
extends AbstractToolAndApplication {
    private static String version = "Version 1.0";
    private static String heading = "Visualizing memory reference patterns";
    private JComboBox<String> wordsPerUnitSelector;
    private JComboBox<String> visualizationUnitPixelWidthSelector;
    private JComboBox<String> visualizationUnitPixelHeightSelector;
    private JComboBox<String> visualizationPixelWidthSelector;
    private JComboBox<String> visualizationPixelHeightSelector;
    private JComboBox<String> displayBaseAddressSelector;
    private JCheckBox drawHashMarksSelector;
    private Graphics drawingArea;
    private JPanel canvas;
    private JPanel results;
    private EmptyBorder emptyBorder = new EmptyBorder(4, 4, 4, 4);
    private Font countFonts = new Font("Times", 1, 12);
    private Color backgroundColor = Color.WHITE;
    private static final String[] wordsPerUnitChoices = new String[]{"1", "2", "4", "8", "16", "32", "64", "128", "256", "512", "1024", "2048"};
    private static final int defaultWordsPerUnitIndex = 0;
    private static final String[] visualizationUnitPixelWidthChoices = new String[]{"1", "2", "4", "8", "16", "32"};
    private static final int defaultVisualizationUnitPixelWidthIndex = 4;
    private static final String[] visualizationUnitPixelHeightChoices = new String[]{"1", "2", "4", "8", "16", "32"};
    private static final int defaultVisualizationUnitPixelHeightIndex = 4;
    private static final String[] displayAreaPixelWidthChoices = new String[]{"64", "128", "256", "512", "1024"};
    private static final int defaultDisplayWidthIndex = 2;
    private static final String[] displayAreaPixelHeightChoices = new String[]{"64", "128", "256", "512", "1024"};
    private static final int defaultDisplayHeightIndex = 2;
    private static final boolean defaultDrawHashMarks = true;
    private int unitPixelWidth = Integer.parseInt(visualizationUnitPixelWidthChoices[4]);
    private int unitPixelHeight = Integer.parseInt(visualizationUnitPixelHeightChoices[4]);
    private int wordsPerUnit = Integer.parseInt(wordsPerUnitChoices[0]);
    private int visualizationAreaWidthInPixels = Integer.parseInt(displayAreaPixelWidthChoices[2]);
    private int visualizationAreaHeightInPixels = Integer.parseInt(displayAreaPixelHeightChoices[2]);
    private CounterColor[] defaultCounterColors = new CounterColor[]{new CounterColor(0, Color.black), new CounterColor(1, Color.blue), new CounterColor(2, Color.green), new CounterColor(3, Color.yellow), new CounterColor(5, Color.orange), new CounterColor(10, Color.red)};
    private int[] countTable = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 20, 30, 40, 50, 100, 200, 300, 400, 500, 1000, 2000, 3000, 4000, 5000, 10000, 50000, 100000, 500000, 1000000};
    private static final int COUNT_INDEX_INIT = 10;
    private String[] displayBaseAddressChoices;
    private int[] displayBaseAddresses;
    private int defaultBaseAddressIndex;
    private int baseAddress;
    private Grid theGrid;
    private CounterColorScale counterColorScale;

    public MemoryReferenceVisualization(String string, String string2) {
        super(string, string2);
    }

    public MemoryReferenceVisualization() {
        super("Memory Reference Visualization, " + version, heading);
    }

    public static void main(String[] stringArray) {
        new MemoryReferenceVisualization("Memory Reference Visualization stand-alone, " + version, heading).go();
    }

    @Override
    public String getName() {
        return "Memory Reference Visualization";
    }

    @Override
    protected void addAsObserver() {
        int n = this.baseAddress + this.theGrid.getRows() * this.theGrid.getColumns() * 4 * this.wordsPerUnit;
        if (this.baseAddress < 0 && n > -4) {
            n = -4;
        }
        this.addAsObserver(this.baseAddress, n);
    }

    @Override
    protected JComponent buildMainDisplayArea() {
        this.results = new JPanel();
        this.results.add(this.buildOrganizationArea());
        this.results.add(this.buildVisualizationArea());
        return this.results;
    }

    @Override
    protected void processRISCVUpdate(Observable observable, AccessNotice accessNotice) {
        this.incrementReferenceCountForAddress(((MemoryAccessNotice)accessNotice).getAddress());
    }

    @Override
    protected void initializePreGUI() {
        this.initializeDisplayBaseChoices();
        this.counterColorScale = new CounterColorScale(this.defaultCounterColors);
        this.theGrid = new Grid(this.visualizationAreaHeightInPixels / this.unitPixelHeight, this.visualizationAreaWidthInPixels / this.unitPixelWidth);
    }

    @Override
    protected void initializePostGUI() {
        this.wordsPerUnit = this.getIntComboBoxSelection(this.wordsPerUnitSelector);
        this.theGrid = this.createNewGrid();
        this.updateBaseAddress();
    }

    @Override
    protected void reset() {
        this.resetCounts();
        this.updateDisplay();
    }

    @Override
    protected void updateDisplay() {
        this.canvas.repaint();
    }

    @Override
    protected JComponent getHelpComponent() {
        JButton jButton = new JButton("Help");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(MemoryReferenceVisualization.this.theWindow, "Use this program to visualize dynamic memory reference\npatterns in assembly programs.  It may be run either\nfrom Tools menu or as a stand-alone application.  For\nthe latter, simply write a small driver to instantiate a\nMemoryReferenceVisualization object and invoke its go() method.\n\nYou can easily learn to use this small program by playing with\nit!  For the best animation, set the program to run in\ntimed mode using the Run Speed slider.  Each rectangular unit\non the display represents one or more memory words (default 1)\nand each time a memory word is accessed by the program,\nits reference count is incremented then rendered in the color\nassigned to the count value.  You can change the count-color\nassignments using the count slider and color patch.  Select a\ncounter value then click on the color patch to change the color.\nThis color will apply beginning at the selected count and\nextending up to the next slider-provided count.\n");
            }
        });
        return jButton;
    }

    private JComponent buildOrganizationArea() {
        JPanel jPanel = new JPanel(new GridLayout(9, 1));
        this.drawHashMarksSelector = new JCheckBox();
        this.drawHashMarksSelector.setSelected(true);
        this.drawHashMarksSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryReferenceVisualization.this.updateDisplay();
            }
        });
        this.wordsPerUnitSelector = new JComboBox<String>(wordsPerUnitChoices);
        this.wordsPerUnitSelector.setEditable(false);
        this.wordsPerUnitSelector.setBackground(this.backgroundColor);
        this.wordsPerUnitSelector.setSelectedIndex(0);
        this.wordsPerUnitSelector.setToolTipText("Number of memory words represented by one visualization element (rectangle)");
        this.wordsPerUnitSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryReferenceVisualization.this.wordsPerUnit = MemoryReferenceVisualization.this.getIntComboBoxSelection(MemoryReferenceVisualization.this.wordsPerUnitSelector);
                MemoryReferenceVisualization.this.reset();
            }
        });
        this.visualizationUnitPixelWidthSelector = new JComboBox<String>(visualizationUnitPixelWidthChoices);
        this.visualizationUnitPixelWidthSelector.setEditable(false);
        this.visualizationUnitPixelWidthSelector.setBackground(this.backgroundColor);
        this.visualizationUnitPixelWidthSelector.setSelectedIndex(4);
        this.visualizationUnitPixelWidthSelector.setToolTipText("Width in pixels of rectangle representing memory access");
        this.visualizationUnitPixelWidthSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryReferenceVisualization.this.unitPixelWidth = MemoryReferenceVisualization.this.getIntComboBoxSelection(MemoryReferenceVisualization.this.visualizationUnitPixelWidthSelector);
                MemoryReferenceVisualization.this.theGrid = MemoryReferenceVisualization.this.createNewGrid();
                MemoryReferenceVisualization.this.updateDisplay();
            }
        });
        this.visualizationUnitPixelHeightSelector = new JComboBox<String>(visualizationUnitPixelHeightChoices);
        this.visualizationUnitPixelHeightSelector.setEditable(false);
        this.visualizationUnitPixelHeightSelector.setBackground(this.backgroundColor);
        this.visualizationUnitPixelHeightSelector.setSelectedIndex(4);
        this.visualizationUnitPixelHeightSelector.setToolTipText("Height in pixels of rectangle representing memory access");
        this.visualizationUnitPixelHeightSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryReferenceVisualization.this.unitPixelHeight = MemoryReferenceVisualization.this.getIntComboBoxSelection(MemoryReferenceVisualization.this.visualizationUnitPixelHeightSelector);
                MemoryReferenceVisualization.this.theGrid = MemoryReferenceVisualization.this.createNewGrid();
                MemoryReferenceVisualization.this.updateDisplay();
            }
        });
        this.visualizationPixelWidthSelector = new JComboBox<String>(displayAreaPixelWidthChoices);
        this.visualizationPixelWidthSelector.setEditable(false);
        this.visualizationPixelWidthSelector.setBackground(this.backgroundColor);
        this.visualizationPixelWidthSelector.setSelectedIndex(2);
        this.visualizationPixelWidthSelector.setToolTipText("Total width in pixels of visualization area");
        this.visualizationPixelWidthSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryReferenceVisualization.this.visualizationAreaWidthInPixels = MemoryReferenceVisualization.this.getIntComboBoxSelection(MemoryReferenceVisualization.this.visualizationPixelWidthSelector);
                MemoryReferenceVisualization.this.canvas.setPreferredSize(MemoryReferenceVisualization.this.getDisplayAreaDimension());
                MemoryReferenceVisualization.this.canvas.setSize(MemoryReferenceVisualization.this.getDisplayAreaDimension());
                MemoryReferenceVisualization.this.theGrid = MemoryReferenceVisualization.this.createNewGrid();
                MemoryReferenceVisualization.this.canvas.repaint();
                MemoryReferenceVisualization.this.updateDisplay();
            }
        });
        this.visualizationPixelHeightSelector = new JComboBox<String>(displayAreaPixelHeightChoices);
        this.visualizationPixelHeightSelector.setEditable(false);
        this.visualizationPixelHeightSelector.setBackground(this.backgroundColor);
        this.visualizationPixelHeightSelector.setSelectedIndex(2);
        this.visualizationPixelHeightSelector.setToolTipText("Total height in pixels of visualization area");
        this.visualizationPixelHeightSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryReferenceVisualization.this.visualizationAreaHeightInPixels = MemoryReferenceVisualization.this.getIntComboBoxSelection(MemoryReferenceVisualization.this.visualizationPixelHeightSelector);
                MemoryReferenceVisualization.this.canvas.setPreferredSize(MemoryReferenceVisualization.this.getDisplayAreaDimension());
                MemoryReferenceVisualization.this.canvas.setSize(MemoryReferenceVisualization.this.getDisplayAreaDimension());
                MemoryReferenceVisualization.this.theGrid = MemoryReferenceVisualization.this.createNewGrid();
                MemoryReferenceVisualization.this.canvas.repaint();
                MemoryReferenceVisualization.this.updateDisplay();
            }
        });
        this.displayBaseAddressSelector = new JComboBox<String>(this.displayBaseAddressChoices);
        this.displayBaseAddressSelector.setEditable(false);
        this.displayBaseAddressSelector.setBackground(this.backgroundColor);
        this.displayBaseAddressSelector.setSelectedIndex(this.defaultBaseAddressIndex);
        this.displayBaseAddressSelector.setToolTipText("Base address for visualization area (upper left corner)");
        this.displayBaseAddressSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryReferenceVisualization.this.updateBaseAddress();
                if (MemoryReferenceVisualization.this.connectButton != null && MemoryReferenceVisualization.this.connectButton.isConnected()) {
                    MemoryReferenceVisualization.this.deleteAsObserver();
                    MemoryReferenceVisualization.this.addAsObserver();
                }
                MemoryReferenceVisualization.this.theGrid = MemoryReferenceVisualization.this.createNewGrid();
                MemoryReferenceVisualization.this.updateDisplay();
            }
        });
        JPanel jPanel2 = this.getPanelWithBorderLayout();
        jPanel2.setBorder(this.emptyBorder);
        jPanel2.add((Component)new JLabel("Show unit boundaries (grid marks)"), "West");
        jPanel2.add((Component)this.drawHashMarksSelector, "East");
        JPanel jPanel3 = this.getPanelWithBorderLayout();
        jPanel3.setBorder(this.emptyBorder);
        jPanel3.add((Component)new JLabel("Memory Words per Unit "), "West");
        jPanel3.add(this.wordsPerUnitSelector, "East");
        JPanel jPanel4 = this.getPanelWithBorderLayout();
        jPanel4.setBorder(this.emptyBorder);
        jPanel4.add((Component)new JLabel("Unit Width in Pixels "), "West");
        jPanel4.add(this.visualizationUnitPixelWidthSelector, "East");
        JPanel jPanel5 = this.getPanelWithBorderLayout();
        jPanel5.setBorder(this.emptyBorder);
        jPanel5.add((Component)new JLabel("Unit Height in Pixels "), "West");
        jPanel5.add(this.visualizationUnitPixelHeightSelector, "East");
        JPanel jPanel6 = this.getPanelWithBorderLayout();
        jPanel6.setBorder(this.emptyBorder);
        jPanel6.add((Component)new JLabel("Display Width in Pixels "), "West");
        jPanel6.add(this.visualizationPixelWidthSelector, "East");
        JPanel jPanel7 = this.getPanelWithBorderLayout();
        jPanel7.setBorder(this.emptyBorder);
        jPanel7.add((Component)new JLabel("Display Height in Pixels "), "West");
        jPanel7.add(this.visualizationPixelHeightSelector, "East");
        JPanel jPanel8 = this.getPanelWithBorderLayout();
        jPanel8.setBorder(this.emptyBorder);
        jPanel8.add((Component)new JLabel("Base address for display "), "West");
        jPanel8.add(this.displayBaseAddressSelector, "East");
        ColorChooserControls colorChooserControls = new ColorChooserControls();
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        jPanel.add(jPanel5);
        jPanel.add(jPanel6);
        jPanel.add(jPanel7);
        jPanel.add(jPanel8);
        jPanel.add(colorChooserControls.colorChooserRow);
        jPanel.add(colorChooserControls.countDisplayRow);
        return jPanel;
    }

    private JComponent buildVisualizationArea() {
        this.canvas = new GraphicsPanel();
        this.canvas.setPreferredSize(this.getDisplayAreaDimension());
        this.canvas.setToolTipText("Memory reference count visualization area");
        return this.canvas;
    }

    private void initializeDisplayBaseChoices() {
        int[] nArray = new int[]{Memory.textBaseAddress, Memory.dataSegmentBaseAddress, Memory.globalPointer, Memory.dataBaseAddress, Memory.heapBaseAddress, Memory.memoryMapBaseAddress};
        String[] stringArray = new String[]{" (text)", " (global data)", " (gp)", " (static data)", " (heap)", " (memory map)"};
        this.displayBaseAddresses = nArray;
        this.displayBaseAddressChoices = new String[nArray.length];
        for (int i = 0; i < this.displayBaseAddressChoices.length; ++i) {
            this.displayBaseAddressChoices[i] = Binary.intToHexString(nArray[i]) + stringArray[i];
        }
        this.defaultBaseAddressIndex = 3;
        this.baseAddress = nArray[this.defaultBaseAddressIndex];
    }

    private void updateBaseAddress() {
        this.baseAddress = this.displayBaseAddresses[this.displayBaseAddressSelector.getSelectedIndex()];
    }

    private Dimension getDisplayAreaDimension() {
        return new Dimension(this.visualizationAreaWidthInPixels, this.visualizationAreaHeightInPixels);
    }

    private void resetCounts() {
        this.theGrid.reset();
    }

    private int getIntComboBoxSelection(JComboBox<String> jComboBox) {
        try {
            return Integer.parseInt((String)jComboBox.getSelectedItem());
        }
        catch (NumberFormatException numberFormatException) {
            return 1;
        }
    }

    private JPanel getPanelWithBorderLayout() {
        return new JPanel(new BorderLayout(2, 2));
    }

    private Grid createNewGrid() {
        int n = this.visualizationAreaHeightInPixels / this.unitPixelHeight;
        int n2 = this.visualizationAreaWidthInPixels / this.unitPixelWidth;
        return new Grid(n, n2);
    }

    private void incrementReferenceCountForAddress(int n) {
        int n2 = (n - this.baseAddress) / 4 / this.wordsPerUnit;
        this.theGrid.incrementElement(n2 / this.theGrid.getColumns(), n2 % this.theGrid.getColumns());
    }

    private class Grid {
        int[][] grid;
        int rows;
        int columns;

        private Grid(int n, int n2) {
            this.grid = new int[n][n2];
            this.rows = n;
            this.columns = n2;
        }

        private int getRows() {
            return this.rows;
        }

        private int getColumns() {
            return this.columns;
        }

        private int getElement(int n, int n2) {
            return n >= 0 && n <= this.rows && n2 >= 0 && n2 <= this.columns ? this.grid[n][n2] : -1;
        }

        private int getElementFast(int n, int n2) {
            return this.grid[n][n2];
        }

        private int incrementElement(int n, int n2) {
            int n3;
            if (n >= 0 && n <= this.rows && n2 >= 0 && n2 <= this.columns) {
                int[] nArray = this.grid[n];
                int n4 = n2;
                n3 = nArray[n4] = nArray[n4] + 1;
            } else {
                n3 = -1;
            }
            return n3;
        }

        private void reset() {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.grid[i][j] = 0;
                }
            }
        }
    }

    private class CounterColor
    implements Comparable<CounterColor> {
        private int colorRangeStart;
        private Color associatedColor;

        public CounterColor(int n, Color color) {
            this.colorRangeStart = n;
            this.associatedColor = color;
        }

        @Override
        public int compareTo(CounterColor counterColor) {
            return this.colorRangeStart - counterColor.colorRangeStart;
        }
    }

    private class CounterColorScale {
        CounterColor[] counterColors;

        CounterColorScale(CounterColor[] counterColorArray) {
            this.counterColors = counterColorArray;
        }

        private Color getColor(int n) {
            Color color = this.counterColors[0].associatedColor;
            for (int i = 0; i < this.counterColors.length && n >= this.counterColors[i].colorRangeStart; ++i) {
                color = this.counterColors[i].associatedColor;
            }
            return color;
        }

        private int getHighEndOfRange(int n) {
            int n2 = Integer.MAX_VALUE;
            if (n < this.counterColors[this.counterColors.length - 1].colorRangeStart) {
                for (int i = 0; i < this.counterColors.length - 1 && n >= this.counterColors[i].colorRangeStart; ++i) {
                    n2 = this.counterColors[i + 1].colorRangeStart - 1;
                }
            }
            return n2;
        }

        private void insertOrReplace(CounterColor counterColor) {
            int n = Arrays.binarySearch(this.counterColors, counterColor);
            if (n >= 0) {
                this.counterColors[n] = counterColor;
            } else {
                int n2 = -n - 1;
                CounterColor[] counterColorArray = new CounterColor[this.counterColors.length + 1];
                System.arraycopy(this.counterColors, 0, counterColorArray, 0, n2);
                System.arraycopy(this.counterColors, n2, counterColorArray, n2 + 1, this.counterColors.length - n2);
                counterColorArray[n2] = counterColor;
                this.counterColors = counterColorArray;
            }
        }
    }

    private class ColorChooserControls {
        private JLabel sliderLabel = null;
        private JSlider colorRangeSlider = null;
        private JButton currentColorButton;
        private JPanel colorChooserRow;
        private JPanel countDisplayRow;
        private volatile int counterIndex;

        private ColorChooserControls() {
            this.colorRangeSlider = new JSlider(0, 0, MemoryReferenceVisualization.this.countTable.length - 1, 10);
            this.colorRangeSlider.setToolTipText("View or change color associated with each reference count value");
            this.colorRangeSlider.setPaintTicks(false);
            this.colorRangeSlider.addChangeListener(new ColorChooserListener());
            this.counterIndex = 10;
            this.sliderLabel = new JLabel(this.setLabel(MemoryReferenceVisualization.this.countTable[this.counterIndex]));
            this.sliderLabel.setToolTipText("Reference count values listed on non-linear scale of " + MemoryReferenceVisualization.this.countTable[0] + " to " + MemoryReferenceVisualization.this.countTable[MemoryReferenceVisualization.this.countTable.length - 1]);
            this.sliderLabel.setHorizontalAlignment(0);
            this.sliderLabel.setAlignmentX(0.5f);
            this.currentColorButton = new JButton("   ");
            this.currentColorButton.setToolTipText("Click here to change color for the reference count subrange based at current value");
            this.currentColorButton.setBackground(MemoryReferenceVisualization.this.counterColorScale.getColor(MemoryReferenceVisualization.this.countTable[this.counterIndex]));
            this.currentColorButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = MemoryReferenceVisualization.this.countTable[ColorChooserControls.this.counterIndex];
                    int n2 = MemoryReferenceVisualization.this.counterColorScale.getHighEndOfRange(n);
                    String string = "Select color for reference count " + (n == n2 ? "value " + n : "range " + n + "-" + n2);
                    Color color = JColorChooser.showDialog(MemoryReferenceVisualization.this.theWindow, string, MemoryReferenceVisualization.this.counterColorScale.getColor(n));
                    if (color != null && !color.equals(MemoryReferenceVisualization.this.counterColorScale.getColor(n))) {
                        MemoryReferenceVisualization.this.counterColorScale.insertOrReplace(new CounterColor(n, color));
                        ColorChooserControls.this.currentColorButton.setBackground(color);
                        MemoryReferenceVisualization.this.updateDisplay();
                    }
                }
            });
            this.colorChooserRow = new JPanel();
            this.countDisplayRow = new JPanel();
            this.colorChooserRow.add(this.colorRangeSlider);
            this.colorChooserRow.add(this.currentColorButton);
            this.countDisplayRow.add(this.sliderLabel);
        }

        private String setLabel(int n) {
            String string = "  ";
            if (n >= 10) {
                string = " ";
            } else if (n >= 100) {
                string = "";
            }
            return "Counter value " + string + n;
        }

        private class ColorChooserListener
        implements ChangeListener {
            private ColorChooserListener() {
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                if (!jSlider.getValueIsAdjusting()) {
                    ColorChooserControls.this.counterIndex = jSlider.getValue();
                } else {
                    int n = MemoryReferenceVisualization.this.countTable[jSlider.getValue()];
                    ColorChooserControls.this.sliderLabel.setText(ColorChooserControls.this.setLabel(n));
                    ColorChooserControls.this.currentColorButton.setBackground(MemoryReferenceVisualization.this.counterColorScale.getColor(n));
                }
            }
        }
    }

    private class GraphicsPanel
    extends JPanel {
        private GraphicsPanel() {
        }

        @Override
        public void paint(Graphics graphics) {
            this.paintGrid(graphics, MemoryReferenceVisualization.this.theGrid);
            if (MemoryReferenceVisualization.this.drawHashMarksSelector.isSelected()) {
                this.paintHashMarks(graphics, MemoryReferenceVisualization.this.theGrid);
            }
        }

        private void paintHashMarks(Graphics graphics, Grid grid) {
            int n;
            graphics.setColor(this.getContrastingColor(MemoryReferenceVisualization.this.counterColorScale.getColor(0)));
            int n2 = 0;
            int n3 = MemoryReferenceVisualization.this.visualizationAreaWidthInPixels;
            int n4 = 0;
            int n5 = MemoryReferenceVisualization.this.visualizationAreaHeightInPixels;
            for (n = 0; n < grid.getColumns(); ++n) {
                graphics.drawLine(n2, n4, n2, n5);
                n2 += MemoryReferenceVisualization.this.unitPixelWidth;
            }
            n2 = 0;
            for (n = 0; n < grid.getRows(); ++n) {
                graphics.drawLine(n2, n4, n3, n4);
                n4 += MemoryReferenceVisualization.this.unitPixelHeight;
            }
        }

        private void paintGrid(Graphics graphics, Grid grid) {
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < grid.getRows(); ++i) {
                for (int j = 0; j < grid.getColumns(); ++j) {
                    graphics.setColor(MemoryReferenceVisualization.this.counterColorScale.getColor(grid.getElementFast(i, j)));
                    graphics.fillRect(n, n2, MemoryReferenceVisualization.this.unitPixelWidth, MemoryReferenceVisualization.this.unitPixelHeight);
                    n += MemoryReferenceVisualization.this.unitPixelWidth;
                }
                n = 0;
                n2 += MemoryReferenceVisualization.this.unitPixelHeight;
            }
        }

        private Color getContrastingColor(Color color) {
            return new Color(color.getRGB() ^ 0xFFFFFF);
        }
    }
}

