/*
 * Decompiled with CFR 0.152.
 */
package rars.util;

import java.util.Arrays;
import rars.Globals;

public class Binary {
    private static char[] chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final long UNSIGNED_BASE = 0x100000000L;

    public static String intToBinaryString(int n, int n2) {
        char[] cArray = new char[n2];
        int n3 = n2 - 1;
        for (int i = 0; i < n2; ++i) {
            cArray[n3] = Binary.bitValue(n, i) == 1 ? 49 : 48;
            --n3;
        }
        return new String(cArray);
    }

    public static String intToBinaryString(int n) {
        return Binary.intToBinaryString(n, 32);
    }

    public static String longToBinaryString(long l, int n) {
        char[] cArray = new char[n];
        int n2 = n - 1;
        for (int i = 0; i < n; ++i) {
            cArray[n2] = Binary.bitValue(l, i) == 1 ? 49 : 48;
            --n2;
        }
        return new String(cArray);
    }

    public static String longToBinaryString(long l) {
        return Binary.longToBinaryString(l, 64);
    }

    public static int binaryStringToInt(String string) {
        int n = string.charAt(0) - 48;
        for (int i = 1; i < string.length(); ++i) {
            n = n << 1 | string.charAt(i) - 48;
        }
        return n;
    }

    public static long binaryStringToLong(String string) {
        long l = string.charAt(0) - 48;
        for (int i = 1; i < string.length(); ++i) {
            l = l << 1 | (long)(string.charAt(i) - 48);
        }
        return l;
    }

    public static String binaryStringToHexString(String string) {
        int n = (string.length() + 3) / 4;
        char[] cArray = new char[n + 2];
        cArray[0] = 48;
        cArray[1] = 120;
        int n2 = string.length() - 1;
        for (int i = 0; i < n; ++i) {
            int n3 = 0;
            int n4 = 1;
            for (int j = 0; j < 4 && n2 >= 0; --n2, ++j) {
                if (string.charAt(n2) == '1') {
                    n3 += n4;
                }
                n4 *= 2;
            }
            cArray[n - i + 1] = chars[n3];
        }
        return new String(cArray);
    }

    public static String hexStringToBinaryString(String string) {
        String string2 = "";
        if (string.indexOf("0x") == 0 || string.indexOf("0X") == 0) {
            string = string.substring(2);
        }
        block18: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '0': {
                    string2 = string2 + "0000";
                    continue block18;
                }
                case '1': {
                    string2 = string2 + "0001";
                    continue block18;
                }
                case '2': {
                    string2 = string2 + "0010";
                    continue block18;
                }
                case '3': {
                    string2 = string2 + "0011";
                    continue block18;
                }
                case '4': {
                    string2 = string2 + "0100";
                    continue block18;
                }
                case '5': {
                    string2 = string2 + "0101";
                    continue block18;
                }
                case '6': {
                    string2 = string2 + "0110";
                    continue block18;
                }
                case '7': {
                    string2 = string2 + "0111";
                    continue block18;
                }
                case '8': {
                    string2 = string2 + "1000";
                    continue block18;
                }
                case '9': {
                    string2 = string2 + "1001";
                    continue block18;
                }
                case 'A': 
                case 'a': {
                    string2 = string2 + "1010";
                    continue block18;
                }
                case 'B': 
                case 'b': {
                    string2 = string2 + "1011";
                    continue block18;
                }
                case 'C': 
                case 'c': {
                    string2 = string2 + "1100";
                    continue block18;
                }
                case 'D': 
                case 'd': {
                    string2 = string2 + "1101";
                    continue block18;
                }
                case 'E': 
                case 'e': {
                    string2 = string2 + "1110";
                    continue block18;
                }
                case 'F': 
                case 'f': {
                    string2 = string2 + "1111";
                }
            }
        }
        return string2;
    }

    public static char binaryStringToHexDigit(String string) {
        if (string.length() > 4) {
            return '0';
        }
        int n = 0;
        int n2 = 1;
        for (int i = string.length() - 1; i >= 0; --i) {
            if (string.charAt(i) == '1') {
                n += n2;
            }
            n2 *= 2;
        }
        return chars[n];
    }

    public static String intToHexString(int n) {
        String string = new String("0");
        String string2 = new String("0x");
        String string3 = Integer.toHexString(n);
        while (string3.length() < 8) {
            string3 = string.concat(string3);
        }
        string3 = string2.concat(string3);
        return string3;
    }

    public static String intToHalfHexString(int n) {
        String string = new String("0");
        String string2 = new String("0x");
        String string3 = Integer.toHexString(n);
        if (string3.length() > 4) {
            string3 = string3.substring(string3.length() - 4, string3.length());
        }
        while (string3.length() < 4) {
            string3 = string.concat(string3);
        }
        string3 = string2.concat(string3);
        return string3;
    }

    public static String longToHexString(long l) {
        return Binary.binaryStringToHexString(Binary.longToBinaryString(l));
    }

    public static String unsignedIntToIntString(int n) {
        return n >= 0 ? Integer.toString(n) : Long.toString(0x100000000L + (long)n);
    }

    public static String intToAscii(int n) {
        StringBuilder stringBuilder = new StringBuilder(8);
        for (int i = 3; i >= 0; --i) {
            int n2 = Binary.getByte(n, i);
            stringBuilder.append(n2 < Globals.ASCII_TABLE.length ? Globals.ASCII_TABLE[n2] : Globals.ASCII_NON_PRINT);
        }
        return stringBuilder.toString();
    }

    public static int stringToInt(String string) throws NumberFormatException {
        Integer n = Binary.stringToIntFast(string);
        if (n == null) {
            throw new NumberFormatException();
        }
        return n;
    }

    public static Integer stringToIntFast(String string) {
        if (string.length() == 0) {
            return null;
        }
        char c = string.charAt(0);
        if (('0' > c || c > '9') && c != '-') {
            return null;
        }
        int n = 0;
        int n2 = 0;
        if (c == '-') {
            n2 = 1;
        }
        if (string.length() > 2 + n2 && string.charAt(n2) == '0' && (string.charAt(n2 + 1) == 'x' || string.charAt(n2 + 1) == 'X')) {
            if (string.length() > 10 + n2) {
                return null;
            }
            n2 += 2;
            while (n2 < string.length()) {
                char c2 = string.charAt(n2);
                n *= 16;
                if ('0' <= c2 && c2 <= '9') {
                    n += c2 - 48;
                } else if ('a' <= c2 && c2 <= 'f') {
                    n += c2 - 97 + 10;
                } else if ('A' <= c2 && c2 <= 'F') {
                    n += c2 - 65 + 10;
                } else {
                    return null;
                }
                ++n2;
            }
        } else if (c == '0') {
            while (n2 < string.length()) {
                char c3 = string.charAt(n2);
                if ('0' <= c3 && c3 <= '7') {
                    n *= 8;
                    n += c3 - 48;
                } else {
                    return null;
                }
                ++n2;
            }
            if (n < 0) {
                return null;
            }
        } else {
            while (n2 < string.length()) {
                char c4 = string.charAt(n2);
                if ('0' <= c4 && c4 <= '9') {
                    n *= 10;
                    n += c4 - 48;
                } else {
                    return null;
                }
                ++n2;
            }
        }
        if (n == Integer.MIN_VALUE && c == '-') {
            return Integer.MIN_VALUE;
        }
        if (n < 0 && c == '-') {
            return null;
        }
        if (c == '-') {
            n *= -1;
        }
        return n;
    }

    public static long stringToLong(String string) throws NumberFormatException {
        String string2 = new String(string);
        long l = 0L;
        try {
            l = Long.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            string2 = string2.toLowerCase();
            if (string2.length() == 18 && string2.startsWith("0x")) {
                String string3 = "";
                for (int i = 2; i < 18; ++i) {
                    int n = Arrays.binarySearch(chars, string2.charAt(i));
                    if (n < 0) {
                        throw new NumberFormatException();
                    }
                    string3 = string3 + Binary.intToBinaryString(n, 4);
                }
                l = Binary.binaryStringToLong(string3);
            }
            throw new NumberFormatException();
        }
        return l;
    }

    public static int highOrderLongToInt(long l) {
        return (int)(l >> 32);
    }

    public static int lowOrderLongToInt(long l) {
        return (int)(l << 32 >> 32);
    }

    public static long twoIntsToLong(int n, int n2) {
        return (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    public static int bitValue(int n, int n2) {
        return 1 & n >> n2;
    }

    public static int bitValue(long l, int n) {
        return (int)(1L & l >> n);
    }

    public static int setBit(int n, int n2) {
        return n | 1 << n2;
    }

    public static int clearBit(int n, int n2) {
        return n & ~(1 << n2);
    }

    public static int setByte(int n, int n2, int n3) {
        return n & ~(255 << (n2 << 3)) | (n3 & 0xFF) << (n2 << 3);
    }

    public static int getByte(int n, int n2) {
        return n << (3 - n2 << 3) >>> 24;
    }

    public static boolean isHex(String string) {
        try {
            try {
                Binary.stringToInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Binary.stringToLong(string);
                }
                catch (NumberFormatException numberFormatException2) {
                    return false;
                }
            }
            if (string.charAt(0) == '-' && string.charAt(1) == '0' && Character.toUpperCase(string.charAt(1)) == 'X') {
                return true;
            }
            if (string.charAt(0) == '0' && Character.toUpperCase(string.charAt(1)) == 'X') {
                return true;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return false;
        }
        return false;
    }

    public static boolean isOctal(String string) {
        try {
            int n = Binary.stringToInt(string);
            if (Binary.isHex(string)) {
                return false;
            }
            if (string.charAt(0) == '-' && string.charAt(1) == '0' && string.length() > 1) {
                return true;
            }
            if (string.charAt(0) == '0' && string.length() > 1) {
                return true;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return false;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return false;
    }
}

