/*
 * Decompiled with CFR 0.152.
 */
package rars.venus;

import java.io.File;
import rars.venus.EditTabbedPane;
import rars.venus.FileStatus;
import rars.venus.VenusUI;

public class Editor {
    public static final int MIN_TAB_SIZE = 1;
    public static final int MAX_TAB_SIZE = 32;
    public static final int MIN_BLINK_RATE = 0;
    public static final int MAX_BLINK_RATE = 1000;
    private VenusUI mainUI;
    private EditTabbedPane editTabbedPane;
    private String mainUIbaseTitle;
    private int newUsageCount;
    private String defaultOpenDirectory;
    private String currentOpenDirectory;
    private String defaultSaveDirectory;
    private String currentSaveDirectory;

    public Editor(VenusUI venusUI) {
        this.mainUI = venusUI;
        FileStatus.reset();
        this.mainUIbaseTitle = this.mainUI.getTitle();
        this.newUsageCount = 0;
        this.defaultOpenDirectory = System.getProperty("user.dir");
        this.defaultSaveDirectory = System.getProperty("user.dir");
        this.currentOpenDirectory = this.defaultOpenDirectory;
        this.currentSaveDirectory = this.defaultSaveDirectory;
    }

    public String[] getOpenFilePaths() {
        return this.editTabbedPane.getOpenFilePaths();
    }

    public void setEditTabbedPane(EditTabbedPane editTabbedPane) {
        this.editTabbedPane = editTabbedPane;
    }

    public String getCurrentOpenDirectory() {
        return this.currentOpenDirectory;
    }

    void setCurrentOpenDirectory(String string) {
        File file = new File(string);
        this.currentOpenDirectory = !file.exists() || !file.isDirectory() ? this.defaultOpenDirectory : string;
    }

    public String getCurrentSaveDirectory() {
        return this.currentSaveDirectory;
    }

    void setCurrentSaveDirectory(String string) {
        File file = new File(string);
        this.currentSaveDirectory = !file.exists() || !file.isDirectory() ? this.defaultSaveDirectory : string;
    }

    public String getNextDefaultFilename() {
        ++this.newUsageCount;
        return "riscv" + this.newUsageCount + ".asm";
    }

    public void setTitle(String string, String string2, int n) {
        if (n == 0 || string2 == null || string2.length() == 0) {
            this.mainUI.setTitle(this.mainUIbaseTitle);
        } else {
            String string3 = n == 2 || n == 4 ? "*" : " ";
            String string4 = n == 2 || n == 1 ? string2 : string;
            this.mainUI.setTitle(string4 + string3 + " - " + this.mainUIbaseTitle);
            this.editTabbedPane.setTitleAt(this.editTabbedPane.getSelectedIndex(), string2 + string3);
        }
    }

    public void newFile() {
        this.editTabbedPane.newFile();
    }

    public boolean close() {
        return this.editTabbedPane.closeCurrentFile();
    }

    public boolean closeAll() {
        return this.editTabbedPane.closeAllFiles();
    }

    public boolean save() {
        return this.editTabbedPane.saveCurrentFile();
    }

    public boolean saveAs() {
        return this.editTabbedPane.saveAsCurrentFile();
    }

    public boolean saveAll() {
        return this.editTabbedPane.saveAllFiles();
    }

    public boolean open() {
        return this.editTabbedPane.openFile();
    }

    public boolean editsSavedOrAbandoned() {
        return this.editTabbedPane.editsSavedOrAbandoned();
    }
}

