/*
 * Decompiled with CFR 0.152.
 */
package rars.venus;

import java.awt.Dimension;
import javax.swing.JDesktopPane;
import rars.Globals;
import rars.Settings;
import rars.venus.DataSegmentWindow;
import rars.venus.LabelsWindow;
import rars.venus.NumberDisplayBaseChooser;
import rars.venus.TextSegmentWindow;
import rars.venus.VenusUI;
import rars.venus.registers.ControlAndStatusWindow;
import rars.venus.registers.FloatingPointWindow;
import rars.venus.registers.RegistersWindow;

public class ExecutePane
extends JDesktopPane {
    private RegistersWindow registerValues;
    private FloatingPointWindow fpRegValues;
    private ControlAndStatusWindow csrValues;
    private DataSegmentWindow dataSegment;
    private TextSegmentWindow textSegment;
    private LabelsWindow labelValues;
    private VenusUI mainUI;
    private NumberDisplayBaseChooser valueDisplayBase;
    private NumberDisplayBaseChooser addressDisplayBase;
    private boolean labelWindowVisible;

    public ExecutePane(VenusUI venusUI, RegistersWindow registersWindow, FloatingPointWindow floatingPointWindow, ControlAndStatusWindow controlAndStatusWindow) {
        this.mainUI = venusUI;
        this.addressDisplayBase = new NumberDisplayBaseChooser("Hexadecimal Addresses", Globals.getSettings().getBooleanSetting(Settings.Bool.DISPLAY_ADDRESSES_IN_HEX));
        this.valueDisplayBase = new NumberDisplayBaseChooser("Hexadecimal Values", Globals.getSettings().getBooleanSetting(Settings.Bool.DISPLAY_VALUES_IN_HEX));
        this.addressDisplayBase.setToolTipText("If checked, displays all memory addresses in hexadecimal.  Otherwise, decimal.");
        this.valueDisplayBase.setToolTipText("If checked, displays all memory and register contents in hexadecimal.  Otherwise, decimal.");
        NumberDisplayBaseChooser[] numberDisplayBaseChooserArray = new NumberDisplayBaseChooser[]{this.addressDisplayBase, this.valueDisplayBase};
        this.registerValues = registersWindow;
        this.fpRegValues = floatingPointWindow;
        this.csrValues = controlAndStatusWindow;
        this.textSegment = new TextSegmentWindow();
        this.dataSegment = new DataSegmentWindow(numberDisplayBaseChooserArray);
        this.labelValues = new LabelsWindow();
        this.labelWindowVisible = Globals.getSettings().getBooleanSetting(Settings.Bool.LABEL_WINDOW_VISIBILITY);
        this.add(this.textSegment);
        this.add(this.dataSegment);
        this.add(this.labelValues);
        this.textSegment.pack();
        this.dataSegment.pack();
        this.labelValues.pack();
        this.textSegment.setVisible(true);
        this.dataSegment.setVisible(true);
        this.labelValues.setVisible(this.labelWindowVisible);
    }

    public void setWindowBounds() {
        int n = this.getSize().width - this.getInsets().left - this.getInsets().right;
        int n2 = this.getSize().height - this.getInsets().top - this.getInsets().bottom;
        int n3 = n2 / 2;
        Dimension dimension = new Dimension((int)((double)n * 0.75), n3);
        Dimension dimension2 = new Dimension(n, n3);
        Dimension dimension3 = new Dimension((int)((double)n * 0.25), n3);
        Dimension dimension4 = new Dimension(n, n3);
        this.dataSegment.setBounds(0, dimension.height + 1, dimension2.width, dimension2.height);
        if (this.labelWindowVisible) {
            this.textSegment.setBounds(0, 0, dimension.width, dimension.height);
            this.labelValues.setBounds(dimension.width + 1, 0, dimension3.width, dimension3.height);
        } else {
            this.textSegment.setBounds(0, 0, dimension4.width, dimension4.height);
            this.labelValues.setBounds(0, 0, 0, 0);
        }
    }

    public void setLabelWindowVisibility(boolean bl) {
        if (!bl && this.labelWindowVisible) {
            this.labelWindowVisible = false;
            this.textSegment.setVisible(false);
            this.labelValues.setVisible(false);
            this.setWindowBounds();
            this.textSegment.setVisible(true);
        } else if (bl && !this.labelWindowVisible) {
            this.labelWindowVisible = true;
            this.textSegment.setVisible(false);
            this.setWindowBounds();
            this.textSegment.setVisible(true);
            this.labelValues.setVisible(true);
        }
    }

    public void clearPane() {
        this.getTextSegmentWindow().clearWindow();
        this.getDataSegmentWindow().clearWindow();
        this.getRegistersWindow().clearWindow();
        this.getFloatingPointWindow().clearWindow();
        this.getControlAndStatusWindow().clearWindow();
        this.getLabelsWindow().clearWindow();
        if (this.mainUI.getMainPane().getSelectedComponent() == this) {
            this.mainUI.getMainPane().setSelectedComponent(this.mainUI.getMainPane().getEditTabbedPane());
            this.mainUI.getMainPane().setSelectedComponent(this);
        }
    }

    public TextSegmentWindow getTextSegmentWindow() {
        return this.textSegment;
    }

    public DataSegmentWindow getDataSegmentWindow() {
        return this.dataSegment;
    }

    public RegistersWindow getRegistersWindow() {
        return this.registerValues;
    }

    public FloatingPointWindow getFloatingPointWindow() {
        return this.fpRegValues;
    }

    public ControlAndStatusWindow getControlAndStatusWindow() {
        return this.csrValues;
    }

    public LabelsWindow getLabelsWindow() {
        return this.labelValues;
    }

    public int getValueDisplayBase() {
        return this.valueDisplayBase.getBase();
    }

    public int getAddressDisplayBase() {
        return this.addressDisplayBase.getBase();
    }

    public NumberDisplayBaseChooser getValueDisplayBaseChooser() {
        return this.valueDisplayBase;
    }

    public NumberDisplayBaseChooser getAddressDisplayBaseChooser() {
        return this.addressDisplayBase;
    }

    public void numberDisplayBaseChanged(NumberDisplayBaseChooser numberDisplayBaseChooser) {
        if (numberDisplayBaseChooser == this.valueDisplayBase) {
            this.registerValues.updateRegisters();
            this.fpRegValues.updateRegisters();
            this.csrValues.updateRegisters();
            this.dataSegment.updateValues();
            this.textSegment.updateBasicStatements();
        } else {
            this.dataSegment.updateDataAddresses();
            this.labelValues.updateLabelAddresses();
            this.textSegment.updateCodeAddresses();
            this.textSegment.updateBasicStatements();
        }
    }
}

