/*
 * Decompiled with CFR 0.152.
 */
package rars.venus;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import rars.Globals;
import rars.util.Binary;

public class NumberDisplayBaseChooser
extends JCheckBox {
    public static final int DECIMAL = 10;
    public static final int HEXADECIMAL = 16;
    public static final int ASCII = 0;
    private int base;
    private JCheckBoxMenuItem settingMenuItem;

    public NumberDisplayBaseChooser(String string, boolean bl) {
        super(string, bl);
        this.base = NumberDisplayBaseChooser.getBase(bl);
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                NumberDisplayBaseChooser numberDisplayBaseChooser = (NumberDisplayBaseChooser)itemEvent.getItem();
                if (itemEvent.getStateChange() == 1) {
                    numberDisplayBaseChooser.setBase(16);
                } else {
                    numberDisplayBaseChooser.setBase(10);
                }
                if (NumberDisplayBaseChooser.this.settingMenuItem != null) {
                    NumberDisplayBaseChooser.this.settingMenuItem.setSelected(numberDisplayBaseChooser.isSelected());
                    ActionListener[] actionListenerArray = NumberDisplayBaseChooser.this.settingMenuItem.getActionListeners();
                    ActionEvent actionEvent = new ActionEvent(NumberDisplayBaseChooser.this.settingMenuItem, 0, "chooser");
                    for (ActionListener actionListener : actionListenerArray) {
                        actionListener.actionPerformed(actionEvent);
                    }
                }
                Globals.getGui().getMainPane().getExecutePane().numberDisplayBaseChanged(numberDisplayBaseChooser);
            }
        });
    }

    public int getBase() {
        return this.base;
    }

    public void setBase(int n) {
        if (n == 10 || n == 16) {
            this.base = n;
        }
    }

    public static String formatUnsignedInteger(int n, int n2) {
        if (n2 == 16) {
            return Binary.intToHexString(n);
        }
        return Binary.unsignedIntToIntString(n);
    }

    public static String formatNumber(int n, int n2) {
        String string;
        switch (n2) {
            case 16: {
                string = Binary.intToHexString(n);
                break;
            }
            case 10: {
                string = Integer.toString(n);
                break;
            }
            case 0: {
                string = Binary.intToAscii(n);
                break;
            }
            default: {
                string = Integer.toString(n);
            }
        }
        return string;
    }

    public static String formatNumber(float f, int n) {
        if (n == 16) {
            return Binary.intToHexString(Float.floatToIntBits(f));
        }
        return Float.toString(f);
    }

    public static String formatNumber(double d, int n) {
        if (n == 16) {
            long l = Double.doubleToLongBits(d);
            return Binary.intToHexString(Binary.highOrderLongToInt(l)) + Binary.intToHexString(Binary.lowOrderLongToInt(l)).substring(2);
        }
        return Double.toString(d);
    }

    public String formatNumber(int n) {
        if (this.base == 16) {
            return Binary.intToHexString(n);
        }
        return new Integer(n).toString();
    }

    public String formatUnsignedInteger(int n) {
        return NumberDisplayBaseChooser.formatUnsignedInteger(n, this.base);
    }

    public static String formatFloatNumber(int n, int n2) {
        if (n2 == 16) {
            return Binary.intToHexString(n);
        }
        return Float.toString(Float.intBitsToFloat(n));
    }

    public static String formatDoubleNumber(long l, int n) {
        if (n == 16) {
            return Binary.longToHexString(l);
        }
        return Double.toString(Double.longBitsToDouble(l));
    }

    public void setSettingsMenuItem(JCheckBoxMenuItem jCheckBoxMenuItem) {
        this.settingMenuItem = jCheckBoxMenuItem;
    }

    public static int getBase(boolean bl) {
        return bl ? 16 : 10;
    }
}

