/*
 * Decompiled with CFR 0.152.
 */
package rars.venus;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import rars.Globals;
import rars.Settings;
import rars.riscv.dump.DumpFormatLoader;
import rars.simulator.Simulator;
import rars.venus.EditFindReplaceAction;
import rars.venus.EditPane;
import rars.venus.Editor;
import rars.venus.FileDumpMemoryAction;
import rars.venus.FileStatus;
import rars.venus.GuiAction;
import rars.venus.HelpAboutAction;
import rars.venus.HelpHelpAction;
import rars.venus.MainPane;
import rars.venus.MessagesPane;
import rars.venus.ToolLoader;
import rars.venus.registers.ControlAndStatusWindow;
import rars.venus.registers.FloatingPointWindow;
import rars.venus.registers.RegistersPane;
import rars.venus.registers.RegistersWindow;
import rars.venus.run.RunAssembleAction;
import rars.venus.run.RunBackstepAction;
import rars.venus.run.RunClearBreakpointsAction;
import rars.venus.run.RunGoAction;
import rars.venus.run.RunResetAction;
import rars.venus.run.RunSpeedPanel;
import rars.venus.run.RunStepAction;
import rars.venus.settings.SettingsAction;
import rars.venus.settings.SettingsEditorAction;
import rars.venus.settings.SettingsExceptionHandlerAction;
import rars.venus.settings.SettingsHighlightingAction;
import rars.venus.settings.SettingsMemoryConfigurationAction;

public class VenusUI
extends JFrame {
    VenusUI mainUI = this;
    public JMenuBar menu;
    private JToolBar toolbar;
    private MainPane mainPane;
    private RegistersPane registersPane;
    private RegistersWindow registersTab;
    private FloatingPointWindow fpTab;
    private ControlAndStatusWindow csrTab;
    private MessagesPane messagesPane;
    private JSplitPane splitter;
    private JSplitPane horizonSplitter;
    JPanel north;
    private int frameState;
    private static int menuState = 0;
    private boolean reset = true;
    private boolean started = false;
    Editor editor;
    private JMenu file;
    private JMenu run;
    private JMenu window;
    private JMenu help;
    private JMenu edit;
    private JMenu settings;
    private JMenuItem fileNew;
    private JMenuItem fileOpen;
    private JMenuItem fileClose;
    private JMenuItem fileCloseAll;
    private JMenuItem fileSave;
    private JMenuItem fileSaveAs;
    private JMenuItem fileSaveAll;
    private JMenuItem fileDumpMemory;
    private JMenuItem fileExit;
    private JMenuItem editUndo;
    private JMenuItem editRedo;
    private JMenuItem editCut;
    private JMenuItem editCopy;
    private JMenuItem editPaste;
    private JMenuItem editFindReplace;
    private JMenuItem editSelectAll;
    private JMenuItem runGo;
    private JMenuItem runStep;
    private JMenuItem runBackstep;
    private JMenuItem runReset;
    private JMenuItem runAssemble;
    private JMenuItem runStop;
    private JMenuItem runPause;
    private JMenuItem runClearBreakpoints;
    private JMenuItem runToggleBreakpoints;
    private JCheckBoxMenuItem settingsLabel;
    private JCheckBoxMenuItem settingsPopupInput;
    private JCheckBoxMenuItem settingsValueDisplayBase;
    private JCheckBoxMenuItem settingsAddressDisplayBase;
    private JCheckBoxMenuItem settingsExtended;
    private JCheckBoxMenuItem settingsAssembleOnOpen;
    private JCheckBoxMenuItem settingsAssembleAll;
    private JCheckBoxMenuItem settingsAssembleOpen;
    private JCheckBoxMenuItem settingsWarningsAreErrors;
    private JCheckBoxMenuItem settingsStartAtMain;
    private JCheckBoxMenuItem settingsProgramArguments;
    private JCheckBoxMenuItem settingsSelfModifyingCode;
    private JMenuItem settingsExceptionHandler;
    private JMenuItem settingsEditor;
    private JMenuItem settingsHighlighting;
    private JMenuItem settingsMemoryConfiguration;
    private JMenuItem helpHelp;
    private JMenuItem helpAbout;
    private JButton Undo;
    private JButton Redo;
    private JButton Cut;
    private JButton Copy;
    private JButton Paste;
    private JButton FindReplace;
    private JButton SelectAll;
    private JButton New;
    private JButton Open;
    private JButton Save;
    private JButton SaveAs;
    private JButton SaveAll;
    private JButton DumpMemory;
    private JButton Run;
    private JButton Assemble;
    private JButton Reset;
    private JButton Step;
    private JButton Backstep;
    private JButton Stop;
    private JButton Pause;
    private JButton Help;
    private Action fileNewAction;
    private Action fileOpenAction;
    private Action fileCloseAction;
    private Action fileCloseAllAction;
    private Action fileSaveAction;
    private Action fileSaveAsAction;
    private Action fileSaveAllAction;
    private Action fileDumpMemoryAction;
    private Action fileExitAction;
    private Action editUndoAction;
    private Action editRedoAction;
    private Action editCutAction;
    private Action editCopyAction;
    private Action editPasteAction;
    private Action editFindReplaceAction;
    private Action editSelectAllAction;
    private Action runAssembleAction;
    private Action runGoAction;
    private Action runStepAction;
    private Action runBackstepAction;
    private Action runResetAction;
    private Action runStopAction;
    private Action runPauseAction;
    private Action runClearBreakpointsAction;
    private Action runToggleBreakpointsAction;
    private Action settingsLabelAction;
    private Action settingsPopupInputAction;
    private Action settingsValueDisplayBaseAction;
    private Action settingsAddressDisplayBaseAction;
    private Action settingsExtendedAction;
    private Action settingsAssembleOnOpenAction;
    private Action settingsAssembleOpenAction;
    private Action settingsAssembleAllAction;
    private Action settingsWarningsAreErrorsAction;
    private Action settingsStartAtMainAction;
    private Action settingsProgramArgumentsAction;
    private Action settingsExceptionHandlerAction;
    private Action settingsEditorAction;
    private Action settingsHighlightingAction;
    private Action settingsMemoryConfigurationAction;
    private Action settingsSelfModifyingCodeAction;
    private Action helpHelpAction;
    private Action helpAboutAction;

    public VenusUI(String string) {
        super(string);
        Globals.setGui(this);
        this.editor = new Editor(this);
        double d = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        double d2 = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        double d3 = d < 1000.0 ? 0.67 : 0.73;
        double d4 = d < 1000.0 ? 0.12 : 0.15;
        double d5 = d < 1000.0 ? 0.67 : 0.73;
        double d6 = d < 1000.0 ? 0.6 : 0.65;
        double d7 = d < 1000.0 ? 0.18 : 0.22;
        double d8 = d < 1000.0 ? 0.72 : 0.8;
        Dimension dimension = new Dimension((int)(d * d3), (int)(d2 * d4));
        Dimension dimension2 = new Dimension((int)(d * d5), (int)(d2 * d6));
        Dimension dimension3 = new Dimension((int)(d * d7), (int)(d2 * d8));
        Globals.initialize(true);
        URL uRL = this.getClass().getResource("/images/RISC-V.png");
        if (uRL == null) {
            System.out.println("Internal Error: images folder or file not found");
            System.exit(0);
        }
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        this.setIconImage(image);
        this.registersTab = new RegistersWindow();
        this.fpTab = new FloatingPointWindow();
        this.csrTab = new ControlAndStatusWindow();
        this.registersPane = new RegistersPane(this.mainUI, this.registersTab, this.fpTab, this.csrTab);
        this.registersPane.setPreferredSize(dimension3);
        this.mainPane = new MainPane(this.mainUI, this.editor, this.registersTab, this.fpTab, this.csrTab);
        this.mainPane.setPreferredSize(dimension2);
        this.messagesPane = new MessagesPane();
        this.messagesPane.setPreferredSize(dimension);
        this.splitter = new JSplitPane(0, this.mainPane, this.messagesPane);
        this.splitter.setOneTouchExpandable(true);
        this.splitter.resetToPreferredSizes();
        this.horizonSplitter = new JSplitPane(1, this.splitter, this.registersPane);
        this.horizonSplitter.setOneTouchExpandable(true);
        this.horizonSplitter.resetToPreferredSizes();
        this.createActionObjects();
        this.menu = this.setUpMenuBar();
        this.setJMenuBar(this.menu);
        this.toolbar = this.setUpToolBar();
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.toolbar);
        jPanel.add(RunSpeedPanel.getInstance());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add(this.horizonSplitter);
        this.getContentPane().add(jPanel2);
        FileStatus.reset();
        FileStatus.set(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                VenusUI.this.mainUI.setExtendedState(6);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (VenusUI.this.mainUI.editor.closeAll()) {
                    System.exit(0);
                }
            }
        });
        this.setDefaultCloseOperation(0);
        this.pack();
        this.setVisible(true);
    }

    private void createActionObjects() {
        try {
            this.fileNewAction = new GuiAction("New", this.loadIcon("New22.png"), "Create a new file for editing", 78, this.makeShortcut(78)){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    VenusUI.this.editor.newFile();
                }
            };
            this.fileOpenAction = new GuiAction("Open ...", this.loadIcon("Open22.png"), "Open a file for editing", 79, this.makeShortcut(79)){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    VenusUI.this.editor.open();
                }
            };
            this.fileCloseAction = new GuiAction("Close", null, "Close the current file", 67, this.makeShortcut(87)){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    VenusUI.this.editor.close();
                }
            };
            this.fileCloseAllAction = new GuiAction("Close All", null, "Close all open files", 76, null){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    VenusUI.this.editor.closeAll();
                }
            };
            this.fileSaveAction = new GuiAction("Save", this.loadIcon("Save22.png"), "Save the current file", 83, this.makeShortcut(83)){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    VenusUI.this.editor.save();
                }
            };
            this.fileSaveAsAction = new GuiAction("Save as ...", this.loadIcon("SaveAs22.png"), "Save current file with different name", 65, null){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    VenusUI.this.editor.saveAs();
                }
            };
            this.fileSaveAllAction = new GuiAction("Save All", null, "Save all open files", 86, null){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    VenusUI.this.editor.saveAll();
                }
            };
            this.fileDumpMemoryAction = new FileDumpMemoryAction("Dump Memory ...", this.loadIcon("Dump22.png"), "Dump machine code or data in an available format", 68, this.makeShortcut(68), this.mainUI);
            this.fileExitAction = new GuiAction("Exit", null, "Exit Rars", 88, null){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (VenusUI.this.editor.closeAll()) {
                        System.exit(0);
                    }
                }
            };
            this.editUndoAction = new GuiAction("Undo", this.loadIcon("Undo22.png"), "Undo last edit", 85, this.makeShortcut(90)){
                {
                    this.setEnabled(false);
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EditPane editPane = VenusUI.this.mainPane.getEditPane();
                    if (editPane != null) {
                        editPane.undo();
                        VenusUI.this.updateUndoAndRedoState();
                    }
                }
            };
            this.editRedoAction = new GuiAction("Redo", this.loadIcon("Redo22.png"), "Redo last edit", 82, this.makeShortcut(89)){
                {
                    this.setEnabled(false);
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EditPane editPane = VenusUI.this.mainPane.getEditPane();
                    if (editPane != null) {
                        editPane.redo();
                        VenusUI.this.updateUndoAndRedoState();
                    }
                }
            };
            this.editCutAction = new GuiAction("Cut", this.loadIcon("Cut22.gif"), "Cut", 67, this.makeShortcut(88)){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    VenusUI.this.mainPane.getEditPane().cutText();
                }
            };
            this.editCopyAction = new GuiAction("Copy", this.loadIcon("Copy22.png"), "Copy", 79, this.makeShortcut(67)){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    VenusUI.this.mainPane.getEditPane().copyText();
                }
            };
            this.editPasteAction = new GuiAction("Paste", this.loadIcon("Paste22.png"), "Paste", 80, this.makeShortcut(86)){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    VenusUI.this.mainPane.getEditPane().pasteText();
                }
            };
            this.editFindReplaceAction = new EditFindReplaceAction("Find/Replace", this.loadIcon("Find22.png"), "Find/Replace", 70, this.makeShortcut(70), this.mainUI);
            this.editSelectAllAction = new GuiAction("Select All", null, "Select All", 65, this.makeShortcut(65)){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    VenusUI.this.mainPane.getEditPane().selectAllText();
                }
            };
            this.runAssembleAction = new RunAssembleAction("Assemble", this.loadIcon("Assemble22.png"), "Assemble the current file and clear breakpoints", 65, KeyStroke.getKeyStroke(114, 0), this.mainUI);
            this.runGoAction = new RunGoAction("Go", this.loadIcon("Play22.png"), "Run the current program", 71, KeyStroke.getKeyStroke(116, 0), this.mainUI);
            this.runStepAction = new RunStepAction("Step", this.loadIcon("StepForward22.png"), "Run one step at a time", 84, KeyStroke.getKeyStroke(118, 0), this.mainUI);
            this.runBackstepAction = new RunBackstepAction("Backstep", this.loadIcon("StepBack22.png"), "Undo the last step", 66, KeyStroke.getKeyStroke(119, 0), this.mainUI);
            this.runPauseAction = new GuiAction("Pause", this.loadIcon("Pause22.png"), "Pause the currently running program", 80, KeyStroke.getKeyStroke(120, 0)){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Simulator.getInstance().pauseExecution();
                }
            };
            this.runStopAction = new GuiAction("Stop", this.loadIcon("Stop22.png"), "Stop the currently running program", 83, KeyStroke.getKeyStroke(122, 0)){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Simulator.getInstance().stopExecution();
                }
            };
            this.runResetAction = new RunResetAction("Reset", this.loadIcon("Reset22.png"), "Reset memory and registers", 82, KeyStroke.getKeyStroke(123, 0), this.mainUI);
            this.runClearBreakpointsAction = new RunClearBreakpointsAction("Clear all breakpoints", null, "Clears all execution breakpoints set since the last assemble.", 75, this.makeShortcut(75));
            this.runToggleBreakpointsAction = new GuiAction("Toggle all breakpoints", null, "Disable/enable all breakpoints without clearing (can also click Bkpt column header)", 84, this.makeShortcut(84)){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    VenusUI.this.mainPane.getExecutePane().getTextSegmentWindow().toggleBreakpoints();
                }
            };
            this.settingsLabelAction = new SettingsAction("Show Labels Window (symbol table)", "Toggle visibility of Labels window (symbol table) in the Execute tab", Settings.Bool.LABEL_WINDOW_VISIBILITY){

                @Override
                public void handler(boolean bl) {
                    VenusUI.this.mainPane.getExecutePane().setLabelWindowVisibility(bl);
                }
            };
            this.settingsPopupInputAction = new SettingsAction("Popup dialog for input syscalls (5,6,7,8,12)", "If set, use popup dialog for input syscalls (5,6,7,8,12) instead of cursor in Run I/O window", Settings.Bool.POPUP_SYSCALL_INPUT);
            this.settingsValueDisplayBaseAction = new SettingsAction("Values displayed in hexadecimal", "Toggle between hexadecimal and decimal display of memory/register values", Settings.Bool.DISPLAY_VALUES_IN_HEX){

                @Override
                public void handler(boolean bl) {
                    VenusUI.this.mainPane.getExecutePane().getValueDisplayBaseChooser().setSelected(bl);
                }
            };
            this.settingsAddressDisplayBaseAction = new SettingsAction("Addresses displayed in hexadecimal", "Toggle between hexadecimal and decimal display of memory addresses", Settings.Bool.DISPLAY_ADDRESSES_IN_HEX){

                @Override
                public void handler(boolean bl) {
                    VenusUI.this.mainPane.getExecutePane().getAddressDisplayBaseChooser().setSelected(bl);
                }
            };
            this.settingsExtendedAction = new SettingsAction("Permit extended (pseudo) instructions and formats", "If set, extended (pseudo) instructions are formats are permitted.", Settings.Bool.EXTENDED_ASSEMBLER_ENABLED);
            this.settingsAssembleOnOpenAction = new SettingsAction("Assemble file upon opening", "If set, a file will be automatically assembled as soon as it is opened.  File Open dialog will show most recently opened file.", Settings.Bool.ASSEMBLE_ON_OPEN);
            this.settingsAssembleAllAction = new SettingsAction("Assemble all files in directory", "If set, all files in current directory will be assembled when Assemble operation is selected.", Settings.Bool.ASSEMBLE_ALL);
            this.settingsAssembleOpenAction = new SettingsAction("Assemble all files currently open", "If set, all files currently open for editing will be assembled when Assemble operation is selected.", Settings.Bool.ASSEMBLE_OPEN);
            this.settingsWarningsAreErrorsAction = new SettingsAction("Assembler warnings are considered errors", "If set, assembler warnings will be interpreted as errors and prevent successful assembly.", Settings.Bool.WARNINGS_ARE_ERRORS);
            this.settingsStartAtMainAction = new SettingsAction("Initialize Program Counter to global 'main' if defined", "If set, assembler will initialize Program Counter to text address globally labeled 'main', if defined.", Settings.Bool.START_AT_MAIN);
            this.settingsProgramArgumentsAction = new SettingsAction("Program arguments provided to program", "If set, program arguments for the program can be entered in border of Text Segment window.", Settings.Bool.PROGRAM_ARGUMENTS){

                @Override
                public void handler(boolean bl) {
                    if (bl) {
                        VenusUI.this.mainPane.getExecutePane().getTextSegmentWindow().addProgramArgumentsPanel();
                    } else {
                        VenusUI.this.mainPane.getExecutePane().getTextSegmentWindow().removeProgramArgumentsPanel();
                    }
                }
            };
            this.settingsSelfModifyingCodeAction = new SettingsAction("Self-modifying code", "If set, the program can write and branch to both text and data segments.", Settings.Bool.SELF_MODIFYING_CODE_ENABLED);
            this.settingsEditorAction = new SettingsEditorAction("Editor...", null, "View and modify text editor settings.", null, null);
            this.settingsHighlightingAction = new SettingsHighlightingAction("Highlighting...", null, "View and modify Execute Tab highlighting colors", null, null);
            this.settingsExceptionHandlerAction = new SettingsExceptionHandlerAction("Exception Handler...", null, "If set, the specified exception handler file will be included in all Assemble operations.", null, null);
            this.settingsMemoryConfigurationAction = new SettingsMemoryConfigurationAction("Memory Configuration...", null, "View and modify memory segment base addresses for the simulated processor", null, null);
            this.helpHelpAction = new HelpHelpAction("Help", this.loadIcon("Help22.png"), "Help", 72, KeyStroke.getKeyStroke(112, 0), this.mainUI);
            this.helpAboutAction = new HelpAboutAction("About ...", null, "Information about Rars", null, null, this.mainUI);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Internal Error: images folder not found, or other null pointer exception while creating Action objects");
            nullPointerException.printStackTrace();
            System.exit(0);
        }
    }

    private JMenuBar setUpMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        this.file = new JMenu("File");
        this.file.setMnemonic(70);
        this.edit = new JMenu("Edit");
        this.edit.setMnemonic(69);
        this.run = new JMenu("Run");
        this.run.setMnemonic(82);
        this.settings = new JMenu("Settings");
        this.settings.setMnemonic(83);
        this.help = new JMenu("Help");
        this.help.setMnemonic(72);
        this.fileNew = new JMenuItem(this.fileNewAction);
        this.fileNew.setIcon(this.loadIcon("New16.png"));
        this.fileOpen = new JMenuItem(this.fileOpenAction);
        this.fileOpen.setIcon(this.loadIcon("Open16.png"));
        this.fileClose = new JMenuItem(this.fileCloseAction);
        this.fileClose.setIcon(this.loadIcon("MyBlank16.gif"));
        this.fileCloseAll = new JMenuItem(this.fileCloseAllAction);
        this.fileCloseAll.setIcon(this.loadIcon("MyBlank16.gif"));
        this.fileSave = new JMenuItem(this.fileSaveAction);
        this.fileSave.setIcon(this.loadIcon("Save16.png"));
        this.fileSaveAs = new JMenuItem(this.fileSaveAsAction);
        this.fileSaveAs.setIcon(this.loadIcon("SaveAs16.png"));
        this.fileSaveAll = new JMenuItem(this.fileSaveAllAction);
        this.fileSaveAll.setIcon(this.loadIcon("MyBlank16.gif"));
        this.fileDumpMemory = new JMenuItem(this.fileDumpMemoryAction);
        this.fileDumpMemory.setIcon(this.loadIcon("Dump16.png"));
        this.fileExit = new JMenuItem(this.fileExitAction);
        this.fileExit.setIcon(this.loadIcon("MyBlank16.gif"));
        this.file.add(this.fileNew);
        this.file.add(this.fileOpen);
        this.file.add(this.fileClose);
        this.file.add(this.fileCloseAll);
        this.file.addSeparator();
        this.file.add(this.fileSave);
        this.file.add(this.fileSaveAs);
        this.file.add(this.fileSaveAll);
        if (DumpFormatLoader.getDumpFormats().size() > 0) {
            this.file.add(this.fileDumpMemory);
        }
        this.file.addSeparator();
        this.file.add(this.fileExit);
        this.editUndo = new JMenuItem(this.editUndoAction);
        this.editUndo.setIcon(this.loadIcon("Undo16.png"));
        this.editRedo = new JMenuItem(this.editRedoAction);
        this.editRedo.setIcon(this.loadIcon("Redo16.png"));
        this.editCut = new JMenuItem(this.editCutAction);
        this.editCut.setIcon(this.loadIcon("Cut16.gif"));
        this.editCopy = new JMenuItem(this.editCopyAction);
        this.editCopy.setIcon(this.loadIcon("Copy16.png"));
        this.editPaste = new JMenuItem(this.editPasteAction);
        this.editPaste.setIcon(this.loadIcon("Paste16.png"));
        this.editFindReplace = new JMenuItem(this.editFindReplaceAction);
        this.editFindReplace.setIcon(this.loadIcon("Find16.png"));
        this.editSelectAll = new JMenuItem(this.editSelectAllAction);
        this.editSelectAll.setIcon(this.loadIcon("MyBlank16.gif"));
        this.edit.add(this.editUndo);
        this.edit.add(this.editRedo);
        this.edit.addSeparator();
        this.edit.add(this.editCut);
        this.edit.add(this.editCopy);
        this.edit.add(this.editPaste);
        this.edit.addSeparator();
        this.edit.add(this.editFindReplace);
        this.edit.add(this.editSelectAll);
        this.runAssemble = new JMenuItem(this.runAssembleAction);
        this.runAssemble.setIcon(this.loadIcon("Assemble16.png"));
        this.runGo = new JMenuItem(this.runGoAction);
        this.runGo.setIcon(this.loadIcon("Play16.png"));
        this.runStep = new JMenuItem(this.runStepAction);
        this.runStep.setIcon(this.loadIcon("StepForward16.png"));
        this.runBackstep = new JMenuItem(this.runBackstepAction);
        this.runBackstep.setIcon(this.loadIcon("StepBack16.png"));
        this.runReset = new JMenuItem(this.runResetAction);
        this.runReset.setIcon(this.loadIcon("Reset16.png"));
        this.runStop = new JMenuItem(this.runStopAction);
        this.runStop.setIcon(this.loadIcon("Stop16.png"));
        this.runPause = new JMenuItem(this.runPauseAction);
        this.runPause.setIcon(this.loadIcon("Pause16.png"));
        this.runClearBreakpoints = new JMenuItem(this.runClearBreakpointsAction);
        this.runClearBreakpoints.setIcon(this.loadIcon("MyBlank16.gif"));
        this.runToggleBreakpoints = new JMenuItem(this.runToggleBreakpointsAction);
        this.runToggleBreakpoints.setIcon(this.loadIcon("MyBlank16.gif"));
        this.run.add(this.runAssemble);
        this.run.add(this.runGo);
        this.run.add(this.runStep);
        this.run.add(this.runBackstep);
        this.run.add(this.runPause);
        this.run.add(this.runStop);
        this.run.add(this.runReset);
        this.run.addSeparator();
        this.run.add(this.runClearBreakpoints);
        this.run.add(this.runToggleBreakpoints);
        this.settingsLabel = new JCheckBoxMenuItem(this.settingsLabelAction);
        this.settingsLabel.setSelected(Globals.getSettings().getBooleanSetting(Settings.Bool.LABEL_WINDOW_VISIBILITY));
        this.settingsPopupInput = new JCheckBoxMenuItem(this.settingsPopupInputAction);
        this.settingsPopupInput.setSelected(Globals.getSettings().getBooleanSetting(Settings.Bool.POPUP_SYSCALL_INPUT));
        this.settingsValueDisplayBase = new JCheckBoxMenuItem(this.settingsValueDisplayBaseAction);
        this.settingsValueDisplayBase.setSelected(Globals.getSettings().getBooleanSetting(Settings.Bool.DISPLAY_VALUES_IN_HEX));
        this.mainPane.getExecutePane().getValueDisplayBaseChooser().setSettingsMenuItem(this.settingsValueDisplayBase);
        this.settingsAddressDisplayBase = new JCheckBoxMenuItem(this.settingsAddressDisplayBaseAction);
        this.settingsAddressDisplayBase.setSelected(Globals.getSettings().getBooleanSetting(Settings.Bool.DISPLAY_ADDRESSES_IN_HEX));
        this.mainPane.getExecutePane().getAddressDisplayBaseChooser().setSettingsMenuItem(this.settingsAddressDisplayBase);
        this.settingsExtended = new JCheckBoxMenuItem(this.settingsExtendedAction);
        this.settingsExtended.setSelected(Globals.getSettings().getBooleanSetting(Settings.Bool.EXTENDED_ASSEMBLER_ENABLED));
        this.settingsSelfModifyingCode = new JCheckBoxMenuItem(this.settingsSelfModifyingCodeAction);
        this.settingsSelfModifyingCode.setSelected(Globals.getSettings().getBooleanSetting(Settings.Bool.SELF_MODIFYING_CODE_ENABLED));
        this.settingsAssembleOnOpen = new JCheckBoxMenuItem(this.settingsAssembleOnOpenAction);
        this.settingsAssembleOnOpen.setSelected(Globals.getSettings().getBooleanSetting(Settings.Bool.ASSEMBLE_ON_OPEN));
        this.settingsAssembleAll = new JCheckBoxMenuItem(this.settingsAssembleAllAction);
        this.settingsAssembleAll.setSelected(Globals.getSettings().getBooleanSetting(Settings.Bool.ASSEMBLE_ALL));
        this.settingsAssembleOpen = new JCheckBoxMenuItem(this.settingsAssembleOpenAction);
        this.settingsAssembleOpen.setSelected(Globals.getSettings().getBooleanSetting(Settings.Bool.ASSEMBLE_OPEN));
        this.settingsWarningsAreErrors = new JCheckBoxMenuItem(this.settingsWarningsAreErrorsAction);
        this.settingsWarningsAreErrors.setSelected(Globals.getSettings().getBooleanSetting(Settings.Bool.WARNINGS_ARE_ERRORS));
        this.settingsStartAtMain = new JCheckBoxMenuItem(this.settingsStartAtMainAction);
        this.settingsStartAtMain.setSelected(Globals.getSettings().getBooleanSetting(Settings.Bool.START_AT_MAIN));
        this.settingsProgramArguments = new JCheckBoxMenuItem(this.settingsProgramArgumentsAction);
        this.settingsProgramArguments.setSelected(Globals.getSettings().getBooleanSetting(Settings.Bool.PROGRAM_ARGUMENTS));
        this.settingsEditor = new JMenuItem(this.settingsEditorAction);
        this.settingsHighlighting = new JMenuItem(this.settingsHighlightingAction);
        this.settingsExceptionHandler = new JMenuItem(this.settingsExceptionHandlerAction);
        this.settingsMemoryConfiguration = new JMenuItem(this.settingsMemoryConfigurationAction);
        this.settings.add(this.settingsLabel);
        this.settings.add(this.settingsProgramArguments);
        this.settings.add(this.settingsPopupInput);
        this.settings.add(this.settingsAddressDisplayBase);
        this.settings.add(this.settingsValueDisplayBase);
        this.settings.addSeparator();
        this.settings.add(this.settingsAssembleOnOpen);
        this.settings.add(this.settingsAssembleAll);
        this.settings.add(this.settingsAssembleOpen);
        this.settings.add(this.settingsWarningsAreErrors);
        this.settings.add(this.settingsStartAtMain);
        this.settings.addSeparator();
        this.settings.add(this.settingsExtended);
        this.settings.add(this.settingsSelfModifyingCode);
        this.settings.addSeparator();
        this.settings.add(this.settingsEditor);
        this.settings.add(this.settingsHighlighting);
        this.settings.add(this.settingsExceptionHandler);
        this.settings.add(this.settingsMemoryConfiguration);
        this.helpHelp = new JMenuItem(this.helpHelpAction);
        this.helpHelp.setIcon(this.loadIcon("Help16.png"));
        this.helpAbout = new JMenuItem(this.helpAboutAction);
        this.helpAbout.setIcon(this.loadIcon("MyBlank16.gif"));
        this.help.add(this.helpHelp);
        this.help.addSeparator();
        this.help.add(this.helpAbout);
        jMenuBar.add(this.file);
        jMenuBar.add(this.edit);
        jMenuBar.add(this.run);
        jMenuBar.add(this.settings);
        JMenu jMenu = ToolLoader.buildToolsMenu();
        if (jMenu != null) {
            jMenuBar.add(jMenu);
        }
        jMenuBar.add(this.help);
        return jMenuBar;
    }

    JToolBar setUpToolBar() {
        JToolBar jToolBar = new JToolBar();
        this.New = new JButton(this.fileNewAction);
        this.New.setText("");
        this.Open = new JButton(this.fileOpenAction);
        this.Open.setText("");
        this.Save = new JButton(this.fileSaveAction);
        this.Save.setText("");
        this.SaveAs = new JButton(this.fileSaveAsAction);
        this.SaveAs.setText("");
        this.DumpMemory = new JButton(this.fileDumpMemoryAction);
        this.DumpMemory.setText("");
        this.Undo = new JButton(this.editUndoAction);
        this.Undo.setText("");
        this.Redo = new JButton(this.editRedoAction);
        this.Redo.setText("");
        this.Cut = new JButton(this.editCutAction);
        this.Cut.setText("");
        this.Copy = new JButton(this.editCopyAction);
        this.Copy.setText("");
        this.Paste = new JButton(this.editPasteAction);
        this.Paste.setText("");
        this.FindReplace = new JButton(this.editFindReplaceAction);
        this.FindReplace.setText("");
        this.SelectAll = new JButton(this.editSelectAllAction);
        this.SelectAll.setText("");
        this.Run = new JButton(this.runGoAction);
        this.Run.setText("");
        this.Assemble = new JButton(this.runAssembleAction);
        this.Assemble.setText("");
        this.Step = new JButton(this.runStepAction);
        this.Step.setText("");
        this.Backstep = new JButton(this.runBackstepAction);
        this.Backstep.setText("");
        this.Reset = new JButton(this.runResetAction);
        this.Reset.setText("");
        this.Stop = new JButton(this.runStopAction);
        this.Stop.setText("");
        this.Pause = new JButton(this.runPauseAction);
        this.Pause.setText("");
        this.Help = new JButton(this.helpHelpAction);
        this.Help.setText("");
        jToolBar.add(this.New);
        jToolBar.add(this.Open);
        jToolBar.add(this.Save);
        jToolBar.add(this.SaveAs);
        if (DumpFormatLoader.getDumpFormats().size() > 0) {
            jToolBar.add(this.DumpMemory);
        }
        jToolBar.add(new JToolBar.Separator());
        jToolBar.add(this.Undo);
        jToolBar.add(this.Redo);
        jToolBar.add(this.Cut);
        jToolBar.add(this.Copy);
        jToolBar.add(this.Paste);
        jToolBar.add(this.FindReplace);
        jToolBar.add(new JToolBar.Separator());
        jToolBar.add(this.Assemble);
        jToolBar.add(this.Run);
        jToolBar.add(this.Step);
        jToolBar.add(this.Backstep);
        jToolBar.add(this.Pause);
        jToolBar.add(this.Stop);
        jToolBar.add(this.Reset);
        jToolBar.add(new JToolBar.Separator());
        jToolBar.add(this.Help);
        jToolBar.add(new JToolBar.Separator());
        return jToolBar;
    }

    public void setMenuState(int n) {
        menuState = n;
        switch (n) {
            case 0: {
                this.setMenuStateInitial();
                break;
            }
            case 1: {
                this.setMenuStateEditingNew();
                break;
            }
            case 2: {
                this.setMenuStateEditingNew();
                break;
            }
            case 3: {
                this.setMenuStateNotEdited();
                break;
            }
            case 4: {
                this.setMenuStateEditing();
                break;
            }
            case 5: {
                this.setMenuStateRunnable();
                break;
            }
            case 6: {
                this.setMenuStateRunning();
                break;
            }
            case 7: {
                this.setMenuStateTerminated();
                break;
            }
            case 8: {
                break;
            }
            default: {
                System.out.println("Invalid File Status: " + n);
            }
        }
    }

    private void setMenuStateInitial() {
        this.fileNewAction.setEnabled(true);
        this.fileOpenAction.setEnabled(true);
        this.fileCloseAction.setEnabled(false);
        this.fileCloseAllAction.setEnabled(false);
        this.fileSaveAction.setEnabled(false);
        this.fileSaveAsAction.setEnabled(false);
        this.fileSaveAllAction.setEnabled(false);
        this.fileDumpMemoryAction.setEnabled(false);
        this.fileExitAction.setEnabled(true);
        this.editUndoAction.setEnabled(false);
        this.editRedoAction.setEnabled(false);
        this.editCutAction.setEnabled(false);
        this.editCopyAction.setEnabled(false);
        this.editPasteAction.setEnabled(false);
        this.editFindReplaceAction.setEnabled(false);
        this.editSelectAllAction.setEnabled(false);
        this.settingsMemoryConfigurationAction.setEnabled(true);
        this.runAssembleAction.setEnabled(false);
        this.runGoAction.setEnabled(false);
        this.runStepAction.setEnabled(false);
        this.runBackstepAction.setEnabled(false);
        this.runResetAction.setEnabled(false);
        this.runStopAction.setEnabled(false);
        this.runPauseAction.setEnabled(false);
        this.runClearBreakpointsAction.setEnabled(false);
        this.runToggleBreakpointsAction.setEnabled(false);
        this.helpHelpAction.setEnabled(true);
        this.helpAboutAction.setEnabled(true);
        this.updateUndoAndRedoState();
    }

    void setMenuStateNotEdited() {
        this.fileNewAction.setEnabled(true);
        this.fileOpenAction.setEnabled(true);
        this.fileCloseAction.setEnabled(true);
        this.fileCloseAllAction.setEnabled(true);
        this.fileSaveAction.setEnabled(true);
        this.fileSaveAsAction.setEnabled(true);
        this.fileSaveAllAction.setEnabled(true);
        this.fileDumpMemoryAction.setEnabled(false);
        this.fileExitAction.setEnabled(true);
        this.editCutAction.setEnabled(true);
        this.editCopyAction.setEnabled(true);
        this.editPasteAction.setEnabled(true);
        this.editFindReplaceAction.setEnabled(true);
        this.editSelectAllAction.setEnabled(true);
        this.settingsMemoryConfigurationAction.setEnabled(true);
        this.runAssembleAction.setEnabled(true);
        if (!Globals.getSettings().getBooleanSetting(Settings.Bool.ASSEMBLE_ALL)) {
            this.runGoAction.setEnabled(false);
            this.runStepAction.setEnabled(false);
            this.runBackstepAction.setEnabled(false);
            this.runResetAction.setEnabled(false);
            this.runStopAction.setEnabled(false);
            this.runPauseAction.setEnabled(false);
            this.runClearBreakpointsAction.setEnabled(false);
            this.runToggleBreakpointsAction.setEnabled(false);
        }
        this.helpHelpAction.setEnabled(true);
        this.helpAboutAction.setEnabled(true);
        this.updateUndoAndRedoState();
    }

    void setMenuStateEditing() {
        this.fileNewAction.setEnabled(true);
        this.fileOpenAction.setEnabled(true);
        this.fileCloseAction.setEnabled(true);
        this.fileCloseAllAction.setEnabled(true);
        this.fileSaveAction.setEnabled(true);
        this.fileSaveAsAction.setEnabled(true);
        this.fileSaveAllAction.setEnabled(true);
        this.fileDumpMemoryAction.setEnabled(false);
        this.fileExitAction.setEnabled(true);
        this.editCutAction.setEnabled(true);
        this.editCopyAction.setEnabled(true);
        this.editPasteAction.setEnabled(true);
        this.editFindReplaceAction.setEnabled(true);
        this.editSelectAllAction.setEnabled(true);
        this.settingsMemoryConfigurationAction.setEnabled(true);
        this.runAssembleAction.setEnabled(true);
        this.runGoAction.setEnabled(false);
        this.runStepAction.setEnabled(false);
        this.runBackstepAction.setEnabled(false);
        this.runResetAction.setEnabled(false);
        this.runStopAction.setEnabled(false);
        this.runPauseAction.setEnabled(false);
        this.runClearBreakpointsAction.setEnabled(false);
        this.runToggleBreakpointsAction.setEnabled(false);
        this.helpHelpAction.setEnabled(true);
        this.helpAboutAction.setEnabled(true);
        this.updateUndoAndRedoState();
    }

    void setMenuStateEditingNew() {
        this.fileNewAction.setEnabled(true);
        this.fileOpenAction.setEnabled(true);
        this.fileCloseAction.setEnabled(true);
        this.fileCloseAllAction.setEnabled(true);
        this.fileSaveAction.setEnabled(true);
        this.fileSaveAsAction.setEnabled(true);
        this.fileSaveAllAction.setEnabled(true);
        this.fileDumpMemoryAction.setEnabled(false);
        this.fileExitAction.setEnabled(true);
        this.editCutAction.setEnabled(true);
        this.editCopyAction.setEnabled(true);
        this.editPasteAction.setEnabled(true);
        this.editFindReplaceAction.setEnabled(true);
        this.editSelectAllAction.setEnabled(true);
        this.settingsMemoryConfigurationAction.setEnabled(true);
        this.runAssembleAction.setEnabled(false);
        this.runGoAction.setEnabled(false);
        this.runStepAction.setEnabled(false);
        this.runBackstepAction.setEnabled(false);
        this.runResetAction.setEnabled(false);
        this.runStopAction.setEnabled(false);
        this.runPauseAction.setEnabled(false);
        this.runClearBreakpointsAction.setEnabled(false);
        this.runToggleBreakpointsAction.setEnabled(false);
        this.helpHelpAction.setEnabled(true);
        this.helpAboutAction.setEnabled(true);
        this.updateUndoAndRedoState();
    }

    void setMenuStateRunnable() {
        this.fileNewAction.setEnabled(true);
        this.fileOpenAction.setEnabled(true);
        this.fileCloseAction.setEnabled(true);
        this.fileCloseAllAction.setEnabled(true);
        this.fileSaveAction.setEnabled(true);
        this.fileSaveAsAction.setEnabled(true);
        this.fileSaveAllAction.setEnabled(true);
        this.fileDumpMemoryAction.setEnabled(true);
        this.fileExitAction.setEnabled(true);
        this.editCutAction.setEnabled(true);
        this.editCopyAction.setEnabled(true);
        this.editPasteAction.setEnabled(true);
        this.editFindReplaceAction.setEnabled(true);
        this.editSelectAllAction.setEnabled(true);
        this.settingsMemoryConfigurationAction.setEnabled(true);
        this.runAssembleAction.setEnabled(true);
        this.runGoAction.setEnabled(true);
        this.runStepAction.setEnabled(true);
        this.runBackstepAction.setEnabled(Globals.getSettings().getBackSteppingEnabled() && !Globals.program.getBackStepper().empty());
        this.runResetAction.setEnabled(true);
        this.runStopAction.setEnabled(false);
        this.runPauseAction.setEnabled(false);
        this.runToggleBreakpointsAction.setEnabled(true);
        this.helpHelpAction.setEnabled(true);
        this.helpAboutAction.setEnabled(true);
        this.updateUndoAndRedoState();
    }

    void setMenuStateRunning() {
        this.fileNewAction.setEnabled(false);
        this.fileOpenAction.setEnabled(false);
        this.fileCloseAction.setEnabled(false);
        this.fileCloseAllAction.setEnabled(false);
        this.fileSaveAction.setEnabled(false);
        this.fileSaveAsAction.setEnabled(false);
        this.fileSaveAllAction.setEnabled(false);
        this.fileDumpMemoryAction.setEnabled(false);
        this.fileExitAction.setEnabled(false);
        this.editCutAction.setEnabled(false);
        this.editCopyAction.setEnabled(false);
        this.editPasteAction.setEnabled(false);
        this.editFindReplaceAction.setEnabled(false);
        this.editSelectAllAction.setEnabled(false);
        this.settingsMemoryConfigurationAction.setEnabled(false);
        this.runAssembleAction.setEnabled(false);
        this.runGoAction.setEnabled(false);
        this.runStepAction.setEnabled(false);
        this.runBackstepAction.setEnabled(false);
        this.runResetAction.setEnabled(false);
        this.runStopAction.setEnabled(true);
        this.runPauseAction.setEnabled(true);
        this.runToggleBreakpointsAction.setEnabled(false);
        this.helpHelpAction.setEnabled(true);
        this.helpAboutAction.setEnabled(true);
        this.editUndoAction.setEnabled(false);
        this.editRedoAction.setEnabled(false);
    }

    void setMenuStateTerminated() {
        this.fileNewAction.setEnabled(true);
        this.fileOpenAction.setEnabled(true);
        this.fileCloseAction.setEnabled(true);
        this.fileCloseAllAction.setEnabled(true);
        this.fileSaveAction.setEnabled(true);
        this.fileSaveAsAction.setEnabled(true);
        this.fileSaveAllAction.setEnabled(true);
        this.fileDumpMemoryAction.setEnabled(true);
        this.fileExitAction.setEnabled(true);
        this.editCutAction.setEnabled(true);
        this.editCopyAction.setEnabled(true);
        this.editPasteAction.setEnabled(true);
        this.editFindReplaceAction.setEnabled(true);
        this.editSelectAllAction.setEnabled(true);
        this.settingsMemoryConfigurationAction.setEnabled(true);
        this.runAssembleAction.setEnabled(true);
        this.runGoAction.setEnabled(false);
        this.runStepAction.setEnabled(false);
        this.runBackstepAction.setEnabled(Globals.getSettings().getBackSteppingEnabled() && !Globals.program.getBackStepper().empty());
        this.runResetAction.setEnabled(true);
        this.runStopAction.setEnabled(false);
        this.runPauseAction.setEnabled(false);
        this.runToggleBreakpointsAction.setEnabled(true);
        this.helpHelpAction.setEnabled(true);
        this.helpAboutAction.setEnabled(true);
        this.updateUndoAndRedoState();
    }

    public static int getMenuState() {
        return menuState;
    }

    public void setReset(boolean bl) {
        this.reset = bl;
    }

    public void setStarted(boolean bl) {
        this.started = bl;
    }

    public boolean getReset() {
        return this.reset;
    }

    public boolean getStarted() {
        return this.started;
    }

    public Editor getEditor() {
        return this.editor;
    }

    public MainPane getMainPane() {
        return this.mainPane;
    }

    public MessagesPane getMessagesPane() {
        return this.messagesPane;
    }

    public RegistersPane getRegistersPane() {
        return this.registersPane;
    }

    public JCheckBoxMenuItem getValueDisplayBaseMenuItem() {
        return this.settingsValueDisplayBase;
    }

    public JCheckBoxMenuItem getAddressDisplayBaseMenuItem() {
        return this.settingsAddressDisplayBase;
    }

    public Action getRunAssembleAction() {
        return this.runAssembleAction;
    }

    public void haveMenuRequestFocus() {
        this.menu.requestFocus();
    }

    public void dispatchEventToMenu(KeyEvent keyEvent) {
        this.menu.dispatchEvent(keyEvent);
    }

    public void updateUndoAndRedoState() {
        EditPane editPane = this.getMainPane().getEditPane();
        this.editUndoAction.setEnabled(editPane != null && editPane.getUndoManager().canUndo());
        this.editRedoAction.setEnabled(editPane != null && editPane.getUndoManager().canRedo());
    }

    private ImageIcon loadIcon(String string) {
        return new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/" + string)));
    }

    private KeyStroke makeShortcut(int n) {
        return KeyStroke.getKeyStroke(n, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }
}

