/*
 * Decompiled with CFR 0.152.
 */
package rars.venus.editors.jeditsyntax.tokenmarker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.text.Segment;
import rars.Globals;
import rars.Settings;
import rars.assembler.Directives;
import rars.assembler.TokenTypes;
import rars.riscv.BasicInstruction;
import rars.riscv.Instruction;
import rars.riscv.hardware.FloatingPointRegisterFile;
import rars.riscv.hardware.Register;
import rars.riscv.hardware.RegisterFile;
import rars.venus.editors.jeditsyntax.KeywordMap;
import rars.venus.editors.jeditsyntax.PopupHelpItem;
import rars.venus.editors.jeditsyntax.tokenmarker.Token;
import rars.venus.editors.jeditsyntax.tokenmarker.TokenMarker;

public class RISCVTokenMarker
extends TokenMarker {
    private static KeywordMap cKeywords;
    private static String[] tokenLabels;
    private static String[] tokenExamples;
    private KeywordMap keywords;
    private int lastOffset;
    private int lastKeyword;

    public RISCVTokenMarker() {
        this(RISCVTokenMarker.getKeywords());
    }

    public RISCVTokenMarker(KeywordMap keywordMap) {
        this.keywords = keywordMap;
    }

    public static String[] getRISCVTokenLabels() {
        if (tokenLabels == null) {
            tokenLabels = new String[12];
            RISCVTokenMarker.tokenLabels[1] = "Comment";
            RISCVTokenMarker.tokenLabels[3] = "String literal";
            RISCVTokenMarker.tokenLabels[4] = "Character literal";
            RISCVTokenMarker.tokenLabels[5] = "Label";
            RISCVTokenMarker.tokenLabels[6] = "Instruction";
            RISCVTokenMarker.tokenLabels[7] = "Assembler directive";
            RISCVTokenMarker.tokenLabels[8] = "Register";
            RISCVTokenMarker.tokenLabels[10] = "In-progress, invalid";
            RISCVTokenMarker.tokenLabels[11] = "Macro parameter";
        }
        return tokenLabels;
    }

    public static String[] getRISCVTokenExamples() {
        if (tokenExamples == null) {
            tokenExamples = new String[12];
            RISCVTokenMarker.tokenExamples[1] = "# Load";
            RISCVTokenMarker.tokenExamples[3] = "\"First\"";
            RISCVTokenMarker.tokenExamples[4] = "'\\n'";
            RISCVTokenMarker.tokenExamples[5] = "main:";
            RISCVTokenMarker.tokenExamples[6] = "lui";
            RISCVTokenMarker.tokenExamples[7] = ".text";
            RISCVTokenMarker.tokenExamples[8] = "zero";
            RISCVTokenMarker.tokenExamples[10] = "\"Regi";
            RISCVTokenMarker.tokenExamples[11] = "%arg";
        }
        return tokenExamples;
    }

    @Override
    public byte markTokensImpl(byte by, Segment segment, int n) {
        int n2;
        char[] cArray = segment.array;
        this.lastOffset = n2 = segment.offset;
        this.lastKeyword = n2;
        int n3 = segment.count + n2;
        boolean bl = false;
        block17: for (int i = n2; i < n3; ++i) {
            int n4 = i + 1;
            char c = cArray[i];
            if (c == '\\') {
                bl = !bl;
                continue;
            }
            switch (by) {
                case 0: {
                    switch (c) {
                        case '\"': {
                            this.doKeyword(segment, i, c);
                            if (bl) {
                                bl = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, by);
                            by = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '\'': {
                            this.doKeyword(segment, i, c);
                            if (bl) {
                                bl = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, by);
                            by = (byte)4;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case ':': {
                            bl = false;
                            boolean bl2 = false;
                            try {
                                bl2 = TokenTypes.isValidIdentifier(new String(cArray, this.lastOffset, n4 - this.lastOffset - 1).trim());
                            }
                            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                                bl2 = false;
                            }
                            if (!bl2) continue block17;
                            this.addToken(n4 - this.lastOffset, (byte)5);
                            this.lastOffset = this.lastKeyword = n4;
                            break;
                        }
                        case '#': {
                            bl = false;
                            this.doKeyword(segment, i, c);
                            if (n3 - i < 1) continue block17;
                            this.addToken(i - this.lastOffset, by);
                            this.addToken(n3 - i, (byte)1);
                            this.lastOffset = this.lastKeyword = n3;
                            break block17;
                        }
                        default: {
                            bl = false;
                            if (Character.isLetterOrDigit(c) || c == '_' || c == '.' || c == '$' || c == '%') continue block17;
                            this.doKeyword(segment, i, c);
                            break;
                        }
                    }
                    continue block17;
                }
                case 3: {
                    if (bl) {
                        bl = false;
                        continue block17;
                    }
                    if (c != '\"') continue block17;
                    this.addToken(n4 - this.lastOffset, by);
                    by = 0;
                    this.lastOffset = this.lastKeyword = n4;
                    continue block17;
                }
                case 4: {
                    if (bl) {
                        bl = false;
                        continue block17;
                    }
                    if (c != '\'') continue block17;
                    this.addToken(n4 - this.lastOffset, (byte)3);
                    by = 0;
                    this.lastOffset = this.lastKeyword = n4;
                    continue block17;
                }
                default: {
                    throw new InternalError("Invalid state: " + by);
                }
            }
        }
        if (by == 0) {
            this.doKeyword(segment, n3, '\u0000');
        }
        switch (by) {
            case 3: 
            case 4: {
                this.addToken(n3 - this.lastOffset, (byte)10);
                by = 0;
                break;
            }
            case 7: {
                this.addToken(n3 - this.lastOffset, by);
                if (!bl) {
                    by = 0;
                }
            }
            default: {
                this.addToken(n3 - this.lastOffset, by);
            }
        }
        return by;
    }

    @Override
    public ArrayList<PopupHelpItem> getTokenExactMatchHelp(Token token, String string) {
        Object object;
        ArrayList<PopupHelpItem> arrayList = null;
        if (token != null && token.id == 6 && ((ArrayList)(object = Globals.instructionSet.matchOperator(string))).size() > 0) {
            int n = 0;
            arrayList = new ArrayList();
            Iterator iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                Instruction instruction = (Instruction)iterator.next();
                if (!Globals.getSettings().getBooleanSetting(Settings.Bool.EXTENDED_ASSEMBLER_ENABLED) && !(instruction instanceof BasicInstruction)) continue;
                arrayList.add(new PopupHelpItem(string, instruction.getExampleFormat(), instruction.getDescription()));
                ++n;
            }
            if (n == 0) {
                arrayList.add(new PopupHelpItem(string, string, "(is not a basic instruction)"));
            }
        }
        if (token != null && token.id == 7 && (object = Directives.matchDirective(string)) != null) {
            arrayList = new ArrayList<PopupHelpItem>();
            arrayList.add(new PopupHelpItem(string, ((Directives)object).getName(), ((Directives)object).getDescription()));
        }
        return arrayList;
    }

    @Override
    public ArrayList<PopupHelpItem> getTokenPrefixMatchHelp(String string, Token token, Token token2, String string2) {
        if (token == null || token.id == 127) {
            return null;
        }
        if (token2 != null && token2.id == 1) {
            return null;
        }
        Token token3 = token;
        String string3 = null;
        int n = -1;
        int n2 = 0;
        boolean bl = false;
        while (token3.id != 127) {
            if (token3.id == 6 || token3.id == 7) {
                if (string3 != null) {
                    bl = true;
                    break;
                }
                string3 = string.substring(n2, n2 + token3.length);
                n = token3.id;
            }
            n2 += token3.length;
            token3 = token3.next;
        }
        if (token2 != null && token2.id == 6) {
            if (bl) {
                return n == 6 ? this.getTextFromInstructionMatch(string3, true) : this.getTextFromDirectiveMatch(string3, true);
            }
            return this.getTextFromInstructionMatch(string2, false);
        }
        if (token2 != null && token2.id == 7) {
            if (bl) {
                return n == 6 ? this.getTextFromInstructionMatch(string3, true) : this.getTextFromDirectiveMatch(string3, true);
            }
            return this.getTextFromDirectiveMatch(string2, false);
        }
        if (string3 != null) {
            if (n == 6) {
                return this.getTextFromInstructionMatch(string3, true);
            }
            if (n == 7) {
                return this.getTextFromDirectiveMatch(string3, true);
            }
        }
        if (token2 != null && token2.id == 0) {
            String string4 = string2.trim();
            if (string3 == null && string4.length() == 0) {
                return null;
            }
            if (string3 == null && string4.length() > 0) {
                if (string4.charAt(0) == '.') {
                    return this.getTextFromDirectiveMatch(string4, false);
                }
                if (string4.length() >= Globals.getSettings().getEditorPopupPrefixLength()) {
                    return this.getTextFromInstructionMatch(string4, false);
                }
            }
        }
        return null;
    }

    private ArrayList<PopupHelpItem> getTextFromDirectiveMatch(String string, boolean bl) {
        ArrayList<PopupHelpItem> arrayList = null;
        ArrayList<Directives> arrayList2 = null;
        if (bl) {
            Directives directives = Directives.matchDirective(string);
            if (directives != null) {
                arrayList2 = new ArrayList();
                arrayList2.add(directives);
            }
        } else {
            arrayList2 = Directives.prefixMatchDirectives(string);
        }
        if (arrayList2 != null) {
            arrayList = new ArrayList<PopupHelpItem>();
            for (Directives directives : arrayList2) {
                arrayList.add(new PopupHelpItem(string, directives.getName(), directives.getDescription(), bl));
            }
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ArrayList<PopupHelpItem> getTextFromInstructionMatch(String string, boolean bl) {
        String string2;
        ArrayList<PopupHelpItem> arrayList = new ArrayList<PopupHelpItem>();
        ArrayList<Instruction> arrayList2 = bl ? Globals.instructionSet.matchOperator(string) : Globals.instructionSet.prefixMatchOperator(string);
        if (arrayList2 == null) {
            return null;
        }
        int n = 0;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Instruction instruction : arrayList2) {
            if (!Globals.getSettings().getBooleanSetting(Settings.Bool.EXTENDED_ASSEMBLER_ENABLED) && !(instruction instanceof BasicInstruction)) continue;
            if (bl) {
                arrayList.add(new PopupHelpItem(string, instruction.getExampleFormat(), instruction.getDescription(), bl));
            } else {
                string2 = instruction.getExampleFormat().split(" ")[0];
                if (!hashMap.containsKey(string2)) {
                    treeSet.add(string2);
                    hashMap.put(string2, instruction.getDescription());
                }
            }
            ++n;
        }
        if (n == 0) {
            if (!bl) return null;
            arrayList.add(new PopupHelpItem(string, string, "(not a basic instruction)", bl));
            return arrayList;
        } else {
            if (bl) return arrayList;
            for (String string3 : treeSet) {
                string2 = (String)hashMap.get(string3);
                arrayList.add(new PopupHelpItem(string, string3, string2, bl));
            }
        }
        return arrayList;
    }

    private static KeywordMap getKeywords() {
        if (cKeywords == null) {
            cKeywords = new KeywordMap(false);
            for (Instruction object : Globals.instructionSet.getInstructionList()) {
                cKeywords.add(object.getName(), (byte)6);
            }
            for (Directives directives : Directives.getDirectiveList()) {
                cKeywords.add(directives.getName(), (byte)7);
            }
            for (Iterator<Object> iterator : RegisterFile.getRegisters()) {
                cKeywords.add(((Register)((Object)iterator)).getName(), (byte)8);
                cKeywords.add("x" + ((Register)((Object)iterator)).getNumber(), (byte)8);
            }
            for (Iterator<Object> iterator : FloatingPointRegisterFile.getRegisters()) {
                cKeywords.add(((Register)((Object)iterator)).getName(), (byte)8);
                cKeywords.add("f" + ((Register)((Object)iterator)).getNumber(), (byte)8);
            }
        }
        return cKeywords;
    }

    private void doKeyword(Segment segment, int n, char c) {
        int n2 = n + 1;
        int n3 = n - this.lastKeyword;
        byte by = this.keywords.lookup(segment, this.lastKeyword, n3);
        if (by != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(n3, by);
            this.lastOffset = n;
        }
        this.lastKeyword = n2;
    }
}

