/*
 * Decompiled with CFR 0.152.
 */
package rars.venus.registers;

import java.util.Arrays;
import rars.riscv.hardware.Register;
import rars.riscv.hardware.RegisterFile;
import rars.venus.NumberDisplayBaseChooser;
import rars.venus.registers.RegisterBlockWindow;

public class RegistersWindow
extends RegisterBlockWindow {
    private static final String[] regToolTips = new String[]{"constant 0", "return address (used by function call)", "stack pointer", "pointer to global area", "pointer to thread local data (not given a value)", "temporary (not preserved across call)", "temporary (not preserved across call)", "temporary (not preserved across call)", "saved temporary (preserved across call)", "saved temporary (preserved across call)", "argument 1 / return 1", "argument 2 / return 2", "argument 3", "argument 4", "argument 5", "argument 6", "argument 7", "argument 8", "saved temporary (preserved across call)", "saved temporary (preserved across call)", "saved temporary (preserved across call)", "saved temporary (preserved across call)", "saved temporary (preserved across call)", "saved temporary (preserved across call)", "saved temporary (preserved across call)", "saved temporary (preserved across call)", "saved temporary (preserved across call)", "saved temporary (preserved across call)", "temporary (not preserved across call)", "temporary (not preserved across call)", "temporary (not preserved across call)", "temporary (not preserved across call)", "program counter"};

    public RegistersWindow() {
        super(RegistersWindow.getRegisters(), regToolTips, "Current 32 bit value");
    }

    private static Register[] getRegisters() {
        Register[] registerArray = RegisterFile.getRegisters();
        Register[] registerArray2 = Arrays.copyOf(registerArray, registerArray.length + 1);
        registerArray2[registerArray.length] = RegisterFile.getProgramCounterRegister();
        return registerArray2;
    }

    @Override
    protected String formatRegister(Register register, int n) {
        return NumberDisplayBaseChooser.formatNumber((int)register.getValue(), n);
    }

    @Override
    protected void beginObserving() {
        RegisterFile.addRegistersObserver(this);
    }

    @Override
    protected void endObserving() {
        RegisterFile.deleteRegistersObserver(this);
    }

    @Override
    protected void resetRegisters() {
        RegisterFile.resetRegisters();
    }
}

