/*
 * Decompiled with CFR 0.152.
 */
package rars.venus.run;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import rars.Globals;
import rars.Settings;
import rars.SimulationException;
import rars.riscv.hardware.RegisterFile;
import rars.simulator.ProgramArgumentList;
import rars.simulator.Simulator;
import rars.simulator.SimulatorNotice;
import rars.util.SystemIO;
import rars.venus.ExecutePane;
import rars.venus.FileStatus;
import rars.venus.GuiAction;
import rars.venus.VenusUI;

public class RunGoAction
extends GuiAction {
    public static int defaultMaxSteps;
    public static int maxSteps;
    private String name;
    private ExecutePane executePane;
    private VenusUI mainUI;

    public RunGoAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke, VenusUI venusUI) {
        super(string, icon, string2, n, keyStroke);
        this.mainUI = venusUI;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.name = this.getValue("Name").toString();
        this.executePane = this.mainUI.getMainPane().getExecutePane();
        if (FileStatus.isAssembled()) {
            if (!this.mainUI.getStarted()) {
                this.processProgramArgumentsIfAny();
            }
            if (this.mainUI.getReset() || this.mainUI.getStarted()) {
                this.mainUI.setStarted(true);
                this.mainUI.getMessagesPane().postMessage(this.name + ": running " + FileStatus.getFile().getName() + "\n\n");
                this.mainUI.getMessagesPane().selectRunMessageTab();
                this.executePane.getTextSegmentWindow().setCodeHighlighting(false);
                this.executePane.getTextSegmentWindow().unhighlightAllSteps();
                this.mainUI.setMenuState(6);
                Observer observer = new Observer(){

                    @Override
                    public void update(Observable observable, Object object) {
                        SimulatorNotice simulatorNotice = (SimulatorNotice)object;
                        if (simulatorNotice.getAction() != 1) {
                            return;
                        }
                        Simulator.Reason reason = simulatorNotice.getReason();
                        if (reason == Simulator.Reason.PAUSE || reason == Simulator.Reason.BREAKPOINT) {
                            EventQueue.invokeLater(() -> RunGoAction.this.paused(simulatorNotice.getDone(), reason, simulatorNotice.getException()));
                        } else {
                            EventQueue.invokeLater(() -> RunGoAction.this.stopped(simulatorNotice.getException(), reason));
                        }
                        observable.deleteObserver(this);
                    }
                };
                Simulator.getInstance().addObserver(observer);
                int[] nArray = this.executePane.getTextSegmentWindow().getSortedBreakPointsArray();
                Globals.program.startSimulation(maxSteps, nArray);
            } else {
                JOptionPane.showMessageDialog(this.mainUI, "reset " + this.mainUI.getReset() + " started " + this.mainUI.getStarted());
            }
        } else {
            JOptionPane.showMessageDialog(this.mainUI, "The program must be assembled before it can be run.");
        }
    }

    public void paused(boolean bl, Simulator.Reason reason, SimulationException simulationException) {
        if (bl) {
            this.stopped(simulationException, Simulator.Reason.NORMAL_TERMINATION);
            return;
        }
        if (reason == Simulator.Reason.BREAKPOINT) {
            this.mainUI.getMessagesPane().postMessage(this.name + ": execution paused at breakpoint: " + FileStatus.getFile().getName() + "\n\n");
        } else {
            this.mainUI.getMessagesPane().postMessage(this.name + ": execution paused by user: " + FileStatus.getFile().getName() + "\n\n");
        }
        this.mainUI.getMessagesPane().selectMessageTab();
        this.executePane.getTextSegmentWindow().setCodeHighlighting(true);
        this.executePane.getTextSegmentWindow().highlightStepAtPC();
        this.executePane.getRegistersWindow().updateRegisters();
        this.executePane.getFloatingPointWindow().updateRegisters();
        this.executePane.getControlAndStatusWindow().updateRegisters();
        this.executePane.getDataSegmentWindow().updateValues();
        FileStatus.set(5);
        this.mainUI.setReset(false);
    }

    public void stopped(SimulationException simulationException, Simulator.Reason reason) {
        this.executePane.getRegistersWindow().updateRegisters();
        this.executePane.getFloatingPointWindow().updateRegisters();
        this.executePane.getControlAndStatusWindow().updateRegisters();
        this.executePane.getDataSegmentWindow().updateValues();
        FileStatus.set(7);
        SystemIO.resetFiles();
        if (simulationException != null) {
            this.mainUI.getRegistersPane().setSelectedComponent(this.executePane.getControlAndStatusWindow());
            this.executePane.getTextSegmentWindow().setCodeHighlighting(true);
            this.executePane.getTextSegmentWindow().unhighlightAllSteps();
            this.executePane.getTextSegmentWindow().highlightStepAtAddress(RegisterFile.getProgramCounter() - 4);
        }
        switch (reason) {
            case NORMAL_TERMINATION: {
                this.mainUI.getMessagesPane().postMessage("\n" + this.name + ": execution completed successfully.\n\n");
                this.mainUI.getMessagesPane().postRunMessage("\n-- program is finished running --\n\n");
                this.mainUI.getMessagesPane().selectRunMessageTab();
                break;
            }
            case CLIFF_TERMINATION: {
                this.mainUI.getMessagesPane().postMessage("\n" + this.name + ": execution terminated by null instruction.\n\n");
                this.mainUI.getMessagesPane().postRunMessage("\n-- program is finished running (dropped off bottom) --\n\n");
                this.mainUI.getMessagesPane().selectRunMessageTab();
                break;
            }
            case EXCEPTION: {
                this.mainUI.getMessagesPane().postMessage(simulationException.error().generateReport());
                this.mainUI.getMessagesPane().postMessage("\n" + this.name + ": execution terminated with errors.\n\n");
                break;
            }
            case STOP: {
                this.mainUI.getMessagesPane().postMessage("\n" + this.name + ": execution terminated by user.\n\n");
                this.mainUI.getMessagesPane().selectMessageTab();
                break;
            }
            case MAX_STEPS: {
                this.mainUI.getMessagesPane().postMessage("\n" + this.name + ": execution step limit of " + maxSteps + " exceeded.\n\n");
                this.mainUI.getMessagesPane().selectMessageTab();
                break;
            }
        }
        RunGoAction.resetMaxSteps();
        this.mainUI.setReset(false);
    }

    public static void resetMaxSteps() {
        maxSteps = defaultMaxSteps;
    }

    private void processProgramArgumentsIfAny() {
        String string = this.executePane.getTextSegmentWindow().getProgramArguments();
        if (string == null || string.length() == 0 || !Globals.getSettings().getBooleanSetting(Settings.Bool.PROGRAM_ARGUMENTS)) {
            return;
        }
        new ProgramArgumentList(string).storeProgramArguments();
    }

    static {
        maxSteps = defaultMaxSteps = -1;
    }
}

