/*
 * Decompiled with CFR 0.152.
 */
package rars.venus.settings;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import rars.Globals;
import rars.Settings;
import rars.venus.ExecutePane;
import rars.venus.GuiAction;
import rars.venus.MonoRightCellRenderer;
import rars.venus.settings.ColorSelectButton;
import rars.venus.util.AbstractFontSettingDialog;

public class SettingsHighlightingAction
extends GuiAction {
    JDialog highlightDialog;
    private static final int[] backgroundSettingPositions = new int[]{4, 6, 8, 10, 0, 2};
    private static final int[] foregroundSettingPositions = new int[]{5, 7, 9, 11, 1, 3};
    private static final int[] fontSettingPositions = new int[]{3, 4, 5, 6, 1, 2};
    JButton[] backgroundButtons;
    JButton[] foregroundButtons;
    JButton[] fontButtons;
    JCheckBox[] defaultCheckBoxes;
    JLabel[] samples;
    Color[] currentNondefaultBackground;
    Color[] currentNondefaultForeground;
    Color[] initialSettingsBackground;
    Color[] initialSettingsForeground;
    Font[] initialFont;
    Font[] currentFont;
    Font[] currentNondefaultFont;
    JButton dataHighlightButton;
    JButton registerHighlightButton;
    boolean currentDataHighlightSetting;
    boolean initialDataHighlightSetting;
    boolean currentRegisterHighlightSetting;
    boolean initialRegisterHighlightSetting;
    private static final int gridVGap = 2;
    private static final int gridHGap = 2;
    private static final String SAMPLE_TOOL_TIP_TEXT = "Preview based on background and text color settings";
    private static final String BACKGROUND_TOOL_TIP_TEXT = "Click, to select background color";
    private static final String FOREGROUND_TOOL_TIP_TEXT = "Click, to select text color";
    private static final String FONT_TOOL_TIP_TEXT = "Click, to select text font";
    private static final String DEFAULT_TOOL_TIP_TEXT = "Check, to select default color (disables color select buttons)";
    public static final String CLOSE_TOOL_TIP_TEXT = "Apply current settings and close dialog";
    public static final String APPLY_TOOL_TIP_TEXT = "Apply current settings now and leave dialog open";
    public static final String RESET_TOOL_TIP_TEXT = "Reset to initial settings without applying";
    public static final String CANCEL_TOOL_TIP_TEXT = "Close dialog without applying current settings";
    private static final String DATA_HIGHLIGHT_ENABLE_TOOL_TIP_TEXT = "Click, to enable or disable highlighting in Data Segment window";
    private static final String REGISTER_HIGHLIGHT_ENABLE_TOOL_TIP_TEXT = "Click, to enable or disable highlighting in Register windows";
    private static final String fontButtonText = "font";

    public SettingsHighlightingAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke) {
        super(string, icon, string2, n, keyStroke);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.highlightDialog = new JDialog(Globals.getGui(), "Runtime Table Highlighting Colors and Fonts", true);
        this.highlightDialog.setContentPane(this.buildDialogPanel());
        this.highlightDialog.setDefaultCloseOperation(0);
        this.highlightDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SettingsHighlightingAction.this.closeDialog();
            }
        });
        this.highlightDialog.pack();
        this.highlightDialog.setLocationRelativeTo(Globals.getGui());
        this.highlightDialog.setVisible(true);
    }

    private JPanel buildDialogPanel() {
        int n;
        JPanel jPanel = new JPanel(new BorderLayout(20, 20));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel jPanel2 = new JPanel(new GridLayout(backgroundSettingPositions.length, 4, 2, 2));
        this.currentNondefaultBackground = new Color[backgroundSettingPositions.length];
        this.currentNondefaultForeground = new Color[backgroundSettingPositions.length];
        this.initialSettingsBackground = new Color[backgroundSettingPositions.length];
        this.initialSettingsForeground = new Color[backgroundSettingPositions.length];
        this.initialFont = new Font[backgroundSettingPositions.length];
        this.currentFont = new Font[backgroundSettingPositions.length];
        this.currentNondefaultFont = new Font[backgroundSettingPositions.length];
        this.backgroundButtons = new JButton[backgroundSettingPositions.length];
        this.foregroundButtons = new JButton[backgroundSettingPositions.length];
        this.fontButtons = new JButton[backgroundSettingPositions.length];
        this.defaultCheckBoxes = new JCheckBox[backgroundSettingPositions.length];
        this.samples = new JLabel[backgroundSettingPositions.length];
        for (n = 0; n < backgroundSettingPositions.length; ++n) {
            this.backgroundButtons[n] = new ColorSelectButton();
            this.foregroundButtons[n] = new ColorSelectButton();
            this.fontButtons[n] = new JButton(fontButtonText);
            this.defaultCheckBoxes[n] = new JCheckBox();
            this.samples[n] = new JLabel(" preview ");
            this.backgroundButtons[n].addActionListener(new BackgroundChanger(n));
            this.foregroundButtons[n].addActionListener(new ForegroundChanger(n));
            this.fontButtons[n].addActionListener(new FontChanger(n));
            this.defaultCheckBoxes[n].addItemListener(new DefaultChanger(n));
            this.samples[n].setToolTipText(SAMPLE_TOOL_TIP_TEXT);
            this.backgroundButtons[n].setToolTipText(BACKGROUND_TOOL_TIP_TEXT);
            this.foregroundButtons[n].setToolTipText(FOREGROUND_TOOL_TIP_TEXT);
            this.fontButtons[n].setToolTipText(FONT_TOOL_TIP_TEXT);
            this.defaultCheckBoxes[n].setToolTipText(DEFAULT_TOOL_TIP_TEXT);
        }
        this.initializeButtonColors();
        for (n = 0; n < backgroundSettingPositions.length; ++n) {
            jPanel2.add(this.backgroundButtons[n]);
            jPanel2.add(this.foregroundButtons[n]);
            jPanel2.add(this.fontButtons[n]);
            jPanel2.add(this.defaultCheckBoxes[n]);
        }
        JPanel jPanel3 = new JPanel(new GridLayout(backgroundSettingPositions.length, 1, 2, 2));
        jPanel3.add(new JLabel("Text Segment highlighting", 4));
        jPanel3.add(new JLabel("Text Segment Delay Slot highlighting", 4));
        jPanel3.add(new JLabel("Data Segment highlighting *", 4));
        jPanel3.add(new JLabel("Register highlighting *", 4));
        jPanel3.add(new JLabel("Even row normal", 4));
        jPanel3.add(new JLabel("Odd row normal", 4));
        JPanel jPanel4 = new JPanel(new GridLayout(backgroundSettingPositions.length, 1, 2, 2));
        for (int i = 0; i < backgroundSettingPositions.length; ++i) {
            jPanel4.add(this.samples[i]);
        }
        JPanel jPanel5 = new JPanel(new FlowLayout(1));
        JCheckBox jCheckBox = new JCheckBox(){

            @Override
            protected void processMouseEvent(MouseEvent mouseEvent) {
            }

            @Override
            protected void processKeyEvent(KeyEvent keyEvent) {
            }
        };
        jCheckBox.setSelected(true);
        jPanel5.add(jCheckBox);
        jPanel5.add(new JLabel("= use default colors (disables color selection buttons)"));
        int n2 = 10;
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(jPanel3);
        box.add(Box.createHorizontalStrut(n2));
        box.add(Box.createHorizontalGlue());
        box.add(Box.createHorizontalStrut(n2));
        box.add(jPanel4);
        box.add(Box.createHorizontalStrut(n2));
        box.add(Box.createHorizontalGlue());
        box.add(Box.createHorizontalStrut(n2));
        box.add(jPanel2);
        jPanel.add((Component)box, "East");
        jPanel.add((Component)jPanel5, "North");
        JPanel jPanel6 = new JPanel(new GridLayout(2, 1));
        this.dataHighlightButton = new JButton();
        this.dataHighlightButton.setText(this.getHighlightControlText(this.currentDataHighlightSetting));
        this.dataHighlightButton.setToolTipText(DATA_HIGHLIGHT_ENABLE_TOOL_TIP_TEXT);
        this.dataHighlightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsHighlightingAction.this.currentDataHighlightSetting = !SettingsHighlightingAction.this.currentDataHighlightSetting;
                SettingsHighlightingAction.this.dataHighlightButton.setText(SettingsHighlightingAction.this.getHighlightControlText(SettingsHighlightingAction.this.currentDataHighlightSetting));
            }
        });
        this.registerHighlightButton = new JButton();
        this.registerHighlightButton.setText(this.getHighlightControlText(this.currentRegisterHighlightSetting));
        this.registerHighlightButton.setToolTipText(REGISTER_HIGHLIGHT_ENABLE_TOOL_TIP_TEXT);
        this.registerHighlightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsHighlightingAction.this.currentRegisterHighlightSetting = !SettingsHighlightingAction.this.currentRegisterHighlightSetting;
                SettingsHighlightingAction.this.registerHighlightButton.setText(SettingsHighlightingAction.this.getHighlightControlText(SettingsHighlightingAction.this.currentRegisterHighlightSetting));
            }
        });
        JPanel jPanel7 = new JPanel(new FlowLayout(0));
        JPanel jPanel8 = new JPanel(new FlowLayout(0));
        jPanel7.add(new JLabel("* Data Segment highlighting is"));
        jPanel7.add(this.dataHighlightButton);
        jPanel8.add(new JLabel("* Register highlighting is"));
        jPanel8.add(this.registerHighlightButton);
        jPanel6.setBorder(new LineBorder(Color.BLACK));
        jPanel6.add(jPanel7);
        jPanel6.add(jPanel8);
        Box box2 = Box.createHorizontalBox();
        JButton jButton = new JButton("Apply and Close");
        jButton.setToolTipText(CLOSE_TOOL_TIP_TEXT);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsHighlightingAction.this.setHighlightingSettings();
                SettingsHighlightingAction.this.closeDialog();
            }
        });
        JButton jButton2 = new JButton("Apply");
        jButton2.setToolTipText(APPLY_TOOL_TIP_TEXT);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsHighlightingAction.this.setHighlightingSettings();
            }
        });
        JButton jButton3 = new JButton("Reset");
        jButton3.setToolTipText(RESET_TOOL_TIP_TEXT);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsHighlightingAction.this.resetButtonColors();
            }
        });
        JButton jButton4 = new JButton("Cancel");
        jButton4.setToolTipText(CANCEL_TOOL_TIP_TEXT);
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsHighlightingAction.this.closeDialog();
            }
        });
        box2.add(Box.createHorizontalGlue());
        box2.add(jButton);
        box2.add(Box.createHorizontalGlue());
        box2.add(jButton2);
        box2.add(Box.createHorizontalGlue());
        box2.add(jButton4);
        box2.add(Box.createHorizontalGlue());
        box2.add(jButton3);
        box2.add(Box.createHorizontalGlue());
        JPanel jPanel9 = new JPanel(new GridLayout(2, 1));
        jPanel9.add(jPanel6);
        jPanel9.add(box2);
        jPanel.add((Component)jPanel9, "South");
        return jPanel;
    }

    private String getHighlightControlText(boolean bl) {
        return bl ? "enabled" : "disabled";
    }

    private void initializeButtonColors() {
        Settings settings = Globals.getSettings();
        LineBorder lineBorder = new LineBorder(Color.BLACK);
        for (int i = 0; i < backgroundSettingPositions.length; ++i) {
            Color color = settings.getColorSettingByPosition(backgroundSettingPositions[i]);
            Color color2 = settings.getColorSettingByPosition(foregroundSettingPositions[i]);
            Font font = settings.getFontByPosition(fontSettingPositions[i]);
            this.backgroundButtons[i].setBackground(color);
            this.foregroundButtons[i].setBackground(color2);
            this.fontButtons[i].setFont(MonoRightCellRenderer.MONOSPACED_PLAIN_12POINT);
            this.fontButtons[i].setMargin(new Insets(4, 4, 4, 4));
            this.initialFont[i] = this.currentFont[i] = font;
            this.currentNondefaultBackground[i] = color;
            this.currentNondefaultForeground[i] = color2;
            this.currentNondefaultFont[i] = font;
            this.initialSettingsBackground[i] = color;
            this.initialSettingsForeground[i] = color2;
            this.samples[i].setOpaque(true);
            this.samples[i].setBorder(lineBorder);
            this.samples[i].setBackground(color);
            this.samples[i].setForeground(color2);
            this.samples[i].setFont(font);
            boolean bl = color.equals(settings.getDefaultColorSettingByPosition(backgroundSettingPositions[i])) && color2.equals(settings.getDefaultColorSettingByPosition(foregroundSettingPositions[i])) && font.equals(settings.getDefaultFontByPosition(fontSettingPositions[i]));
            this.defaultCheckBoxes[i].setSelected(bl);
            this.backgroundButtons[i].setEnabled(!bl);
            this.foregroundButtons[i].setEnabled(!bl);
            this.fontButtons[i].setEnabled(!bl);
        }
        this.currentDataHighlightSetting = this.initialDataHighlightSetting = settings.getBooleanSetting(Settings.Bool.DATA_SEGMENT_HIGHLIGHTING);
        this.currentRegisterHighlightSetting = this.initialRegisterHighlightSetting = settings.getBooleanSetting(Settings.Bool.REGISTERS_HIGHLIGHTING);
    }

    private void setHighlightingSettings() {
        Settings settings = Globals.getSettings();
        for (int i = 0; i < backgroundSettingPositions.length; ++i) {
            settings.setColorSettingByPosition(backgroundSettingPositions[i], this.backgroundButtons[i].getBackground());
            settings.setColorSettingByPosition(foregroundSettingPositions[i], this.foregroundButtons[i].getBackground());
            settings.setFontByPosition(fontSettingPositions[i], this.samples[i].getFont());
        }
        settings.setBooleanSetting(Settings.Bool.DATA_SEGMENT_HIGHLIGHTING, this.currentDataHighlightSetting);
        settings.setBooleanSetting(Settings.Bool.REGISTERS_HIGHLIGHTING, this.currentRegisterHighlightSetting);
        ExecutePane executePane = Globals.getGui().getMainPane().getExecutePane();
        executePane.getRegistersWindow().refresh();
        executePane.getControlAndStatusWindow().refresh();
        executePane.getFloatingPointWindow().refresh();
        if (executePane.getTextSegmentWindow().getContentPane().getComponentCount() > 0) {
            executePane.getDataSegmentWindow().updateValues();
            executePane.getTextSegmentWindow().highlightStepAtPC();
        }
    }

    private void resetButtonColors() {
        Settings settings = Globals.getSettings();
        this.dataHighlightButton.setText(this.getHighlightControlText(this.initialDataHighlightSetting));
        this.registerHighlightButton.setText(this.getHighlightControlText(this.initialRegisterHighlightSetting));
        for (int i = 0; i < backgroundSettingPositions.length; ++i) {
            Color color = this.initialSettingsBackground[i];
            Color color2 = this.initialSettingsForeground[i];
            Font font = this.initialFont[i];
            this.backgroundButtons[i].setBackground(color);
            this.foregroundButtons[i].setBackground(color2);
            this.samples[i].setBackground(color);
            this.samples[i].setForeground(color2);
            this.samples[i].setFont(font);
            boolean bl = color.equals(settings.getDefaultColorSettingByPosition(backgroundSettingPositions[i])) && color2.equals(settings.getDefaultColorSettingByPosition(foregroundSettingPositions[i])) && font.equals(settings.getDefaultFontByPosition(fontSettingPositions[i]));
            this.defaultCheckBoxes[i].setSelected(bl);
            this.backgroundButtons[i].setEnabled(!bl);
            this.foregroundButtons[i].setEnabled(!bl);
            this.fontButtons[i].setEnabled(!bl);
        }
    }

    private void closeDialog() {
        this.highlightDialog.setVisible(false);
        this.highlightDialog.dispose();
    }

    private class FontSettingDialog
    extends AbstractFontSettingDialog {
        private boolean resultOK;

        public FontSettingDialog(Frame frame, String string, Font font) {
            super(frame, string, true, font);
        }

        private Font showDialog() {
            this.resultOK = true;
            this.setVisible(true);
            return this.resultOK ? this.getFont() : null;
        }

        @Override
        protected void closeDialog() {
            this.setVisible(false);
        }

        private void performOK() {
            this.resultOK = true;
        }

        private void performCancel() {
            this.resultOK = false;
        }

        @Override
        protected Component buildControlPanel() {
            Box box = Box.createHorizontalBox();
            JButton jButton = new JButton("OK");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FontSettingDialog.this.performOK();
                    FontSettingDialog.this.closeDialog();
                }
            });
            JButton jButton2 = new JButton("Cancel");
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FontSettingDialog.this.performCancel();
                    FontSettingDialog.this.closeDialog();
                }
            });
            JButton jButton3 = new JButton("Reset");
            jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FontSettingDialog.this.reset();
                }
            });
            box.add(Box.createHorizontalGlue());
            box.add(jButton);
            box.add(Box.createHorizontalGlue());
            box.add(jButton2);
            box.add(Box.createHorizontalGlue());
            box.add(jButton3);
            box.add(Box.createHorizontalGlue());
            return box;
        }

        @Override
        protected void apply(Font font) {
        }
    }

    private class DefaultChanger
    implements ItemListener {
        private int position;

        public DefaultChanger(int n) {
            this.position = n;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Color color = null;
            Color color2 = null;
            Font font = null;
            if (itemEvent.getStateChange() == 1) {
                SettingsHighlightingAction.this.backgroundButtons[this.position].setEnabled(false);
                SettingsHighlightingAction.this.foregroundButtons[this.position].setEnabled(false);
                SettingsHighlightingAction.this.fontButtons[this.position].setEnabled(false);
                color = Globals.getSettings().getDefaultColorSettingByPosition(backgroundSettingPositions[this.position]);
                color2 = Globals.getSettings().getDefaultColorSettingByPosition(foregroundSettingPositions[this.position]);
                font = Globals.getSettings().getDefaultFontByPosition(fontSettingPositions[this.position]);
                SettingsHighlightingAction.this.currentNondefaultBackground[this.position] = SettingsHighlightingAction.this.backgroundButtons[this.position].getBackground();
                SettingsHighlightingAction.this.currentNondefaultForeground[this.position] = SettingsHighlightingAction.this.foregroundButtons[this.position].getBackground();
                SettingsHighlightingAction.this.currentNondefaultFont[this.position] = SettingsHighlightingAction.this.samples[this.position].getFont();
            } else {
                SettingsHighlightingAction.this.backgroundButtons[this.position].setEnabled(true);
                SettingsHighlightingAction.this.foregroundButtons[this.position].setEnabled(true);
                SettingsHighlightingAction.this.fontButtons[this.position].setEnabled(true);
                color = SettingsHighlightingAction.this.currentNondefaultBackground[this.position];
                color2 = SettingsHighlightingAction.this.currentNondefaultForeground[this.position];
                font = SettingsHighlightingAction.this.currentNondefaultFont[this.position];
            }
            SettingsHighlightingAction.this.backgroundButtons[this.position].setBackground(color);
            SettingsHighlightingAction.this.foregroundButtons[this.position].setBackground(color2);
            SettingsHighlightingAction.this.samples[this.position].setBackground(color);
            SettingsHighlightingAction.this.samples[this.position].setForeground(color2);
            SettingsHighlightingAction.this.samples[this.position].setFont(font);
        }
    }

    private class FontChanger
    implements ActionListener {
        private int position;

        public FontChanger(int n) {
            this.position = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            FontSettingDialog fontSettingDialog = new FontSettingDialog(null, "Select Text Font", SettingsHighlightingAction.this.samples[this.position].getFont());
            Font font = fontSettingDialog.showDialog();
            if (font != null) {
                SettingsHighlightingAction.this.samples[this.position].setFont(font);
            }
        }
    }

    private class ForegroundChanger
    implements ActionListener {
        private int position;

        public ForegroundChanger(int n) {
            this.position = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            Color color = JColorChooser.showDialog(null, "Set Text Color", jButton.getBackground());
            if (color != null) {
                jButton.setBackground(color);
                SettingsHighlightingAction.this.currentNondefaultForeground[this.position] = color;
                SettingsHighlightingAction.this.samples[this.position].setForeground(color);
            }
        }
    }

    private class BackgroundChanger
    implements ActionListener {
        private int position;

        public BackgroundChanger(int n) {
            this.position = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            Color color = JColorChooser.showDialog(null, "Set Background Color", jButton.getBackground());
            if (color != null) {
                jButton.setBackground(color);
                SettingsHighlightingAction.this.currentNondefaultBackground[this.position] = color;
                SettingsHighlightingAction.this.samples[this.position].setBackground(color);
            }
        }
    }
}

