/*
 * Decompiled with CFR 0.152.
 */
package jsoftfloat.internal;

import java.math.BigInteger;
import jsoftfloat.Environment;
import jsoftfloat.Flags;
import jsoftfloat.RoundingMode;

public class ExactFloat
implements Comparable<ExactFloat> {
    public final boolean sign;
    public final int exponent;
    public final BigInteger significand;

    public ExactFloat(boolean bl, int n, BigInteger bigInteger) {
        this.sign = bl;
        this.exponent = n;
        this.significand = bigInteger;
    }

    public ExactFloat(BigInteger bigInteger) {
        if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
            this.sign = true;
            bigInteger = bigInteger.negate();
        } else {
            this.sign = false;
        }
        this.exponent = 0;
        this.significand = bigInteger;
    }

    public ExactFloat add(ExactFloat exactFloat) {
        int n = this.exponent - exactFloat.exponent;
        int n2 = Math.min(this.exponent, exactFloat.exponent);
        if (this.sign != exactFloat.sign) {
            boolean bl;
            int n3 = this.abs().compareTo(exactFloat.abs());
            if (n3 == 0) {
                return new ExactFloat(false, 0, BigInteger.ZERO);
            }
            boolean bl2 = bl = n3 > 0 ? this.sign : exactFloat.sign;
            if (n < 0) {
                return new ExactFloat(bl, n2, this.significand.subtract(exactFloat.significand.shiftLeft(-n)).abs());
            }
            return new ExactFloat(bl, n2, this.significand.shiftLeft(n).subtract(exactFloat.significand).abs());
        }
        if (n < 0) {
            return new ExactFloat(this.sign, n2, this.significand.add(exactFloat.significand.shiftLeft(-n)).abs());
        }
        return new ExactFloat(this.sign, n2, this.significand.shiftLeft(n).add(exactFloat.significand).abs());
    }

    public ExactFloat multiply(ExactFloat exactFloat) {
        if (this.isZero() || exactFloat.isZero()) {
            return new ExactFloat(this.sign != exactFloat.sign, 0, BigInteger.ZERO);
        }
        return new ExactFloat(this.sign != exactFloat.sign, this.exponent + exactFloat.exponent, this.significand.multiply(exactFloat.significand));
    }

    public ExactFloat divide(ExactFloat exactFloat, int n) {
        assert (n > 0) : "Accuracy must be a positive number";
        assert (!exactFloat.isZero()) : "Divide by Zero is not valid";
        ExactFloat exactFloat2 = this.normalize();
        ExactFloat exactFloat3 = exactFloat.normalize();
        BigInteger bigInteger = exactFloat2.significand;
        BigInteger bigInteger2 = exactFloat3.significand;
        BigInteger bigInteger3 = BigInteger.ZERO;
        int n2 = bigInteger2.bitLength() - bigInteger.bitLength();
        if (bigInteger.bitLength() > bigInteger2.bitLength()) {
            bigInteger2 = bigInteger2.shiftLeft(bigInteger.bitLength() - bigInteger2.bitLength());
        } else {
            bigInteger = bigInteger.shiftLeft(bigInteger2.bitLength() - bigInteger.bitLength());
        }
        int n3 = 0;
        while (bigInteger3.bitLength() < n) {
            bigInteger3 = bigInteger3.shiftLeft(1);
            if (bigInteger.compareTo(bigInteger2) >= 0) {
                bigInteger = bigInteger.subtract(bigInteger2);
                bigInteger3 = bigInteger3.add(BigInteger.ONE);
            }
            ++n3;
            if (!(bigInteger = bigInteger.shiftLeft(1)).equals(BigInteger.ZERO)) continue;
        }
        if (bigInteger3.bitLength() >= n) {
            bigInteger3 = bigInteger3.shiftLeft(1);
            bigInteger3 = bigInteger3.add(BigInteger.ONE);
            ++n3;
        }
        return new ExactFloat(exactFloat2.sign != exactFloat3.sign, exactFloat2.exponent - exactFloat3.exponent - n3 - n2 + 1, bigInteger3);
    }

    public ExactFloat squareRoot(int n) {
        ExactFloat exactFloat;
        assert (!this.sign) : "Square root of a negative number is not real";
        ExactFloat exactFloat2 = this.normalize();
        int n2 = (exactFloat2.exponent + exactFloat2.significand.bitLength()) / 2 + 1;
        while (true) {
            int n3;
            if ((n3 = exactFloat2.compareTo((exactFloat = new ExactFloat(false, n2, BigInteger.ONE)).multiply(exactFloat))) == 0) {
                return exactFloat;
            }
            if (n3 > 0) break;
            --n2;
        }
        exactFloat = new ExactFloat(false, n2, BigInteger.ONE);
        ExactFloat exactFloat3 = new ExactFloat(false, n2 + 1, BigInteger.ONE);
        for (int i = 0; i < n; ++i) {
            ExactFloat exactFloat4 = exactFloat.add(exactFloat3).shiftRight(1);
            int n4 = exactFloat2.compareTo(exactFloat4.multiply(exactFloat4));
            if (n4 == 0) {
                return exactFloat4;
            }
            if (n4 > 0) {
                exactFloat = exactFloat4;
                continue;
            }
            if (n4 < 0) {
                exactFloat3 = exactFloat4;
                continue;
            }
            assert (false) : "Cannot get here";
        }
        ExactFloat exactFloat5 = exactFloat.add(exactFloat3).shiftRight(1);
        int n5 = exactFloat2.compareTo(exactFloat5.multiply(exactFloat5));
        if (n5 == 0) {
            return exactFloat5;
        }
        if (n5 > 0) {
            return exactFloat5.add(exactFloat3).shiftRight(1);
        }
        if (n5 < 0) {
            return exactFloat5.add(exactFloat).shiftRight(1);
        }
        assert (false) : "Cannot get here";
        return null;
    }

    public ExactFloat shiftRight(int n) {
        return new ExactFloat(this.sign, this.exponent - n, this.significand);
    }

    public ExactFloat normalize() {
        if (this.isZero()) {
            return new ExactFloat(this.sign, 0, BigInteger.ZERO);
        }
        return new ExactFloat(this.sign, this.exponent + this.significand.getLowestSetBit(), this.significand.shiftRight(this.significand.getLowestSetBit()));
    }

    public ExactFloat roundToIntegral(Environment environment) {
        if (this.isZero()) {
            return this;
        }
        ExactFloat exactFloat = this.normalize();
        if (exactFloat.exponent >= 0) {
            return exactFloat;
        }
        int n = -exactFloat.exponent;
        BigInteger bigInteger = exactFloat.significand.shiftRight(n).shiftLeft(n);
        BigInteger bigInteger2 = exactFloat.significand.subtract(bigInteger);
        ExactFloat exactFloat2 = new ExactFloat(exactFloat.sign, exactFloat.exponent, bigInteger).normalize();
        ExactFloat exactFloat3 = exactFloat2.add(new ExactFloat(exactFloat.sign, 0, BigInteger.valueOf(1L)));
        if (environment.mode == RoundingMode.zero) {
            return exactFloat2;
        }
        if (environment.mode == RoundingMode.max || environment.mode == RoundingMode.min) {
            if (environment.mode == RoundingMode.max == exactFloat.sign) {
                return exactFloat2;
            }
            return exactFloat3;
        }
        if (bigInteger2.equals(BigInteger.ONE.shiftLeft(n - 1))) {
            if (environment.mode == RoundingMode.away || exactFloat2.significand.testBit(0)) {
                return exactFloat3;
            }
            return exactFloat2;
        }
        if (bigInteger2.compareTo(BigInteger.ONE.shiftLeft(n - 1)) > 0) {
            return exactFloat3;
        }
        return exactFloat2;
    }

    public BigInteger toIntegral(Environment environment) {
        if (this.isZero()) {
            return BigInteger.ZERO;
        }
        ExactFloat exactFloat = this.roundToIntegral(environment).normalize();
        if (exactFloat.compareTo(this) != 0) {
            environment.flags.add(Flags.inexact);
        }
        assert (exactFloat.exponent >= 0) : "There can't be any fractions at this point";
        return exactFloat.significand.shiftLeft(exactFloat.exponent).multiply(BigInteger.valueOf(this.sign ? -1L : 1L));
    }

    @Override
    public int compareTo(ExactFloat exactFloat) {
        if (this.isZero()) {
            if (exactFloat.isZero()) {
                return 0;
            }
            return exactFloat.sign ? 1 : -1;
        }
        if (this.sign != exactFloat.sign) {
            return this.sign ? -1 : 1;
        }
        if (this.exponent - exactFloat.exponent + this.significand.bitLength() - exactFloat.significand.bitLength() > 0) {
            return this.sign ? -1 : 1;
        }
        if (this.exponent - exactFloat.exponent + this.significand.bitLength() - exactFloat.significand.bitLength() < 0) {
            return this.sign ? 1 : -1;
        }
        if (this.exponent < exactFloat.exponent) {
            return this.significand.compareTo(exactFloat.significand.shiftLeft(exactFloat.exponent - this.exponent)) * (this.sign ? -1 : 1);
        }
        return this.significand.shiftLeft(this.exponent - exactFloat.exponent).compareTo(exactFloat.significand) * (this.sign ? -1 : 1);
    }

    public ExactFloat abs() {
        return new ExactFloat(false, this.exponent, this.significand);
    }

    public ExactFloat negate() {
        return new ExactFloat(!this.sign, this.exponent, this.significand);
    }

    public boolean isZero() {
        return this.significand.equals(BigInteger.ZERO);
    }
}

