/*
 * Decompiled with CFR 0.152.
 */
package rars;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.locks.ReentrantLock;
import rars.RISCVprogram;
import rars.Settings;
import rars.assembler.SymbolTable;
import rars.riscv.InstructionSet;
import rars.riscv.SyscallNumberOverride;
import rars.riscv.hardware.Memory;
import rars.util.PropertiesFile;
import rars.venus.VenusUI;

public class Globals {
    private static String configPropertiesFile = "Config";
    private static String syscallPropertiesFile = "Syscall";
    public static InstructionSet instructionSet;
    public static RISCVprogram program;
    public static SymbolTable symbolTable;
    public static Memory memory;
    public static final ReentrantLock memoryAndRegistersLock;
    public static boolean debug;
    static Settings settings;
    public static String userInputAlert;
    public static final String imagesPath = "/images/";
    public static final String helpPath = "/help/";
    private static boolean initialized;
    static VenusUI gui;
    public static final String version = "1.5";
    public static final ArrayList<String> fileExtensions;
    public static final int maximumMessageCharacters;
    public static final int maximumErrorMessages;
    public static final int maximumBacksteps;
    public static final String copyrightYears;
    public static final String copyrightHolders;
    public static final String ASCII_NON_PRINT;
    public static final String[] ASCII_TABLE;
    public static int exitCode;
    public static boolean runSpeedPanelExists;

    private static String getCopyrightYears() {
        return "2003-2019";
    }

    private static String getCopyrightHolders() {
        return "Pete Sanderson and Kenneth Vollmar";
    }

    public static void setGui(VenusUI venusUI) {
        gui = venusUI;
    }

    public static VenusUI getGui() {
        return gui;
    }

    public static Settings getSettings() {
        return settings;
    }

    public static void initialize(boolean bl) {
        if (!initialized) {
            memory = Memory.getInstance();
            symbolTable = new SymbolTable("global");
            settings = new Settings(bl);
            instructionSet = new InstructionSet();
            instructionSet.populate();
            initialized = true;
            debug = false;
            memory.clear();
        }
    }

    private static int getMessageLimit() {
        return Globals.getIntegerProperty(configPropertiesFile, "MessageLimit", 1000000);
    }

    private static int getErrorLimit() {
        return Globals.getIntegerProperty(configPropertiesFile, "ErrorLimit", 200);
    }

    private static int getBackstepLimit() {
        return Globals.getIntegerProperty(configPropertiesFile, "BackstepLimit", 1000);
    }

    public static String getAsciiNonPrint() {
        String string = Globals.getPropertyEntry(configPropertiesFile, "AsciiNonPrint");
        return string == null ? "." : (string.equals("space") ? " " : string);
    }

    public static String[] getAsciiStrings() {
        String string = Globals.getPropertyEntry(configPropertiesFile, "AsciiTable");
        String string2 = Globals.getAsciiNonPrint();
        if (string == null) {
            String[] stringArray = new String[127];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = i == 0 ? "\u0000" : (i == 10 ? "\n" : (i < 32 ? string2 : " " + (char)i));
            }
            return stringArray;
        }
        String[] stringArray = string.split(" +");
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("null")) {
                stringArray[i] = string2;
            }
            if (stringArray[i].equals("space")) {
                stringArray[i] = " ";
            }
            if (stringArray[i].length() <= n) continue;
            n = stringArray[i].length();
        }
        String string3 = "        ";
        ++n;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = string3.substring(0, n - stringArray[i].length()) + stringArray[i];
        }
        return stringArray;
    }

    private static int getIntegerProperty(String string, String string2, int n) {
        int n2 = n;
        Properties properties = PropertiesFile.loadPropertiesFromFile(string);
        try {
            n2 = Integer.parseInt(properties.getProperty(string2, Integer.toString(n)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n2;
    }

    private static ArrayList<String> getFileExtensions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = Globals.getPropertyEntry(configPropertiesFile, "Extensions");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        return arrayList;
    }

    public static String getPropertyEntry(String string, String string2) {
        return PropertiesFile.loadPropertiesFromFile(string).getProperty(string2);
    }

    public ArrayList<SyscallNumberOverride> getSyscallOverrides() {
        ArrayList<SyscallNumberOverride> arrayList = new ArrayList<SyscallNumberOverride>();
        Properties properties = PropertiesFile.loadPropertiesFromFile(syscallPropertiesFile);
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            arrayList.add(new SyscallNumberOverride(string, properties.getProperty(string)));
        }
        return arrayList;
    }

    static {
        memoryAndRegistersLock = new ReentrantLock();
        debug = false;
        userInputAlert = "**** user input : ";
        initialized = false;
        gui = null;
        fileExtensions = Globals.getFileExtensions();
        maximumMessageCharacters = Globals.getMessageLimit();
        maximumErrorMessages = Globals.getErrorLimit();
        maximumBacksteps = Globals.getBackstepLimit();
        copyrightYears = Globals.getCopyrightYears();
        copyrightHolders = Globals.getCopyrightHolders();
        ASCII_NON_PRINT = Globals.getAsciiNonPrint();
        ASCII_TABLE = Globals.getAsciiStrings();
        exitCode = 0;
        runSpeedPanelExists = false;
    }
}

