/*
 * Decompiled with CFR 0.152.
 */
package rars;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import rars.AssemblyException;
import rars.ErrorList;
import rars.ErrorMessage;
import rars.ProgramStatement;
import rars.SimulationException;
import rars.assembler.Assembler;
import rars.assembler.MacroPool;
import rars.assembler.SourceLine;
import rars.assembler.SymbolTable;
import rars.assembler.TokenList;
import rars.assembler.Tokenizer;
import rars.riscv.hardware.RegisterFile;
import rars.simulator.BackStepper;
import rars.simulator.Simulator;

public class RISCVprogram {
    private boolean steppedExecution = false;
    private String filename;
    private ArrayList<String> sourceList;
    private ArrayList<TokenList> tokenList;
    private ArrayList<ProgramStatement> parsedList;
    private ArrayList<ProgramStatement> machineList;
    private BackStepper backStepper;
    private SymbolTable localSymbolTable;
    private MacroPool macroPool;
    private ArrayList<SourceLine> sourceLineList;
    private Tokenizer tokenizer;

    public ArrayList<String> getSourceList() {
        return this.sourceList;
    }

    public void setSourceLineList(ArrayList<SourceLine> arrayList) {
        this.sourceLineList = arrayList;
        this.sourceList = new ArrayList();
        for (SourceLine sourceLine : arrayList) {
            this.sourceList.add(sourceLine.getSource());
        }
    }

    public ArrayList<SourceLine> getSourceLineList() {
        return this.sourceLineList;
    }

    public String getFilename() {
        return this.filename;
    }

    public ArrayList<TokenList> getTokenList() {
        return this.tokenList;
    }

    public Tokenizer getTokenizer() {
        return this.tokenizer;
    }

    public ArrayList<ProgramStatement> createParsedList() {
        this.parsedList = new ArrayList();
        return this.parsedList;
    }

    public ArrayList<ProgramStatement> getParsedList() {
        return this.parsedList;
    }

    public ArrayList<ProgramStatement> getMachineList() {
        return this.machineList;
    }

    public BackStepper getBackStepper() {
        return this.backStepper;
    }

    public SymbolTable getLocalSymbolTable() {
        return this.localSymbolTable;
    }

    public boolean backSteppingEnabled() {
        return this.backStepper != null && this.backStepper.enabled();
    }

    public String getSourceLine(int n) {
        if (n >= 1 && n <= this.sourceList.size()) {
            return this.sourceList.get(n - 1);
        }
        return null;
    }

    public void fromString(String string) {
        this.filename = string;
        this.sourceList = new ArrayList<String>(Arrays.asList(string.split("\n")));
    }

    public void readSource(String string) throws AssemblyException {
        this.filename = string;
        this.sourceList = new ArrayList();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                this.sourceList.add(string2);
                string2 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            ErrorList errorList = new ErrorList();
            errorList.add(new ErrorMessage(null, 0, 0, exception.toString()));
            throw new AssemblyException(errorList);
        }
    }

    public void tokenize() throws AssemblyException {
        this.tokenizer = new Tokenizer();
        this.tokenList = this.tokenizer.tokenize(this);
        this.localSymbolTable = new SymbolTable(this.filename);
    }

    public ArrayList<RISCVprogram> prepareFilesForAssembly(ArrayList<String> arrayList, String string, String string2) throws AssemblyException {
        ArrayList<RISCVprogram> arrayList2 = new ArrayList<RISCVprogram>();
        int n = 0;
        if (string2 != null && string2.length() > 0) {
            arrayList.add(0, string2);
            n = 1;
        }
        for (String string3 : arrayList) {
            RISCVprogram rISCVprogram = string3.equals(string) ? this : new RISCVprogram();
            rISCVprogram.readSource(string3);
            rISCVprogram.tokenize();
            if (rISCVprogram == this && arrayList2.size() > 0) {
                arrayList2.add(n, rISCVprogram);
                continue;
            }
            arrayList2.add(rISCVprogram);
        }
        return arrayList2;
    }

    public ErrorList assemble(ArrayList<RISCVprogram> arrayList, boolean bl) throws AssemblyException {
        return this.assemble(arrayList, bl, false);
    }

    public ErrorList assemble(ArrayList<RISCVprogram> arrayList, boolean bl, boolean bl2) throws AssemblyException {
        this.backStepper = null;
        Assembler assembler = new Assembler();
        this.machineList = assembler.assemble(arrayList, bl, bl2);
        this.backStepper = new BackStepper();
        return assembler.getErrorList();
    }

    public Simulator.Reason simulate(int n) throws SimulationException {
        Simulator simulator = Simulator.getInstance();
        return simulator.simulate(RegisterFile.getProgramCounter(), n, null);
    }

    public void startSimulation(int n, int[] nArray) {
        Simulator simulator = Simulator.getInstance();
        simulator.startSimulation(RegisterFile.getProgramCounter(), n, nArray);
    }

    public MacroPool createMacroPool() {
        this.macroPool = new MacroPool(this);
        return this.macroPool;
    }

    public MacroPool getLocalMacroPool() {
        return this.macroPool;
    }

    public void setLocalMacroPool(MacroPool macroPool) {
        this.macroPool = macroPool;
    }
}

