/*
 * Decompiled with CFR 0.152.
 */
package rars.assembler;

import java.util.ArrayList;
import rars.ErrorList;
import rars.ErrorMessage;
import rars.assembler.Token;
import rars.assembler.TokenList;
import rars.assembler.TokenTypes;
import rars.riscv.Instruction;

public class OperandFormat {
    static boolean tokenOperandMatch(TokenList tokenList, Instruction instruction, ErrorList errorList) {
        return OperandFormat.numOperandsCheck(tokenList, instruction, errorList) && OperandFormat.operandTypeCheck(tokenList, instruction, errorList);
    }

    static Instruction bestOperandMatch(TokenList tokenList, ArrayList<Instruction> arrayList) {
        if (arrayList == null) {
            return null;
        }
        if (arrayList.size() == 1) {
            return arrayList.get(0);
        }
        for (Instruction instruction : arrayList) {
            if (!OperandFormat.tokenOperandMatch(tokenList, instruction, new ErrorList())) continue;
            return instruction;
        }
        return arrayList.get(0);
    }

    private static boolean numOperandsCheck(TokenList tokenList, Instruction instruction, ErrorList errorList) {
        int n = tokenList.size() - 1;
        int n2 = instruction.getTokenList().size() - 1;
        Token token = tokenList.get(0);
        if (n == n2) {
            return true;
        }
        if (n < n2) {
            String string = "Too few or incorrectly formatted operands. Expected: " + instruction.getExampleFormat();
            OperandFormat.generateMessage(token, string, errorList);
        } else {
            String string = "Too many or incorrectly formatted operands. Expected: " + instruction.getExampleFormat();
            OperandFormat.generateMessage(token, string, errorList);
        }
        return false;
    }

    private static boolean operandTypeCheck(TokenList tokenList, Instruction instruction, ErrorList errorList) {
        for (int i = 1; i < instruction.getTokenList().size(); ++i) {
            Token token = tokenList.get(i);
            Token token2 = instruction.getTokenList().get(i);
            TokenTypes tokenTypes = token.getType();
            TokenTypes tokenTypes2 = token2.getType();
            if (tokenTypes2 == TokenTypes.IDENTIFIER && tokenTypes == TokenTypes.OPERATOR) {
                Token token3 = new Token(TokenTypes.IDENTIFIER, token.getValue(), token.getSourceProgram(), token.getSourceLine(), token.getStartPos());
                tokenList.set(i, token3);
                continue;
            }
            if ((tokenTypes2 == TokenTypes.REGISTER_NAME || tokenTypes2 == TokenTypes.REGISTER_NUMBER) && tokenTypes == TokenTypes.REGISTER_NAME || tokenTypes2 == TokenTypes.REGISTER_NAME && tokenTypes == TokenTypes.REGISTER_NUMBER || tokenTypes2 == TokenTypes.CSR_NAME && (tokenTypes == TokenTypes.INTEGER_5 || tokenTypes == TokenTypes.INTEGER_6 || tokenTypes == TokenTypes.INTEGER_12 || tokenTypes == TokenTypes.INTEGER_20 || tokenTypes == TokenTypes.CSR_NAME) || tokenTypes2 == TokenTypes.INTEGER_6 && tokenTypes == TokenTypes.INTEGER_5 || tokenTypes2 == TokenTypes.INTEGER_12 && tokenTypes == TokenTypes.INTEGER_5 || tokenTypes2 == TokenTypes.INTEGER_20 && tokenTypes == TokenTypes.INTEGER_5 || tokenTypes2 == TokenTypes.INTEGER_12 && tokenTypes == TokenTypes.INTEGER_6 || tokenTypes2 == TokenTypes.INTEGER_20 && tokenTypes == TokenTypes.INTEGER_6 || tokenTypes2 == TokenTypes.INTEGER_20 && tokenTypes == TokenTypes.INTEGER_12 || tokenTypes2 == TokenTypes.INTEGER_32 && tokenTypes == TokenTypes.INTEGER_5 || tokenTypes2 == TokenTypes.INTEGER_32 && tokenTypes == TokenTypes.INTEGER_6 || tokenTypes2 == TokenTypes.INTEGER_32 && tokenTypes == TokenTypes.INTEGER_12 || tokenTypes2 == TokenTypes.INTEGER_32 && tokenTypes == TokenTypes.INTEGER_20) continue;
            if (tokenTypes2 == TokenTypes.INTEGER_5 && tokenTypes == TokenTypes.INTEGER_6 || tokenTypes2 == TokenTypes.INTEGER_5 && tokenTypes == TokenTypes.INTEGER_12 || tokenTypes2 == TokenTypes.INTEGER_5 && tokenTypes == TokenTypes.INTEGER_20 || tokenTypes2 == TokenTypes.INTEGER_5 && tokenTypes == TokenTypes.INTEGER_32 || tokenTypes2 == TokenTypes.INTEGER_6 && tokenTypes == TokenTypes.INTEGER_12 || tokenTypes2 == TokenTypes.INTEGER_6 && tokenTypes == TokenTypes.INTEGER_20 || tokenTypes2 == TokenTypes.INTEGER_6 && tokenTypes == TokenTypes.INTEGER_32 || tokenTypes2 == TokenTypes.INTEGER_12 && tokenTypes == TokenTypes.INTEGER_20 || tokenTypes2 == TokenTypes.INTEGER_12 && tokenTypes == TokenTypes.INTEGER_32 || tokenTypes2 == TokenTypes.INTEGER_20 && tokenTypes == TokenTypes.INTEGER_32) {
                OperandFormat.generateMessage(token, "operand is out of range", errorList);
                return false;
            }
            if (tokenTypes == tokenTypes2) continue;
            OperandFormat.generateMessage(token, "operand is of incorrect type", errorList);
            return false;
        }
        return true;
    }

    private static void generateMessage(Token token, String string, ErrorList errorList) {
        errorList.add(new ErrorMessage(token.getSourceProgram(), token.getSourceLine(), token.getStartPos(), "\"" + token.getValue() + "\": " + string));
    }
}

