/*
 * Decompiled with CFR 0.152.
 */
package rars.riscv;

import rars.ProgramStatement;
import rars.SimulationException;
import rars.riscv.BasicInstructionFormat;
import rars.riscv.Instruction;
import rars.riscv.InstructionSet;

public abstract class BasicInstruction
extends Instruction {
    private String instructionName;
    private BasicInstructionFormat instructionFormat;
    private String operationMask;
    private int opcodeMask;
    private int opcodeMatch;

    public BasicInstruction(String string, String string2, BasicInstructionFormat basicInstructionFormat, String string3) {
        this.exampleFormat = string;
        this.mnemonic = this.extractOperator(string);
        this.description = string2;
        this.instructionFormat = basicInstructionFormat;
        this.operationMask = string3.replaceAll(" ", "");
        if (this.operationMask.length() != 32) {
            System.out.println(string + " mask not " + 32 + " bits!");
        }
        this.opcodeMask = (int)Long.parseLong(this.operationMask.replaceAll("[01]", "1").replaceAll("[^01]", "0"), 2);
        this.opcodeMatch = (int)Long.parseLong(this.operationMask.replaceAll("[^1]", "0"), 2);
    }

    public BasicInstruction(String string, String string2, BasicInstructionFormat basicInstructionFormat, String string3, boolean bl) {
        this(string, string2, basicInstructionFormat, string3);
        if (InstructionSet.rv64 != bl) {
            throw new NullPointerException("rv64");
        }
    }

    public BasicInstruction(String string, BasicInstructionFormat basicInstructionFormat, String string2) {
        this(string, "", basicInstructionFormat, string2);
    }

    public String getOperationMask() {
        return this.operationMask;
    }

    public BasicInstructionFormat getInstructionFormat() {
        return this.instructionFormat;
    }

    public int getOpcodeMask() {
        return this.opcodeMask;
    }

    public int getOpcodeMatch() {
        return this.opcodeMatch;
    }

    public abstract void simulate(ProgramStatement var1) throws SimulationException;
}

